/*
 * #%L
 * Nuiton Web :: Nuiton Security
 * $Id: UserRolesAction.java 229 2012-10-24 12:43:58Z echatellier $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-web/tags/nuiton-web-1.12-beta-2/nuiton-security/src/main/java/org/nuiton/web/security/actions/UserRolesAction.java $
 * %%
 * Copyright (C) 2012 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.web.security.actions;

import java.util.List;

import org.nuiton.topia.TopiaContext;
import org.nuiton.web.SecurityDAOHelper;
import org.nuiton.web.security.SecurityRole;
import org.nuiton.web.security.SecurityRoleDAO;
import org.nuiton.web.security.SecurityUser;
import org.nuiton.web.security.SecurityUserDAO;

public class UserRolesAction extends AbstractAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    protected SecurityUserDAO securityUserDAO;

    protected SecurityRoleDAO securityRoleDAO;

    protected List<SecurityUser> users;

    protected List<SecurityRole> roles;

    protected List<String> userIds;

    @Override
    public String input() throws Exception {
        TopiaContext transaction = rootContext.beginTransaction();
        securityUserDAO = SecurityDAOHelper.getSecurityUserDAO(transaction);
        securityRoleDAO = SecurityDAOHelper.getSecurityRoleDAO(transaction);
        users = securityUserDAO.findAllWithOrder(SecurityUser.LOGIN);
        roles = securityRoleDAO.findAllWithOrder(SecurityRole.NAME);
        transaction.closeContext();
        return super.input();
    }

    public List<SecurityUser> getUsers() {
        return users;
    }

    public List<SecurityRole> getRoles() {
        return roles;
    }

    public void setUserIds(List<String> userIds) {
        this.userIds = userIds;
    }

    @Override
    public String execute() throws Exception {
        String result = super.execute();

        if (userIds == null) {
            result = input();
        } else {
            try {
                TopiaContext transaction = rootContext.beginTransaction();
                securityUserDAO = SecurityDAOHelper.getSecurityUserDAO(transaction);
                securityRoleDAO = SecurityDAOHelper.getSecurityRoleDAO(transaction);
                for (String userId : userIds) {
                    SecurityUser securityUser = securityUserDAO.findByTopiaId(userId);
                    securityUser.clearSecurityRole();

                    String[] roleIds = getParameters("roles-" + userId);
                    if (roleIds != null) {
                        for (String roleId : roleIds) {
                            SecurityRole secuRole = securityRoleDAO.findByTopiaId(roleId);
                            securityUser.addSecurityRole(secuRole);
                        }
                    }
                }
                transaction.commitTransaction();
                transaction.closeContext();
            } catch (Exception ex) {
                addActionError(ex.getMessage());
                result = input();
            }
        }
        return result;
    }
}
