/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.security;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.servlet.AbstractShiroFilter;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.apache.shiro.web.subject.WebSubject;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.web.SecurityDAOHelper;
import org.nuiton.web.security.SecuritySubjectFactory;
import org.nuiton.web.security.SecurityUser;
import org.nuiton.web.security.SecurityUserDAO;
import org.nuiton.web.security.SecurityUserImpl;
import org.nuiton.web.security.SecurityUtil;
import org.nuiton.web.security.TopiaSecurityRealm;

public class SecurityShiroFilter
extends AbstractShiroFilter {
    private static final Log log = LogFactory.getLog(SecurityShiroFilter.class);
    public static final String APP_CONFIG_CONTEXT = SecurityShiroFilter.class.getName() + "#" + ApplicationConfig.class.getName();
    public static final String ROOT_CONTEXT_CONTEXT = SecurityShiroFilter.class.getName() + "#" + TopiaContext.class.getName();
    public static final String ANON_LOGIN = "anonymous";
    public static final String SESSION_SAVED_URL = "savedUrl";
    protected ApplicationConfig config;
    protected TopiaContext rootContext;

    public void init() throws Exception {
        this.config = (ApplicationConfig)this.getServletContext().getAttribute(APP_CONFIG_CONTEXT);
        if (this.config == null) {
            throw new IllegalArgumentException("No APP_CONFIG_CONTEXT attribute found in servlet context");
        }
        this.config.setOption("topia.persistence.classes", SecurityDAOHelper.getImplementationClassesAsString());
        Properties props = this.config.getFlatOptions();
        this.rootContext = TopiaContextFactory.getContext((Properties)props);
        SecurityShiroFilter.initSchema(this.rootContext);
        this.getServletContext().setAttribute(ROOT_CONTEXT_CONTEXT, (Object)this.rootContext);
        if (log.isInfoEnabled()) {
            log.info((Object)"Overriding shiro realms");
        }
        TopiaSecurityRealm realm = new TopiaSecurityRealm(this.rootContext, this.config);
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager((Realm)realm);
        securityManager.setSubjectFactory((SubjectFactory)new SecuritySubjectFactory());
        securityManager.setSessionManager((SessionManager)new DefaultWebSessionManager());
        this.setSecurityManager((WebSecurityManager)securityManager);
        SecurityUtils.setSecurityManager((SecurityManager)securityManager);
    }

    protected static void initSchema(TopiaContext rootContext) throws TopiaException {
        TopiaContext transaction = rootContext.beginTransaction();
        boolean testTable = TopiaUtil.isSchemaExist((TopiaContext)transaction, (String)SecurityUserImpl.class.getName());
        transaction.closeContext();
        if (!testTable) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Create database schema");
            }
            rootContext.createSchema();
            TopiaContext transaction2 = rootContext.beginTransaction();
            SecurityUserDAO securityUserDAO = SecurityDAOHelper.getSecurityUserDAO(transaction2);
            SecurityUser anonUser = (SecurityUser)securityUserDAO.create(new Object[0]);
            anonUser.setLogin(ANON_LOGIN);
            transaction2.commitTransaction();
            transaction2.closeContext();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Table SecurityUser found, skip schema creation");
        }
    }

    protected void doFilterInternal(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws ServletException, IOException {
        WebSubject subjectUser = this.createSubject(servletRequest, servletResponse);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Testing permission for user " + subjectUser.getPrincipal()));
        }
        if (!subjectUser.isAuthenticated()) {
            subjectUser.login((AuthenticationToken)new UsernamePasswordToken(ANON_LOGIN, ""));
        }
        String uri = ((HttpServletRequest)servletRequest).getRequestURI();
        String perm = SecurityUtil.convertToShiroPerm(uri, this.config.getOption("topia.security.separators"));
        if (subjectUser.isPermitted("url" + perm)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User is permitted to access " + perm));
            }
            super.doFilterInternal(servletRequest, servletResponse, chain);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User is NOT permitted to access " + perm));
            }
            if (ANON_LOGIN.equals(subjectUser.getPrincipal())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Redirecting user to login page");
                }
                Session session = subjectUser.getSession();
                HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
                StringBuffer requestURL = new StringBuffer(httpServletRequest.getRequestURL());
                if (httpServletRequest.getQueryString() != null) {
                    requestURL.append('?').append(httpServletRequest.getQueryString());
                }
                session.setAttribute((Object)SESSION_SAVED_URL, (Object)requestURL.toString());
                ((HttpServletResponse)servletResponse).sendRedirect(this.config.getOption("topia.security.loginurl"));
            } else {
                ((HttpServletResponse)servletResponse).sendError(401, "Not authorized to access " + uri);
            }
        }
    }

    public void destroy() {
        block3: {
            super.destroy();
            if (this.rootContext != null) {
                try {
                    this.rootContext.closeContext();
                }
                catch (TopiaException ex) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"Can't close root context", (Throwable)ex);
                }
            }
        }
    }
}

