/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.templates;

import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.eugene.GeneratorUtil;

public enum DbNamingStrategy implements Function<String, String>
{
    CAMEL_CASE(GeneratorUtil::toLowerCaseFirstLetter),
    SNAKE_CASE(DbNamingStrategy::transformSnakeCase);

    private final Function<String, String> strategy;

    private DbNamingStrategy(Function<String, String> strategy) {
        this.strategy = strategy;
    }

    private static String transformSnakeCase(String str) {
        String result;
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        if (str.equals(str.toUpperCase())) {
            result = str.toLowerCase();
        } else {
            StringBuilder builder = new StringBuilder();
            for (char c : str.toCharArray()) {
                if (Character.isUpperCase(c)) {
                    builder.append("_").append(Character.toLowerCase(c));
                    continue;
                }
                builder.append(c);
            }
            result = builder.toString();
        }
        if (result.startsWith("_")) {
            result = result.substring(1);
        }
        return result;
    }

    @Override
    public String apply(String s) {
        return this.strategy.apply(s);
    }
}

