/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.templates;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.AbstractGenerator;
import org.nuiton.eugene.EugeneCoreTagValues;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.topia.persistence.internal.AbstractTopiaDao;
import org.nuiton.topia.templates.TopiaCoreTagValues;
import org.nuiton.topia.templates.TopiaHibernateTagValues;

@Deprecated
public class TopiaGeneratorUtil
extends JavaGeneratorUtil {
    private static final Log log = LogFactory.getLog(TopiaGeneratorUtil.class);
    protected static final TopiaCoreTagValues TOPIA_TAG_VALUES = new TopiaCoreTagValues();
    protected static final TopiaHibernateTagValues TOPIA_HIBERNATE_TAG_VALUES = new TopiaHibernateTagValues();
    public static final String DEPENDENCIES_DAO = "dao";
    public static final String PERSISTENCE_TYPE_HIBERNATE = "hibernate";
    @Deprecated
    public static final String PERSISTENCE_TYPE_LDAP = "ldap";
    public static final String PERSISTENCE_TYPE_DEFAULT = "hibernate";
    public static final String PROPERTY_DEFAULT_PACKAGE = "defaultPackage";
    public static final String DEFAULT_PACKAGE = "org.codelutin.malo";
    public static final String DEFAULT_INHERITANCE_STRATEGY = "union-subclass";
    private static final Set<String> numberTypes = new HashSet<String>();
    private static final Set<String> textTypes = new HashSet<String>();
    private static final Set<String> booleanTypes = new HashSet<String>();
    private static final Set<String> primitiveTypes = new HashSet<String>();
    private static final Map<String, String> primitiveTypeToClass = new HashMap<String, String>();
    private static final String VOID_TYPE = "void";
    public static final Comparator<ObjectModelClass> OBJECT_MODEL_CLASS_COMPARATOR;

    public static String getDefaultPackage(AbstractGenerator<?> generator) {
        String packageName = generator.getProperty(PROPERTY_DEFAULT_PACKAGE);
        if (StringUtils.isBlank((CharSequence)packageName)) {
            packageName = DEFAULT_PACKAGE;
        }
        return packageName;
    }

    public static String getApplicationContextPackage(ObjectModelTransformerToJava transformer, ObjectModel model) {
        String result = transformer.getDefaultPackageName();
        return result;
    }

    public static String getPersistenceContextPackage(ObjectModelTransformerToJava transformer, ObjectModel model) {
        String result = transformer.getDefaultPackageName();
        return result;
    }

    public static String getDaoPackage(ObjectModelTransformerToJava transformer, ObjectModel model) {
        String result = transformer.getDefaultPackageName();
        return result;
    }

    public static String getParentDaoName(ObjectModel model) {
        return "Abstract" + model.getName() + "TopiaDao";
    }

    public static String getParentDaoFqn(ObjectModelTransformerToJava transformer, ObjectModel model) {
        return TopiaGeneratorUtil.getDaoPackage(transformer, model) + "." + TopiaGeneratorUtil.getParentDaoName(model);
    }

    public static String getApplicationContextInterfaceName(ObjectModel model) {
        return model.getName() + "ApplicationContext";
    }

    public static String getApplicationContextAbstractName(ObjectModel model) {
        return "Abstract" + model.getName() + "TopiaApplicationContext";
    }

    public static String getApplicationContextConcreteName(ObjectModel model) {
        return model.getName() + "TopiaApplicationContext";
    }

    public static String getPersistenceContextAbstractName(ObjectModel model) {
        return "Abstract" + model.getName() + "TopiaPersistenceContext";
    }

    public static String getPersistenceContextConcreteName(ObjectModel model) {
        return model.getName() + "TopiaPersistenceContext";
    }

    public static String getPersistenceContextInterfaceName(ObjectModel model) {
        return model.getName() + "PersistenceContext";
    }

    public static String getDaoSupplierInterfaceName(ObjectModel model) {
        return model.getName() + "DaoSupplier";
    }

    public static String getDaoSupplierName(ObjectModel model) {
        return model.getName() + "TopiaDaoSupplier";
    }

    public static String getEntityEnumName(ObjectModel model) {
        return model.getName() + "EntityEnum";
    }

    public static String getEntityAbstractName(ObjectModelClass input) {
        return input.getName() + "Abstract";
    }

    public static String getEntityConcreteName(ObjectModelClass input) {
        return input.getName();
    }

    public static String getAbstractDaoName(ObjectModelClass input) {
        return "Abstract" + input.getName() + "TopiaDao";
    }

    public static String getGeneratedDaoName(ObjectModelClass input) {
        return "Generated" + input.getName() + "TopiaDao";
    }

    public static String getConcreteDaoName(ObjectModelClass input) {
        return input.getName() + "TopiaDao";
    }

    public static String getContractDaoName(ObjectModelClass input) {
        return input.getName() + "Dao";
    }

    public static String getAbstractDaoFqn(ObjectModelClass input) {
        return input.getPackageName() + "." + TopiaGeneratorUtil.getAbstractDaoName(input);
    }

    public static String getGeneratedDaoFqn(ObjectModelClass input) {
        return input.getPackageName() + "." + TopiaGeneratorUtil.getGeneratedDaoName(input);
    }

    public static String getConcreteDaoFqn(ObjectModelClass input) {
        return input.getPackageName() + "." + TopiaGeneratorUtil.getConcreteDaoName(input);
    }

    public static String getEntityPackage(ObjectModelTransformerToJava transformer, ObjectModel model, ObjectModelClassifier input) {
        String result = input.getPackageName();
        return result;
    }

    public static String getPersistenceType(ObjectModelClassifier classifier) {
        String tag = TOPIA_HIBERNATE_TAG_VALUES.getPersistenceTypeTagValue(classifier);
        if (tag == null) {
            tag = "hibernate";
        }
        return tag;
    }

    public static String getReverseDbName(ObjectModelAttribute attr) {
        if (attr.getReverseAttribute() != null) {
            return TopiaGeneratorUtil.getDbName((ObjectModelElement)attr.getReverseAttribute());
        }
        return TopiaGeneratorUtil.getDbName((ObjectModelElement)attr) + "_id";
    }

    public static String getDbName(ObjectModelElement element) {
        if (element == null) {
            return null;
        }
        String value = TOPIA_HIBERNATE_TAG_VALUES.getDbNameTagValue(element);
        if (value != null) {
            return value;
        }
        return TopiaGeneratorUtil.toLowerCaseFirstLetter((String)element.getName());
    }

    public static Set<ObjectModelAttribute> getNaturalIdAttributes(ObjectModelClass clazz) {
        LinkedHashSet<ObjectModelAttribute> results = new LinkedHashSet<ObjectModelAttribute>();
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!TOPIA_HIBERNATE_TAG_VALUES.getNaturalIdTagValue(attr)) continue;
            results.add(attr);
        }
        Collection superclasses = clazz.getSuperclasses();
        for (ObjectModelClass superClass : superclasses) {
            Set<ObjectModelAttribute> naturalIdsOfSuperClass = TopiaGeneratorUtil.getNaturalIdAttributes(superClass);
            results.addAll(naturalIdsOfSuperClass);
        }
        return results;
    }

    public static Set<ObjectModelAttribute> getNotNullAttributes(ObjectModelClass clazz) {
        LinkedHashSet<ObjectModelAttribute> results = new LinkedHashSet<ObjectModelAttribute>();
        for (Object attr : clazz.getAttributes()) {
            if (!TopiaGeneratorUtil.isAttributeNotNull((ObjectModelAttribute)attr)) continue;
            results.add((ObjectModelAttribute)attr);
        }
        Collection superclasses = clazz.getSuperclasses();
        for (ObjectModelClass superClass : superclasses) {
            Set<ObjectModelAttribute> notNullOfSuperClass = TopiaGeneratorUtil.getNotNullAttributes(superClass);
            results.addAll(notNullOfSuperClass);
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            List participantsAttributes = ((ObjectModelAssociationClass)clazz).getParticipantsAttributes();
            results.addAll(participantsAttributes);
        }
        return results;
    }

    public static boolean isAttributeNotNull(ObjectModelAttribute attribute) {
        Boolean value = TOPIA_HIBERNATE_TAG_VALUES.getNotNullTagValue(attribute);
        if (value == null) {
            return TOPIA_HIBERNATE_TAG_VALUES.getNaturalIdTagValue(attribute);
        }
        return value;
    }

    public static String getDOType(ObjectModelElement elem, ObjectModel model) {
        String type = elem.getName();
        if (elem instanceof ObjectModelAttribute) {
            type = ((ObjectModelAttribute)elem).getType();
        }
        if (elem instanceof ObjectModelClass) {
            type = ((ObjectModelClass)elem).getQualifiedName();
        }
        return TopiaGeneratorUtil.getDOType(type, model);
    }

    public static String getDOType(String type, ObjectModel model) {
        if (!model.hasClass(type)) {
            return type;
        }
        ObjectModelClass clazz = model.getClass(type);
        if (TopiaGeneratorUtil.isEntity((ObjectModelClassifier)clazz)) {
            type = type + "Impl";
        }
        return type;
    }

    public static boolean isNumericType(ObjectModelAttribute attr) {
        return numberTypes.contains(attr.getType());
    }

    public static boolean isTextType(ObjectModelAttribute attr) {
        return textTypes.contains(attr.getType());
    }

    public static boolean isDateType(ObjectModelAttribute attr) {
        return "java.util.Date".equals(attr.getType());
    }

    public static boolean isBooleanType(ObjectModelAttribute attr) {
        return booleanTypes.contains(attr.getType());
    }

    public static boolean isPrimitiveType(ObjectModelAttribute attr) {
        return primitiveTypes.contains(attr.getType());
    }

    public static String getClassForPrimitiveType(ObjectModelAttribute attr) {
        Preconditions.checkState((boolean)TopiaGeneratorUtil.isPrimitiveType(attr));
        String className = primitiveTypeToClass.get(attr.getType());
        Preconditions.checkNotNull((Object)className);
        return className;
    }

    public static boolean hasUnidirectionalRelationOnAbstractType(ObjectModelAttribute attr, ObjectModel model) {
        ObjectModelClass clazz;
        ObjectModelAttribute reverse = attr.getReverseAttribute();
        if (reverse != null && TopiaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr) && !TopiaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse) && !reverse.isNavigable() && (clazz = model.getClass(attr.getType())) != null && TopiaGeneratorUtil.isEntity((ObjectModelClassifier)clazz)) {
            for (ObjectModelClass subClass : model.getClasses()) {
                if (!subClass.getSuperclasses().contains(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getManyToManyTableName(ObjectModelAttribute attr) {
        String revers;
        String name;
        String result = attr.hasAssociationClass() ? TopiaGeneratorUtil.getDbName((ObjectModelElement)attr.getAssociationClass()) : ((name = attr.getName()).compareToIgnoreCase(revers = attr.getReverseAttributeName()) < 0 ? name + '_' + revers : revers + '_' + name);
        return result.toLowerCase();
    }

    public static String getNMultiplicityHibernateType(ObjectModelAttribute attr) {
        if (JavaGeneratorUtil.isOrdered((ObjectModelAttribute)attr)) {
            return "list";
        }
        if (EugeneCoreTagValues.isUnique((ObjectModelAttribute)attr)) {
            return "set";
        }
        return "bag";
    }

    public static List<ObjectModelClass> getEntityClasses(ObjectModel model, boolean sort) {
        return TopiaGeneratorUtil.getClassesByStereotype(TopiaCoreTagValues.Store.entity.getName(), model, sort);
    }

    public static List<ObjectModelClass> getClassesByStereotype(String stereotype, ObjectModel model, boolean sort) {
        ArrayList<ObjectModelClass> classes = new ArrayList<ObjectModelClass>();
        for (ObjectModelClass clazz : model.getClasses()) {
            if (!clazz.hasStereotype(stereotype)) continue;
            classes.add(clazz);
        }
        if (sort && !classes.isEmpty()) {
            Collections.sort(classes, OBJECT_MODEL_CLASS_COMPARATOR);
        }
        return classes;
    }

    public static List<String> getImports(ObjectModelClass aClass, String ... incomingFqns) {
        HashSet<String> tmp = new HashSet<String>();
        tmp.addAll(Arrays.asList(incomingFqns));
        TopiaGeneratorUtil.getImports(aClass, tmp);
        List<String> result = TopiaGeneratorUtil.cleanImports(aClass.getPackageName(), tmp);
        return result;
    }

    protected static void getImports(ObjectModelClass aClass, Set<String> fqns) {
        for (ObjectModelAttribute attr : aClass.getAttributes()) {
            fqns.add(attr.getType());
            if (!TopiaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) continue;
            String collectionType = TopiaGeneratorUtil.getCollectionType((ObjectModelAttribute)attr).getName();
            fqns.add(collectionType);
            String collectionObject = TopiaGeneratorUtil.getCollectionInstanceType((ObjectModelAttribute)attr).getName();
            fqns.add(collectionObject);
        }
        for (Object attribute : aClass.getAllOtherAttributes()) {
            fqns.add(attribute.getType());
        }
        if (aClass instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)aClass;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr == null) continue;
                fqns.add(attr.getType());
                if (!TopiaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) continue;
                String collectionType = TopiaGeneratorUtil.getCollectionType((ObjectModelAttribute)attr).getName();
                fqns.add(collectionType);
                String collectionObject = TopiaGeneratorUtil.getCollectionInstanceType((ObjectModelAttribute)attr).getName();
                fqns.add(collectionObject);
            }
        }
        for (ObjectModelOperation operation : aClass.getOperations()) {
            TopiaGeneratorUtil.getImports(operation, fqns);
        }
        for (ObjectModelInterface modelInterface : aClass.getInterfaces()) {
            fqns.add(modelInterface.getQualifiedName());
            TopiaGeneratorUtil.getImports(modelInterface, fqns);
        }
        for (ObjectModelClass modelClass : aClass.getSuperclasses()) {
            fqns.add(modelClass.getQualifiedName());
            TopiaGeneratorUtil.getImports(modelClass, new String[0]);
        }
    }

    protected static void getImports(ObjectModelInterface anInterface, Set<String> fqns) {
        for (ObjectModelOperation operation : anInterface.getOperations()) {
            TopiaGeneratorUtil.getImports(operation, fqns);
        }
        for (ObjectModelInterface modelInterface : anInterface.getInterfaces()) {
            fqns.add(modelInterface.getQualifiedName());
            TopiaGeneratorUtil.getImports(modelInterface, fqns);
        }
    }

    protected static void getImports(ObjectModelOperation operation, Set<String> fqns) {
        String fqn = operation.getReturnType();
        fqns.add(fqn);
        for (ObjectModelParameter parameter : operation.getParameters()) {
            fqns.add(parameter.getType());
        }
    }

    protected static List<String> cleanImports(String packageName, Set<String> fqns) {
        fqns.removeAll(primitiveTypes);
        fqns.remove(VOID_TYPE);
        int packageLength = packageName.length();
        ArrayList<String> genericType = new ArrayList<String>();
        Iterator<String> it = fqns.iterator();
        while (it.hasNext()) {
            String fqn = it.next();
            int lastIndex = fqn.lastIndexOf(".");
            if (lastIndex == packageLength && fqn.startsWith(packageName)) {
                it.remove();
                continue;
            }
            int genericIndex = fqn.indexOf(60);
            if (genericIndex == -1) continue;
            genericType.add(fqn.substring(0, genericIndex));
            it.remove();
        }
        fqns.addAll(genericType);
        ArrayList<String> result = new ArrayList<String>(fqns);
        Collections.sort(result);
        return result;
    }

    public static Map<ObjectModelClass, Set<ObjectModelClass>> searchDirectUsages(ObjectModel model) {
        List<ObjectModelClass> allEntities = TopiaGeneratorUtil.getEntityClasses(model, true);
        TreeMap<String, ObjectModelClass> allEntitiesByFQN = new TreeMap<String, ObjectModelClass>();
        LinkedHashMap<ObjectModelClass, Set<ObjectModelClass>> usages = new LinkedHashMap<ObjectModelClass, Set<ObjectModelClass>>();
        for (ObjectModelClass klass : allEntities) {
            usages.put(klass, new HashSet());
            allEntitiesByFQN.put(klass.getQualifiedName(), klass);
        }
        for (ObjectModelClass klass : allEntities) {
            TopiaGeneratorUtil.searchDirectUsages(klass, allEntitiesByFQN, usages);
        }
        allEntities.clear();
        allEntitiesByFQN.clear();
        return usages;
    }

    public static void searchDirectUsages(ObjectModelClass klass, Map<String, ObjectModelClass> allEntitiesByFQN, Map<ObjectModelClass, Set<ObjectModelClass>> usages) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("for entity " + klass.getQualifiedName()));
        }
        for (ObjectModelAttribute attr : klass.getAttributes()) {
            String type;
            if (!attr.isNavigable() || !allEntitiesByFQN.containsKey(type = attr.hasAssociationClass() ? attr.getAssociationClass().getQualifiedName() : attr.getType())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)(" uses " + type));
            }
            ObjectModelClass targetEntity = allEntitiesByFQN.get(type);
            Set<ObjectModelClass> classes = usages.get(targetEntity);
            classes.add(klass);
        }
    }

    public static boolean isImportNeeded(Collection<ObjectModelOperation> operations, String importName) {
        if (CollectionUtils.isNotEmpty(operations)) {
            for (ObjectModelOperation op : operations) {
                if (op.getReturnType().contains(importName)) {
                    return true;
                }
                for (ObjectModelParameter param : op.getParameters()) {
                    if (!param.getType().contains(importName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isCollectionNeeded(Collection<ObjectModelOperation> operations) {
        return TopiaGeneratorUtil.isImportNeeded(operations, Collection.class.getSimpleName());
    }

    public static boolean isSetNeeded(Collection<ObjectModelOperation> operations) {
        return TopiaGeneratorUtil.isImportNeeded(operations, Set.class.getSimpleName());
    }

    public static boolean isEntity(ObjectModelAttribute attribute, ObjectModel model) {
        if (TopiaGeneratorUtil.isPrimitiveType(attribute)) {
            return false;
        }
        String attributeType = attribute.getType();
        ObjectModelClassifier typeclassifier = model.getClassifier(attributeType);
        return typeclassifier != null && TopiaGeneratorUtil.isEntity(typeclassifier);
    }

    public static boolean isEntity(ObjectModelClassifier classifier) {
        return TOPIA_TAG_VALUES.isEntity(classifier, null) && !classifier.isEnum();
    }

    public static String getInheritanceStrategy(ObjectModelClassifier classifier) {
        String value = TOPIA_HIBERNATE_TAG_VALUES.getInheritanceStrategyTagValue(classifier, null);
        if (value == null) {
            value = DEFAULT_INHERITANCE_STRATEGY;
        }
        return value;
    }

    @Deprecated
    public static String getLegacyDaoName(ObjectModelClass input) {
        return input.getName() + "DAO";
    }

    @Deprecated
    public static <Type extends ObjectModelElement> Collection<Type> getElementsWithStereotype(Collection<Type> elements, String ... stereotypes) {
        ArrayList<ObjectModelElement> result = new ArrayList<ObjectModelElement>();
        for (ObjectModelElement element : elements) {
            if (!TopiaGeneratorUtil.hasStereotypes(element, stereotypes)) continue;
            result.add(element);
        }
        return result;
    }

    @Deprecated
    public static boolean hasStereotypes(ObjectModelElement element, String ... stereotypes) {
        for (String stereotype : stereotypes) {
            if (element.hasStereotype(stereotype)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static String getPrimaryKeyAttributesListDeclaration(ObjectModelClass clazz, boolean includeName) {
        Collection<ObjectModelAttribute> attributeCollection = TopiaGeneratorUtil.getElementsWithStereotype(clazz.getAttributes(), TopiaCoreTagValues.Store.primaryKey.getName());
        ArrayList attributes = Lists.newArrayList();
        for (ObjectModelAttribute attr : attributeCollection) {
            String attribute = attr.getType();
            if (includeName) {
                attribute = attribute + ' ';
                attribute = attribute + attr.getName();
            }
            attributes.add(attribute);
        }
        return Joiner.on((String)", ").join((Iterable)attributes);
    }

    @Deprecated
    public static boolean isAssociationClassDoublon(ObjectModelAttribute attr) {
        return attr.getReverseAttribute() != null && attr.getDeclaringElement().equals(attr.getReverseAttribute().getDeclaringElement()) && !GeneratorUtil.isFirstAttribute((ObjectModelAttribute)attr);
    }

    @Deprecated
    public static List<String> getImports(ObjectModelInterface anInterface, String ... incomingFqns) {
        HashSet<String> tmp = new HashSet<String>();
        tmp.addAll(Arrays.asList(incomingFqns));
        TopiaGeneratorUtil.getImports(anInterface, tmp);
        List<String> result = TopiaGeneratorUtil.cleanImports(anInterface.getPackageName(), tmp);
        return result;
    }

    @Deprecated
    public static boolean hasNothingOrAbstractMethods(ObjectModelClass clazz) {
        boolean result = true;
        Iterator operations = clazz.getOperations().iterator();
        while (result && operations.hasNext()) {
            ObjectModelOperation op = (ObjectModelOperation)operations.next();
            result = op.isAbstract();
        }
        return result;
    }

    @Deprecated
    public static boolean shouldBeAbstract(ObjectModelClass clazz) {
        return clazz != null && clazz.isAbstract() && TopiaGeneratorUtil.hasNothingOrAbstractMethods(clazz);
    }

    @Deprecated
    public static Class<?> getDAOImplementation(ObjectModel model) {
        Class result;
        String daoImpl = TOPIA_TAG_VALUES.getDaoImplementationTagValue(model);
        if (StringUtils.isEmpty((CharSequence)daoImpl)) {
            result = AbstractTopiaDao.class;
        } else {
            try {
                result = Class.forName(daoImpl);
            }
            catch (ClassNotFoundException e) {
                String message = "Could not find dao implementation named " + daoImpl;
                log.error((Object)message);
                throw new IllegalStateException(message, e);
            }
        }
        return result;
    }

    static {
        primitiveTypeToClass.put("byte", "java.lang.Byte");
        primitiveTypeToClass.put("short", "java.lang.Short");
        primitiveTypeToClass.put("int", "java.lang.Integer");
        primitiveTypeToClass.put("long", "java.lang.Long");
        primitiveTypeToClass.put("float", "java.lang.Float");
        primitiveTypeToClass.put("double", "java.lang.Double");
        primitiveTypeToClass.put("char", "java.lang.Char");
        primitiveTypeToClass.put("boolean", "java.lang.Boolean");
        numberTypes.add("byte");
        numberTypes.add("java.lang.Byte");
        numberTypes.add("Byte");
        numberTypes.add("short");
        numberTypes.add("java.lang.Short");
        numberTypes.add("Short");
        numberTypes.add("int");
        numberTypes.add("java.lang.Integer");
        numberTypes.add("Integer");
        numberTypes.add("long");
        numberTypes.add("java.lang.Long");
        numberTypes.add("Long");
        numberTypes.add("float");
        numberTypes.add("java.lang.Float");
        numberTypes.add("Float");
        numberTypes.add("double");
        numberTypes.add("java.lang.Double");
        numberTypes.add("Double");
        textTypes.add("char");
        textTypes.add("java.lang.Char");
        textTypes.add("Char");
        textTypes.add("java.lang.String");
        textTypes.add("String");
        booleanTypes.add("boolean");
        booleanTypes.add("java.lang.Boolean");
        booleanTypes.add("Boolean");
        primitiveTypes.addAll(numberTypes);
        primitiveTypes.addAll(textTypes);
        primitiveTypes.addAll(booleanTypes);
        OBJECT_MODEL_CLASS_COMPARATOR = new Comparator<ObjectModelClass>(){

            @Override
            public int compare(ObjectModelClass o1, ObjectModelClass o2) {
                return o1.getQualifiedName().compareTo(o2.getQualifiedName());
            }
        };
    }
}

