package org.nuiton.topia.templates;

/*
 * #%L
 * ToPIA :: Templates
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */





import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.topia.persistence.internal.AbstractTopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.EntityOperator;

import java.util.Properties;

/**
 * To generate PersistenceHelper
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.templates.ApplicationContextTransformer"
 * @since 3.0
 */
public class ApplicationContextTransformer extends ObjectModelTransformerToJava {

    protected TopiaTemplateHelper templateHelper;

    protected TopiaTagValues topiaTagValues;

    @Override
    public void transformFromModel(ObjectModel input) {

        if (templateHelper == null) {
            templateHelper = new TopiaTemplateHelper(model);
        }
        if (topiaTagValues == null) {
            topiaTagValues = templateHelper.getTopiaTagValues();
        }

        String packageName = templateHelper.getApplicationContextPackage(this, model);

        String applicationContextAbstractName = templateHelper.getApplicationContextAbstractName(model);

        String applicationContextConcreteName = templateHelper.getApplicationContextConcreteName(model);

        boolean generateAbstract = !isInClassPath(packageName, applicationContextAbstractName);

        boolean generateConcrete = !isInClassPath(packageName, applicationContextConcreteName);

        if (generateAbstract) {

            generateAbstract(packageName,
                             applicationContextAbstractName);
        }

        if (generateConcrete) {

            generateImpl(packageName,
                         applicationContextAbstractName,
                         applicationContextConcreteName);
        }

    }

    protected void generateAbstract(String packageName,
                                    String className) {

        // try to find a super class by tag-value
        String superClass = topiaTagValues.getApplicationContextSuperClassTagValue(model);

        if (superClass == null) {

            // no super-class, use default one
            superClass = AbstractTopiaApplicationContext.class.getName();
        }else {

            //TODO check that super class instance of ApplicationPersistenceContext

        }

        ObjectModelClass output = createAbstractClass(className, packageName);

        String persistenceContextConcreteName = templateHelper.getPersistenceContextConcreteName(model);
        setSuperClass(output, superClass + "<" + persistenceContextConcreteName + ">");

        // detect if there is a contract to set on abstract
        String contractName = templateHelper.getApplicationContextInterfaceName(model);

        boolean addPersistenceContextContract = isInClassPath(packageName, contractName);

        if (addPersistenceContextContract) {
            addInterface(output, packageName + "." + contractName);
        }

        String modelName = model.getName();

        String entityEnumName = modelName + "EntityEnum";

        boolean generateOperator =
                topiaTagValues.getGenerateOperatorForDAOHelperTagValue(model);

        addImport(output, TopiaEntity.class);

        if (generateOperator) {
            addImport(output, EntityOperator.class);
        }

        addConstructors(output, false);

        ObjectModelOperation op;

        // getModelVersion method
        op = addOperation(output, "newPersistenceContext", persistenceContextConcreteName, ObjectModelJavaModifier.PUBLIC);
        addAnnotation(output, op, Override.class);
        setOperationBody(op, ""
+"\n"
+"        "+persistenceContextConcreteName+" newContext = new "+persistenceContextConcreteName+"(\n"
+"                getHibernateProvider(), getTopiaFiresSupport(), getTopiaIdFactory(), getSessionRegistry());\n"
+"        registerPersistenceContext(newContext);\n"
+"        return newContext;\n"
+"    "
        );

        // getModelVersion method
        String modelVersion = model.getVersion();
        op = addOperation(output, "getModelVersion", "String", ObjectModelJavaModifier.PUBLIC);
        addAnnotation(output, op, Override.class);
        setOperationBody(op, ""
+"\n"
+"        return \""+modelVersion+"\";\n"
+"    "
        );

        // getModelName method
        op = addOperation(output, "getModelName", "String", ObjectModelJavaModifier.PUBLIC);
        addAnnotation(output, op, Override.class);
        setOperationBody(op, ""
+"\n"
+"        return \""+modelName+"\";\n"
+"    "
        );

        // getContractClass method
        op = addOperation(output, "getContractClass", "<T extends TopiaEntity> Class<T>", ObjectModelJavaModifier.PUBLIC);
        addAnnotation(output, op, Override.class);
        addParameter(op, "Class<T>", "klass");
        setOperationBody(op, ""
+"\n"
+"        return "+entityEnumName+".getContractClass(klass);\n"
+"    "
        );

        // getContractClasses method
        op = addOperation(output, "getContractClasses", "Class<? extends TopiaEntity>[]", ObjectModelJavaModifier.PUBLIC);
        addAnnotation(output, op, Override.class);
        setOperationBody(op, ""
+"\n"
+"        return "+entityEnumName+".getContractClasses();\n"
+"    "
        );

        // getImplementationClass method
        op = addOperation(output, "getImplementationClass", "<T extends TopiaEntity> Class<T>", ObjectModelJavaModifier.PUBLIC);
        addAnnotation(output, op, Override.class);
        addParameter(op, "Class<T>", "klass");
        setOperationBody(op, ""
+"\n"
+"        return "+entityEnumName+".getImplementationClass(klass);\n"
+"    "
        );

        // getImplementationClasses method
        op = addOperation(output, "getImplementationClasses", "Class<? extends TopiaEntity>[]", ObjectModelJavaModifier.PUBLIC);
        addAnnotation(output, op, Override.class);
        setOperationBody(op, ""
+"\n"
+"        return "+entityEnumName+".getImplementationClasses();\n"
+"    "
        );

        // getContracts method
        op = addOperation(output, "getContracts", entityEnumName + "[]", ObjectModelJavaModifier.PUBLIC);
        setOperationBody(op, ""
+"\n"
+"        return "+entityEnumName+".getContracts();\n"
+"    "
        );

        if (generateOperator) {
            // getOperator method
            op = addOperation(output, "getOperator", "<T extends TopiaEntity> EntityOperator<T>", ObjectModelJavaModifier.PUBLIC);
            addParameter(op, "Class<T>", "klass");
            setOperationBody(op, ""
+"\n"
+"        return "+entityEnumName+".getOperator(klass);\n"
+"    "
            );
        }
    }

    protected ObjectModelClass generateImpl(String packageName,
                                            String applicationContextAbstractName,
                                            String applicationContextConcreteName) {

        ObjectModelClass output = createClass(applicationContextConcreteName, packageName);

        setSuperClass(output, applicationContextAbstractName);

        addConstructors(output, true);
        return output;
    }

    protected void addConstructors(ObjectModelClass output, boolean isPublic) {

        ObjectModelJavaModifier visibility = isPublic ?
                                             ObjectModelJavaModifier.PUBLIC :
                                             ObjectModelJavaModifier.PROTECTED;

        ObjectModelOperation constructor = addConstructor(output, visibility);
        addParameter(constructor, Properties.class, "properties");
        setOperationBody(constructor, ""
+"\n"
+"        super(properties);\n"
+"    "
        );

        constructor = addConstructor(output, visibility);
        addParameter(constructor, "java.util.Map<String, String>", "configuration");
        setOperationBody(constructor, ""
+"\n"
+"        super(configuration);\n"
+"    "
        );
    }

}
