/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.sql.batch.tables;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.service.sql.batch.tables.TopiaSqlTable;

public class TopiaSqlTables
implements Iterable<TopiaSqlTable> {
    protected final ImmutableMap<String, TopiaSqlTable> tablesByFullyTableName;
    protected final ImmutableSet<TopiaSqlTable> orderedTables;

    public TopiaSqlTables(ImmutableMap<String, TopiaSqlTable> tablesByFullyTableName, ImmutableSet<TopiaSqlTable> orderedTables) {
        this.tablesByFullyTableName = tablesByFullyTableName;
        this.orderedTables = orderedTables;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static BuilderStepOnTable builder(TopiaEntityEnum mainEntityEnum) {
        return TopiaSqlTables.builder().addMainTable(mainEntityEnum);
    }

    public TopiaSqlTable getTable(String key) {
        return (TopiaSqlTable)this.tablesByFullyTableName.get((Object)key);
    }

    @Override
    public Iterator<TopiaSqlTable> iterator() {
        return this.orderedTables.iterator();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("orderedTables", this.orderedTables).toString();
    }

    protected static class BuilderImpl
    implements Builder {
        protected final TreeMap<String, TopiaSqlTable> tablesByFullyTableName = new TreeMap();
        protected final TreeMap<Integer, TopiaSqlTable> tablesByOrder = new TreeMap();
        protected int internalOrder;

        @Override
        public BuilderStepOnTable addMainTable(TopiaEntityEnum entityEnum) {
            String schemaName = entityEnum.dbSchemaName().toLowerCase();
            String tableName = entityEnum.dbTableName().toLowerCase();
            String whereClauseAlias = tableName + ".topiaid";
            String fromClause = schemaName + "." + tableName + " " + tableName;
            this.registerTable(schemaName, tableName, whereClauseAlias, fromClause, (ImmutableSet<String>)ImmutableSet.of());
            return new BuilderStepOnTableImpl(null, entityEnum);
        }

        @Override
        public TopiaSqlTables build() {
            ArrayList orders = Lists.newArrayList(this.tablesByOrder.keySet());
            Collections.sort(orders);
            ImmutableSet.Builder orderedTablesBuilder = ImmutableSet.builder();
            for (Integer order : orders) {
                orderedTablesBuilder.add((Object)this.tablesByOrder.get(order));
            }
            return new TopiaSqlTables((ImmutableMap<String, TopiaSqlTable>)ImmutableMap.copyOf(this.tablesByFullyTableName), (ImmutableSet<TopiaSqlTable>)orderedTablesBuilder.build());
        }

        protected Builder registerTable(String schemaName, String tableName, String whereClauseAlias, String fromClause, ImmutableSet<String> joinClauses) {
            TopiaSqlTable table = new TopiaSqlTable(schemaName, tableName, fromClause, whereClauseAlias, joinClauses);
            this.tablesByFullyTableName.put(table.getFullyTableName(), table);
            this.tablesByOrder.put(this.internalOrder++, table);
            return this;
        }

        protected TopiaSqlTable getTable(String key) {
            return this.tablesByFullyTableName.get(key);
        }

        protected TopiaSqlTable getTable(TopiaEntityEnum entityEnum) {
            String key = this.getFullyTableName(entityEnum);
            return this.tablesByFullyTableName.get(key);
        }

        protected String getFullyTableName(TopiaEntityEnum entityEnum) {
            return entityEnum.dbSchemaName().toLowerCase() + "." + entityEnum.dbTableName().toLowerCase();
        }

        protected String getAssociationTableName(String tableName, String parentTableName) {
            String associationTableName = tableName.compareTo(parentTableName) < 0 ? tableName + "_" + parentTableName : parentTableName + "_" + tableName;
            return associationTableName;
        }

        protected class BuilderStepOnTableImpl
        implements Builder,
        BuilderStepOnTable {
            protected final BuilderStepOnTableImpl parent;
            protected final TopiaEntityEnum tableEntityEnum;

            protected BuilderStepOnTableImpl(BuilderStepOnTableImpl parent, TopiaEntityEnum tableEntityEnum) {
                this.parent = parent;
                this.tableEntityEnum = tableEntityEnum;
            }

            @Override
            public BuilderStepOnTable addMainTable(TopiaEntityEnum entityEnum) {
                return BuilderImpl.this.addMainTable(entityEnum);
            }

            @Override
            public TopiaSqlTables build() {
                return BuilderImpl.this.build();
            }

            @Override
            public BuilderStepOnTable addJoinTable(TopiaEntityEnum entityEnum) {
                ImmutableSet<String> joinClauses;
                String fromClause;
                String whereClauseAlias;
                TopiaSqlTable parentTable = this.getTable();
                String schemaName = entityEnum.dbSchemaName().toLowerCase();
                String tableName = entityEnum.dbTableName().toLowerCase();
                String parentTableName = parentTable.getTableName();
                if (this.parent == null) {
                    whereClauseAlias = tableName + "." + parentTableName;
                    fromClause = schemaName + "." + tableName + " " + tableName;
                    joinClauses = ImmutableSet.of();
                } else {
                    whereClauseAlias = parentTable.getWhereClauseAlias();
                    fromClause = parentTable.getFromClause();
                    String joinClause = " INNER JOIN " + schemaName + "." + tableName + " " + tableName + " ON " + tableName + "." + parentTableName + " = " + parentTableName + ".topiaId";
                    joinClauses = this.addJoinCause(parentTable.getJoinClauses(), joinClause);
                }
                BuilderImpl.this.registerTable(schemaName, tableName, whereClauseAlias, fromClause, joinClauses);
                return this;
            }

            @Override
            public BuilderStepOnTable addAndEnterJoinTable(TopiaEntityEnum entityEnum) {
                this.addJoinTable(entityEnum);
                return new BuilderStepOnTableImpl(this, entityEnum);
            }

            @Override
            public BuilderStepOnTable addReverseJoinTable(TopiaEntityEnum entityEnum) {
                TopiaSqlTable parentTable = this.getTable();
                String schemaName = entityEnum.dbSchemaName().toLowerCase();
                String tableName = entityEnum.dbTableName().toLowerCase();
                String whereClauseAlias = parentTable.getWhereClauseAlias();
                String fromClause = parentTable.getFromClause();
                String parentTableName = parentTable.getTableName();
                String joinClause = " INNER JOIN " + schemaName + "." + tableName + " " + tableName + " ON " + tableName + ".topiaId = " + parentTableName + "." + tableName;
                ImmutableSet<String> joinClauses = this.addJoinCause(parentTable.getJoinClauses(), joinClause);
                BuilderImpl.this.registerTable(schemaName, tableName, whereClauseAlias, fromClause, joinClauses);
                this.invertOrderWithParent(parentTable, entityEnum);
                return this;
            }

            @Override
            public BuilderStepOnTable addAndEnterReverseJoinTable(TopiaEntityEnum entityEnum) {
                this.addReverseJoinTable(entityEnum);
                return new BuilderStepOnTableImpl(this, entityEnum);
            }

            @Override
            public BuilderStepOnTable addAssociationTable(String associationName) {
                ImmutableSet<String> joinClauses;
                boolean addInnerJoin;
                TopiaSqlTable parentTable = this.getTable();
                String schemaName = this.tableEntityEnum.dbSchemaName().toLowerCase();
                String tableName = BuilderImpl.this.getAssociationTableName(associationName.toLowerCase(), parentTable.getTableName());
                String whereClauseAlias = parentTable.getWhereClauseAlias();
                String fromClause = parentTable.getFromClause();
                if (parentTable.getJoinClauses().isEmpty()) {
                    fromClause = schemaName + "." + tableName;
                }
                boolean bl = addInnerJoin = this.parent != null;
                if (addInnerJoin) {
                    String parentTableName = parentTable.getTableName();
                    String joinClause = " INNER JOIN " + schemaName + "." + tableName + " " + tableName + " ON " + tableName + "." + parentTableName + " = " + parentTableName + ".topiaId";
                    joinClauses = this.addJoinCause(parentTable.getJoinClauses(), joinClause);
                } else {
                    joinClauses = parentTable.getJoinClauses();
                }
                BuilderImpl.this.registerTable(schemaName, tableName, whereClauseAlias, fromClause, joinClauses);
                return this;
            }

            @Override
            public BuilderStepOnTable backToParent() {
                Preconditions.checkState((this.parent != null ? 1 : 0) != 0, (Object)"Could not find a parent table");
                return this.parent;
            }

            @Override
            public BuilderStepOnTable backToTable(TopiaEntityEnum entityEnum) {
                BuilderStepOnTable table;
                if (Objects.equals(this.tableEntityEnum, entityEnum)) {
                    table = this;
                } else {
                    Preconditions.checkState((this.parent != null ? 1 : 0) != 0, (Object)("Could not find a perent table of type: " + entityEnum));
                    table = this.parent.backToTable(entityEnum);
                }
                return table;
            }

            @Override
            public BuilderStepOnTable checkCurrentTable(TopiaEntityEnum entityEnum) {
                Preconditions.checkState((boolean)this.tableEntityEnum.equals(entityEnum), (Object)("Current table should be " + entityEnum + ", but was " + this.tableEntityEnum));
                return this;
            }

            protected TopiaSqlTable getTable() {
                return BuilderImpl.this.getTable(this.tableEntityEnum);
            }

            protected int getTableOrder(TopiaSqlTable table) {
                for (Map.Entry<Integer, TopiaSqlTable> entry : BuilderImpl.this.tablesByOrder.entrySet()) {
                    if (!table.equals(entry.getValue())) continue;
                    return entry.getKey();
                }
                throw new IllegalStateException("Could not find table " + table.getFullyTableName());
            }

            protected void invertOrderWithParent(TopiaSqlTable parentTable, TopiaEntityEnum entityEnum) {
                int parentTableOrder = this.getTableOrder(parentTable);
                TopiaSqlTable table = BuilderImpl.this.getTable(entityEnum);
                int tableOrder = this.getTableOrder(table);
                BuilderImpl.this.tablesByOrder.put(parentTableOrder, table);
                BuilderImpl.this.tablesByOrder.put(tableOrder, parentTable);
            }

            protected ImmutableSet<String> addJoinCause(ImmutableSet<String> joinClauses, String joinClause) {
                return ImmutableSet.builder().addAll(joinClauses).add((Object)joinClause).build();
            }
        }
    }

    public static interface BuilderStepOnTable
    extends Builder {
        public BuilderStepOnTable addJoinTable(TopiaEntityEnum var1);

        public BuilderStepOnTable addAndEnterJoinTable(TopiaEntityEnum var1);

        public BuilderStepOnTable addReverseJoinTable(TopiaEntityEnum var1);

        public BuilderStepOnTable addAndEnterReverseJoinTable(TopiaEntityEnum var1);

        public BuilderStepOnTable addAssociationTable(String var1);

        public BuilderStepOnTable backToParent();

        public BuilderStepOnTable backToTable(TopiaEntityEnum var1);

        public BuilderStepOnTable checkCurrentTable(TopiaEntityEnum var1);
    }

    public static interface Builder {
        public BuilderStepOnTable addMainTable(TopiaEntityEnum var1);

        public TopiaSqlTables build();
    }
}

