/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.sql.batch.tables;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;

public class TopiaSqlTable {
    protected final String schemaName;
    protected final String tableName;
    protected final String fullyTableName;
    protected final String fromClause;
    protected final String whereClauseAlias;
    protected final ImmutableSet<String> joinClauses;

    public TopiaSqlTable(String schemaName, String tableName, String fromClause, String whereClauseAlias, ImmutableSet<String> joinClauses) {
        this.schemaName = schemaName.toLowerCase();
        this.tableName = tableName.toLowerCase();
        this.fullyTableName = this.schemaName + "." + this.tableName;
        this.fromClause = fromClause;
        this.whereClauseAlias = whereClauseAlias;
        this.joinClauses = joinClauses;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getFullyTableName() {
        return this.fullyTableName;
    }

    public String getFromClause() {
        return this.fromClause;
    }

    public String getWhereClauseAlias() {
        return this.whereClauseAlias;
    }

    public String getWhereClause(ImmutableSet<String> ids) {
        String result = this.whereClauseAlias;
        if (ids.size() == 1) {
            result = result + " = ?";
        } else {
            String in = "";
            for (String ignored : ids) {
                in = in + ", ?";
            }
            result = result + " IN (" + in.substring(2) + ")";
        }
        return result;
    }

    public ImmutableSet<String> getJoinClauses() {
        return this.joinClauses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopiaSqlTable that = (TopiaSqlTable)o;
        return Objects.equals(this.fullyTableName, that.fullyTableName);
    }

    public int hashCode() {
        return Objects.hash(this.fullyTableName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fullyTableName", (Object)this.fullyTableName).toString();
    }
}

