/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication.operation;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaPersistenceContext;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.replication.TopiaReplicationContext;
import org.nuiton.topia.replication.TopiaReplicationOperation;
import org.nuiton.topia.replication.model.ReplicationLink;
import org.nuiton.topia.replication.model.ReplicationModel;
import org.nuiton.topia.replication.model.ReplicationNode;
import org.nuiton.topia.replication.model.ReplicationOperationDef;
import org.nuiton.topia.replication.model.ReplicationOperationPhase;

public class LoadLink
implements TopiaReplicationOperation {
    private static final Log log = LogFactory.getLog(LoadLink.class);

    @Override
    public void register(ReplicationModel model, ReplicationNode ownerNode, ReplicationOperationPhase phase, Object ... parameters) {
    }

    @Override
    public void run(TopiaReplicationContext replicationContext, ReplicationOperationDef operationDef, TopiaPersistenceContext srcCtxt, TopiaPersistenceContext dstCtxt, List<? extends TopiaEntity> nodeEntities) throws TopiaException {
        ReplicationLink link = (ReplicationLink)operationDef.getParameters()[0];
        String name = link.getName();
        ReplicationNode ownerNode = link.getSource();
        if (!ownerNode.equals(operationDef.getNode())) {
            throw new IllegalStateException(String.format("The source node of loading association requires the node %1$s, but was %2$s.", operationDef.getNode(), ownerNode));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("currentNode : " + String.valueOf(operationDef.getNode()) + " , link to load : " + String.valueOf(link)));
        }
        EntityOperator<? super TopiaEntity> ownerOperator = ownerNode.getOperator();
        for (TopiaEntity topiaEntity : nodeEntities) {
            int size = ownerOperator.sizeChild(name, topiaEntity);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("load association '" + name + "' on " + String.valueOf(topiaEntity) + " : " + size));
        }
    }
}

