/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication;

import java.util.ArrayList;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.replication.TopiaReplicationOperation;
import org.nuiton.topia.replication.TopiaReplicationOperationUndoable;
import org.nuiton.topia.replication.model.ReplicationOperationDef;

public class TopiaReplicationOperationProvider {
    private static final Log log = LogFactory.getLog(TopiaReplicationOperationProvider.class);
    protected TopiaReplicationOperation[] operations;

    public TopiaReplicationOperation[] getOperations() {
        if (this.operations == null) {
            ServiceLoader<TopiaReplicationOperation> loader = ServiceLoader.load(TopiaReplicationOperation.class);
            ArrayList<TopiaReplicationOperation> operations = new ArrayList<TopiaReplicationOperation>();
            for (TopiaReplicationOperation op : loader) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("detected operation " + String.valueOf(op)));
                }
                operations.add(op);
            }
            this.operations = operations.toArray(new TopiaReplicationOperation[operations.size()]);
        }
        return this.operations;
    }

    public TopiaReplicationOperation getOperation(Class<? extends TopiaReplicationOperation> operationClass) {
        TopiaEntityHelper.checkNotNull((String)"getOperation", (String)"operationClass", operationClass);
        TopiaReplicationOperation result = null;
        for (TopiaReplicationOperation op : this.getOperations()) {
            if (!operationClass.isAssignableFrom(op.getClass())) continue;
            result = op;
            break;
        }
        return result;
    }

    public TopiaReplicationOperation getOperation(ReplicationOperationDef operationDef) {
        TopiaEntityHelper.checkNotNull((String)"getOperation", (String)"operationDef", (Object)operationDef);
        return this.getOperation(operationDef.getOperationClass());
    }

    public TopiaReplicationOperationUndoable getUndoableOperation(ReplicationOperationDef operationDef) throws IllegalArgumentException {
        TopiaReplicationOperation operation = this.getOperation(operationDef);
        if (!(operation instanceof TopiaReplicationOperationUndoable)) {
            throw new IllegalArgumentException("the operation " + String.valueOf(operation) + " is not undoable");
        }
        return (TopiaReplicationOperationUndoable)operation;
    }
}

