/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication.operation;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.replication.TopiaReplicationContext;
import org.nuiton.topia.replication.TopiaReplicationOperationUndoable;
import org.nuiton.topia.replication.model.ReplicationModel;
import org.nuiton.topia.replication.model.ReplicationNode;
import org.nuiton.topia.replication.model.ReplicationOperationDef;
import org.nuiton.topia.replication.model.ReplicationOperationPhase;

public class Duplicate
implements TopiaReplicationOperationUndoable {
    private static final Log log = LogFactory.getLog(Duplicate.class);

    @Override
    public void register(ReplicationModel model, ReplicationNode ownerNode, ReplicationOperationPhase phase, Object ... parameters) throws UnsupportedOperationException {
    }

    @Override
    public void run(TopiaReplicationContext replicationContext, ReplicationOperationDef operationDef, TopiaContextImplementor srcCtxt, TopiaContextImplementor dstCtxt, List<? extends TopiaEntity> entities) throws TopiaException {
        srcCtxt.getHibernate().clear();
        srcCtxt.replicateEntities((TopiaContext)dstCtxt, entities);
        dstCtxt.commitTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(ReplicationOperationDef operationDef, TopiaReplicationContext replicationContext, TopiaContextImplementor dstCtxt) throws Exception {
        List<String> ids = replicationContext.getEntityIds(operationDef.getNode());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        Class<? extends TopiaEntity> entityClass = operationDef.getEntityType();
        TopiaDAO dao = dstCtxt.getDAO(entityClass);
        List allIds = dao.findAllIds();
        try {
            for (String id : ids) {
                if (!allIds.contains(id)) continue;
                log.info((Object)("Will delete " + id));
                TopiaEntity entity = dao.findByTopiaId(id);
                dao.delete(entity);
            }
        }
        finally {
            allIds.clear();
            dstCtxt.commitTransaction();
        }
    }
}

