/*
 * #%L
 * ToPIA :: Service Replication
 * 
 * $Id: AttachDependency.java 1964 2010-05-20 10:41:48Z fdesbois $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.4/topia-service-replication/src/main/java/org/nuiton/topia/replication/operation/AttachDependency.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.replication.operation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.replication.TopiaReplicationOperation;
import org.nuiton.topia.replication.model.ReplicationModel;
import org.nuiton.topia.replication.model.ReplicationNode;
import org.nuiton.topia.replication.model.ReplicationOperationDef;
import org.nuiton.topia.replication.model.ReplicationOperationPhase;

import java.util.List;
import java.util.Map;

import static org.nuiton.i18n.I18n._;

/**
 * Pour attacher une dependance.
 * <p/>
 * TODO non implante pour le moment
 * <p/>
 * Note : cette operation est interne, et n'est pas creable par l'utilisateur
 * via la methode {@link #register(ReplicationModel, ReplicationNode,
 * ReplicationOperationPhase, Object...)}.
 *
 * @author chemit
 */
public class AttachDependency implements TopiaReplicationOperation {

    private static final Log log = LogFactory.getLog(AttachDependency.class);

    @Override
    public void register(ReplicationModel model, ReplicationNode ownerNode, ReplicationOperationPhase phase, Object... parameters) {
        throw new UnsupportedOperationException(_("topia.replication.operation.error.uncreatable", getClass()));
    }

    @Override
    public void run(ReplicationOperationDef operationDef,
                    TopiaContextImplementor srcCtxt,
                    TopiaContextImplementor dstCtxt,
                    List<? extends TopiaEntity> nodeEntities,
                    Map<Class<? extends TopiaEntity>, List<String>> data) throws TopiaException {

        throw new UnsupportedOperationException(_("topia.replication.operation.error.notImplemented", getClass()));

        //TODO non implante pour le moment
//        ReplicationNode ownerNode = operationDef.getNode();
//
//        String[] names = (String[]) operationDef.getParameters();
//
//        EntityOperator<? super TopiaEntity> ownerOperator = ownerNode.getOperator();
//
//        List<? extends TopiaEntity> ownerEntities = data.get(ownerOperator.getClazz());
//
//        if (ownerEntities == null || ownerEntities.isEmpty()) {
//            // pas de donnees a traiter
//            log.info(_("topia.replication.attachAssociation.nothing.to.do", ownerOperator));
//            return;
//        }
//
//        boolean shouldCommit = false;
//        for (String name : names) {
//
//            // le noeud de l'entite dont on veut reattacher des associations
//            ReplicationNode targetNode = ownerNode.getAssociations().get(name);
//
//            List<TopiaEntity> targets = data.get(targetNode.getContract().getContract());
//            List<String> targetIds = TopiaEntityHelper.getTopiaIdList(targets);
//            targets.clear();
//
//
//            for (TopiaEntity src : ownerEntities) {
//
//                // les association connues
//                TopiaEntity target = (TopiaEntity) ownerOperator.get(name, src);
//
//                if (target == null || !targetIds.contains(target.getTopiaId())) {
//                    // pas de donnees a attacher, ou pas pour ce src
//                    continue;
//                }
//
//                // l'entite cible
//                TopiaEntity dst = dstCtxt.findByTopiaId(src.getTopiaId());
//
//                target = dstCtxt.findByTopiaId(target.getTopiaId());
//
//                ownerOperator.set(name, dst, target);
//
//                dst.update();
//                shouldCommit = true;
//
//            }
//        }
//        if (shouldCommit) {
//            dstCtxt.commitTransaction();
//        }
    }
}
