/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.topia.event.TopiaContextEvent;
import org.nuiton.topia.event.TopiaContextListener;
import org.nuiton.topia.event.TopiaTransactionEvent;
import org.nuiton.topia.event.TopiaTransactionVetoable;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.migration.MigrationServiceException;
import org.nuiton.topia.migration.MigrationServiceImpl;
import org.nuiton.topia.migration.TopiaMigrationService;
import org.nuiton.topia.migration.callback.MigrationCallbackHandler;
import org.nuiton.util.Version;

@Deprecated
public class TopiaMigrationServiceImpl
extends MigrationServiceImpl
implements TopiaMigrationService,
TopiaContextListener,
TopiaTransactionVetoable {
    private static final Log log = LogFactory.getLog(TopiaMigrationServiceImpl.class);
    public static final String MIGRATION_APPLICATION_VERSION = "topia.service.migration.version";
    public static final String MIGRATION_PREVIOUS_MAPPING_DIRECTORY = "topia.service.migration.mappingsdir";
    public static final String MIGRATION_MODEL_NAMES = "topia.service.migration.modelnames";
    public static final String MIGRATION_CALLBACKHANDLERS = "topia.service.migration.callbackhandlers";
    protected static final String TOPIA_PERSISTENCE_DIRECTORIES = "topia.persistence.directories";
    protected static final String TOPIA_PERSISTENCE_CLASSES = "topia.persistence.classes";

    public Class<?>[] getPersistenceClasses() {
        return null;
    }

    public String getServiceName() {
        return "migration";
    }

    public boolean preInit(TopiaContextImplementor context) {
        String[] tabCallbackHandlers;
        String[] classes;
        String[] dirs;
        Properties config = context.getConfig();
        String mappingdir = config.getProperty(MIGRATION_PREVIOUS_MAPPING_DIRECTORY, null);
        String applicationversion = config.getProperty(MIGRATION_APPLICATION_VERSION, null);
        Configuration hibernateConfiguration = new Configuration();
        for (String dir : dirs = config.getProperty(TOPIA_PERSISTENCE_DIRECTORIES, "").split(",")) {
            if ("".equals(dir = dir.trim())) continue;
            hibernateConfiguration.addDirectory(new File(dir));
        }
        String listPersistenceClasses = config.getProperty(TOPIA_PERSISTENCE_CLASSES, "");
        for (String classname : classes = listPersistenceClasses.split(",")) {
            if ("".equals(classname = classname.trim())) continue;
            try {
                Class<?> clazz = Class.forName(classname);
                hibernateConfiguration.addClass(clazz);
            }
            catch (ClassNotFoundException eee) {
                log.error((Object)("Persistent class " + classname + " not found"), (Throwable)eee);
            }
        }
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)hibernateConfiguration.getProperties());
        prop.putAll((Map<?, ?>)config);
        hibernateConfiguration.setProperties(prop);
        this.setConfiguration(hibernateConfiguration);
        if (applicationversion == null) {
            log.error((Object)"'topia.service.migration.version' not set.");
        } else {
            this.setApplicationVersion(applicationversion);
        }
        String callbackHandlers = config.getProperty(MIGRATION_CALLBACKHANDLERS, "");
        for (String callbackHandler : tabCallbackHandlers = callbackHandlers.split(",")) {
            if ("".equals(callbackHandler = callbackHandler.trim())) continue;
            try {
                Class<?> clazz = Class.forName(callbackHandler);
                MigrationCallbackHandler instance = (MigrationCallbackHandler)clazz.newInstance();
                this.addMigrationCallbackHandler(instance);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("CallbackHandler Class " + callbackHandler + " not found"), (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Object)("CallbackHandler class " + callbackHandler + " cannot be instanciated"), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)("CallbackHandler class " + callbackHandler + " cannot be accessed"), (Throwable)e);
            }
        }
        context.addTopiaContextListener((TopiaContextListener)this);
        context.addTopiaTransactionVetoable((TopiaTransactionVetoable)this);
        if (mappingdir == null) {
            log.error((Object)"'topia.service.migration.mappingsdir' not set.");
        } else if (applicationversion != null) {
            String[] modelnames;
            String modelnamesList = config.getProperty(MIGRATION_MODEL_NAMES, "");
            for (String modelname : modelnames = modelnamesList.split(",")) {
                this.setMappingsDirectory(mappingdir + "/" + modelname);
                boolean complete = false;
                try {
                    complete = this.migrateSchema();
                }
                catch (MigrationServiceException e) {
                    log.error((Object)"Can't migrate schema", (Throwable)e);
                }
                if (complete) continue;
                if (log.isDebugEnabled()) {
                    log.error((Object)"Database migration not complete");
                }
                throw new TopiaRuntimeException("Database migration not succesfully ended !");
            }
        }
        return true;
    }

    public boolean postInit(TopiaContextImplementor context) {
        return true;
    }

    public void postCreateSchema(TopiaContextEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"postCreateSchema event called : put version in database");
        }
        TopiaContextImplementor context = (TopiaContextImplementor)event.getSource();
        String versionStr = context.getConfig().getProperty(MIGRATION_APPLICATION_VERSION, null);
        Version version = new Version(versionStr);
        this.putVersionInDatabase(context.getConfig(), version, true);
    }

    public void postUpdateSchema(TopiaContextEvent event) {
    }

    public void preCreateSchema(TopiaContextEvent event) {
    }

    public void preUpdateSchema(TopiaContextEvent event) {
    }

    public void preRestoreSchema(TopiaContextEvent event) {
    }

    public void postRestoreSchema(TopiaContextEvent event) {
        block3: {
            if (log.isInfoEnabled()) {
                log.info((Object)"postRestoreSchema event detected, redo, schema migration");
            }
            try {
                this.migrateSchema();
            }
            catch (MigrationServiceException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"postRestoreSchema schema migration failed", (Throwable)e);
            }
        }
    }

    public void beginTransaction(TopiaTransactionEvent event) {
        TopiaContextImplementor context = (TopiaContextImplementor)event.getSource();
        context.addTopiaContextListener((TopiaContextListener)this);
    }
}

