/*
 * #%L
 * ToPIA :: Service Migration
 * 
 * $Id: SimpleProxyClass.java 2010 2010-06-13 18:18:35Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.4/topia-service-migration/src/main/java/org/nuiton/topia/migration/common/SimpleProxyClass.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.migration.common;

import org.nuiton.topia.migration.TopiaMigrationEngine;

import java.util.StringTokenizer;

/**
 * SimpleProxyClass.java
 *
 * @author Chatellier Eric
 * @author Chevallereau Benjamin
 * @author Eon Sébastien
 * @author Trève Vincent
 * @deprecated since 2.3.4, please use now the simplify service {@link TopiaMigrationEngine}
 */
@Deprecated
public class SimpleProxyClass implements ProxyClass {

    /**
     * le nom long (avec package)
     */
    private String canonicalName;
    /**
     * le nom cours
     */
    private String name;

    /**
     * Contructeur avec nom long
     * @param canonicalName le nom avec package
     */
    public SimpleProxyClass(String canonicalName) {
        this.canonicalName = canonicalName;
        StringTokenizer tokenizer = new StringTokenizer(canonicalName, ".");
        name = null;
        while (tokenizer.hasMoreTokens()) {
            name = tokenizer.nextToken();
        }
    }

    @Override
    public String getCanonicalName() {
        return canonicalName;
    }

    public String getShortClassName() {
        return name;
    }

    @Override
    public int hashCode() {
        return canonicalName.hashCode();
    }

    @Override
    public ProxyClass clone() {
        return new SimpleProxyClass(canonicalName);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ProxyClass) {
            ProxyClass o = (ProxyClass) other;
            return o.getCanonicalName().equals(canonicalName);
        }
        return false;
    }

    @Override
    public String toString() {
        return canonicalName;
    }
}
