/* *##% 
 * ToPIA :: Service History
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/

/* *
 * HistoryImpl.java
 *
 * Created: 13 oct. 06 20:55:44
 *
 * @author poussin
 * @version $Revision: 1459 $
 *
 * Last update: $Date: 2009-05-16 09:56:47 +0200 (Sat, 16 May 2009) $
 * by : $Author: tchemit $
 */

package org.nuiton.topia.history.entities;

import org.nuiton.topia.history.NoHistory;
import org.nuiton.topia.persistence.TopiaId;
import org.nuiton.topia.security.util.TopiaSecurityUtil;

/**
 * @author poussin
 *
 */
public class HistoryImpl extends HistoryAbstract implements NoHistory {

    private static final long serialVersionUID = 1L;

    /* (non-Javadoc)
     * @see org.nuiton.topia.security.entities.authorization.History#setAction(java.lang.String)
     */
    @Override
    public void setAction(String action) {
        int val = TopiaSecurityUtil.actionsString2Int(action);
        setAction(val);
    }

    /* (non-Javadoc)
     * @see org.nuiton.topia.security.entities.authorization.History#setTypeAndTarget(java.lang.String)
     */
    @Override
    public void setTypeAndTarget(String target) {
        String newType = TopiaId.getClassNameAsString(target);
        setType(newType);
        setTarget(target);
    }
}


