/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.history.entities.History;
import org.nuiton.topia.history.entities.HistoryDAO;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;

public class TopiaHistoryDAOHelper {
    public static final String entitiesList = "org.nuiton.topia.history.entities.HistoryImpl";

    protected TopiaHistoryDAOHelper() {
    }

    public static HistoryDAO getHistoryDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        HistoryDAO result = (HistoryDAO)ci.getDAO(History.class);
        return result;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        TopiaHistoryEntityEnum constant = TopiaHistoryEntityEnum.valueOf(klass);
        TopiaDAO dao = ci.getDAO(constant.getContract());
        return (D)dao;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        TopiaHistoryEntityEnum constant = TopiaHistoryEntityEnum.valueOf(entity);
        TopiaDAO dao = ci.getDAO(constant.getContract());
        return (D)dao;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        TopiaHistoryEntityEnum constant = TopiaHistoryEntityEnum.valueOf(klass);
        return constant.getContract();
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        TopiaHistoryEntityEnum constant = TopiaHistoryEntityEnum.valueOf(klass);
        return constant.getImplementation();
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        TopiaHistoryEntityEnum[] values = TopiaHistoryEntityEnum.values();
        Class[] result = (Class[])Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        TopiaHistoryEntityEnum[] values = TopiaHistoryEntityEnum.values();
        Class[] result = (Class[])Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : TopiaHistoryDAOHelper.getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }

    public static TopiaHistoryEntityEnum[] getContracts() {
        return TopiaHistoryEntityEnum.values();
    }

    public static enum TopiaHistoryEntityEnum implements TopiaEntityEnum
    {
        History(History.class);

        private Class<? extends TopiaEntity> contract;
        private String implementationFQN;
        private Class<? extends TopiaEntity> implementation;

        private TopiaHistoryEntityEnum(Class<? extends TopiaEntity> contract) {
            this.contract = contract;
            this.implementationFQN = contract.getName() + "Impl";
        }

        public Class<? extends TopiaEntity> getContract() {
            return this.contract;
        }

        @Deprecated
        public Class<? extends TopiaEntity> getContractClass() {
            return this.getContract();
        }

        @Deprecated
        public Class<? extends TopiaEntity> getImplementationClass() {
            return this.getImplementation();
        }

        public String getImplementationFQN() {
            return this.implementationFQN;
        }

        public synchronized void setImplementationFQN(String implementationFQN) {
            this.implementationFQN = implementationFQN;
            this.implementation = null;
        }

        public boolean accept(Class<? extends TopiaEntity> klass) {
            return TopiaHistoryDAOHelper.getContractClass(klass) == this.contract;
        }

        public Class<? extends TopiaEntity> getImplementation() {
            if (this.implementation == null) {
                try {
                    this.implementation = Class.forName(this.implementationFQN);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not find class " + this.implementationFQN);
                }
            }
            return this.implementation;
        }

        public static TopiaHistoryEntityEnum valueOf(TopiaEntity entity) {
            return TopiaHistoryEntityEnum.valueOf(entity.getClass());
        }

        public static TopiaHistoryEntityEnum valueOf(Class<?> klass) {
            if (klass.isInterface()) {
                return TopiaHistoryEntityEnum.valueOf(klass.getSimpleName());
            }
            for (TopiaHistoryEntityEnum entityEnum : TopiaHistoryEntityEnum.values()) {
                if (!entityEnum.getContract().isAssignableFrom(klass)) continue;
                return entityEnum;
            }
            throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString((Object[])TopiaHistoryEntityEnum.values()));
        }
    }
}

