/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal.support;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaConfiguration;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaService;
import org.nuiton.topia.persistence.support.TopiaServiceSupport;

public class TopiaServiceSupportImpl
implements TopiaServiceSupport {
    private static final Log log = LogFactory.getLog(TopiaServiceSupportImpl.class);
    protected ImmutableMap<String, TopiaService> services;

    public void initServices(TopiaApplicationContext topiaApplicationContext) {
        TopiaConfiguration topiaConfiguration = topiaApplicationContext.getConfiguration();
        Map<String, Class<? extends TopiaService>> declaredServices = topiaConfiguration.getDeclaredServices();
        HashMap<String, TopiaService> services = new HashMap<String, TopiaService>();
        for (Map.Entry<String, Class<? extends TopiaService>> entry : declaredServices.entrySet()) {
            String serviceName = entry.getKey();
            Class<? extends TopiaService> serviceClass = entry.getValue();
            try {
                TopiaService newInstance;
                TopiaService service1 = newInstance = serviceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                services.put(serviceName, service1);
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("instantiated service " + serviceName + ": " + String.valueOf(service1)));
            }
            catch (InstantiationException e) {
                throw new TopiaException("unable to instantiate service class " + String.valueOf(serviceClass), e);
            }
            catch (IllegalAccessException e) {
                throw new TopiaException("unable to instantiate service class " + String.valueOf(serviceClass), e);
            }
            catch (InvocationTargetException e) {
                throw new TopiaException("unable to instantiate service class " + String.valueOf(serviceClass), e);
            }
            catch (NoSuchMethodException e) {
                throw new TopiaException("unable to instantiate service class " + String.valueOf(serviceClass), e);
            }
        }
        Map<String, Map<String, String>> declaredServicesConfiguration = topiaConfiguration.getDeclaredServicesConfiguration();
        for (Map.Entry entry : services.entrySet()) {
            String serviceName = (String)entry.getKey();
            TopiaService topiaService = (TopiaService)entry.getValue();
            Map<String, String> serviceConfiguration = declaredServicesConfiguration.get(serviceName);
            if (serviceConfiguration == null) {
                serviceConfiguration = Collections.emptyMap();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("will init service " + serviceName + " with configuration " + String.valueOf(serviceConfiguration)));
            }
            topiaService.initTopiaService(topiaApplicationContext, serviceConfiguration);
        }
        this.services = ImmutableMap.copyOf(services);
    }

    @Override
    public Map<String, TopiaService> getServices() {
        return this.services;
    }

    @Override
    public <T extends TopiaService> Map<String, T> getServices(Class<T> interfaceService) {
        LinkedHashMap<String, TopiaService> result = new LinkedHashMap<String, TopiaService>();
        for (Map.Entry entry : this.services.entrySet()) {
            String serviceName = (String)entry.getKey();
            TopiaService service = (TopiaService)entry.getValue();
            if (!interfaceService.isAssignableFrom(service.getClass())) continue;
            result.put(serviceName, service);
        }
        return result;
    }
}

