/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.HqlAndParametersBuilder;
import org.nuiton.topia.persistence.QueryMissingOrderException;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaDaoSupplier;
import org.nuiton.topia.persistence.TopiaEntities;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.TopiaIdFactory;
import org.nuiton.topia.persistence.TopiaNoResultException;
import org.nuiton.topia.persistence.TopiaNonUniqueResultException;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaStep;
import org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryStep;
import org.nuiton.topia.persistence.event.TopiaEntityListener;
import org.nuiton.topia.persistence.event.TopiaEntityVetoable;
import org.nuiton.topia.persistence.internal.support.TopiaFiresSupport;
import org.nuiton.topia.persistence.internal.support.TopiaHibernateEventListener;
import org.nuiton.topia.persistence.pager.FilterRuleGroupOperator;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;
import org.nuiton.topia.persistence.support.TopiaJpaSupport;
import org.nuiton.topia.persistence.support.TopiaSqlSupport;
import org.nuiton.topia.persistence.util.TopiaUtil;
import org.nuiton.util.pagination.PaginationOrder;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;

public abstract class AbstractTopiaDao<E extends TopiaEntity>
implements TopiaDao<E> {
    private static Log log = LogFactory.getLog(AbstractTopiaDao.class);
    protected static final Function<PaginationOrder, String> PAGINATION_ORDER_TO_HQL = new Function<PaginationOrder, String>(){

        public String apply(PaginationOrder input) {
            String result = String.format("%s %s", input.getClause(), input.isDesc() ? "DESC" : "ASC");
            return result;
        }
    };
    protected int batchSize = 1000;
    protected TopiaJpaSupport topiaJpaSupport;
    protected TopiaHibernateSupport topiaHibernateSupport;
    protected TopiaSqlSupport topiaSqlSupport;
    protected TopiaIdFactory topiaIdFactory;
    protected TopiaFiresSupport topiaFiresSupport;
    protected TopiaDaoSupplier topiaDaoSupplier;

    public abstract TopiaEntityEnum getTopiaEntityEnum();

    @Override
    public abstract Class<E> getEntityClass();

    public void init(TopiaJpaSupport topiaJpaSupport, TopiaHibernateSupport topiaHibernateSupport, TopiaSqlSupport topiaSqlSupport, TopiaIdFactory topiaIdFactory, TopiaFiresSupport topiaFiresSupport, TopiaDaoSupplier topiaDaoSupplier) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init dao for " + this.getEntityClass()));
        }
        this.topiaJpaSupport = topiaJpaSupport;
        this.topiaHibernateSupport = topiaHibernateSupport;
        this.topiaSqlSupport = topiaSqlSupport;
        this.topiaIdFactory = topiaIdFactory;
        this.topiaFiresSupport = topiaFiresSupport;
        this.topiaDaoSupplier = topiaDaoSupplier;
    }

    public TopiaFiresSupport getTopiaFiresSupport() {
        return this.topiaFiresSupport;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    protected String newFromClause() {
        return this.newFromClause(null);
    }

    protected String newFromClause(String alias) {
        String hql = "from " + this.getTopiaEntityEnum().getImplementationFQN();
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            hql = hql + " " + alias;
        }
        return hql;
    }

    @Override
    public E newInstance() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("entityClass = " + this.getEntityClass()));
        }
        Class<? extends TopiaEntity> implementation = this.getTopiaEntityEnum().getImplementation();
        try {
            TopiaEntity newInstance = implementation.newInstance();
            TopiaHibernateEventListener.attachContext(newInstance, this.topiaDaoSupplier, this.topiaFiresSupport);
            return (E)newInstance;
        }
        catch (InstantiationException e) {
            throw new TopiaException("Impossible de trouver ou d'instancier la classe " + implementation);
        }
        catch (IllegalAccessException e) {
            throw new TopiaException("Impossible de trouver ou d'instancier la classe " + implementation);
        }
    }

    @Override
    public E newInstance(Map<String, Object> properties) {
        E result = this.newInstance();
        try {
            for (Map.Entry<String, Object> e : properties.entrySet()) {
                String propertyName = e.getKey();
                Object value = e.getValue();
                PropertyUtils.setProperty(result, (String)propertyName, (Object)value);
            }
        }
        catch (IllegalAccessException eee) {
            throw new IllegalArgumentException("Can't put properties on new Object", eee);
        }
        catch (InvocationTargetException eee) {
            throw new IllegalArgumentException("Can't put properties on new Object", eee);
        }
        catch (NoSuchMethodException eee) {
            throw new IllegalArgumentException("Can't put properties on new Object", eee);
        }
        return result;
    }

    @Override
    public E newInstance(String propertyName, Object propertyValue, Object ... otherPropertyNamesAndValues) {
        Map<String, Object> properties = TopiaUtil.convertPropertiesArrayToMap(propertyName, propertyValue, otherPropertyNamesAndValues);
        return this.newInstance(properties);
    }

    @Override
    public PaginationResult<E> initPagination(int pageSize) {
        PaginationResult<E> result = this.initPagination(this.newFromClause(), new HashMap<String, Object>(), pageSize);
        return result;
    }

    @Override
    public PaginationResult<E> initPagination(String hql, Map<String, Object> params, int pageSize) {
        PaginationParameter firstPage = PaginationParameter.of((int)0, (int)pageSize);
        if (this.hqlContainsOrderBy(hql)) {
            hql = hql.substring(0, hql.toLowerCase().indexOf("order by"));
        }
        String countCondition = "*";
        if (this.hqlStartsWithSelect(hql)) {
            int selectIndex = hql.toLowerCase().indexOf("select");
            int fromIndex = hql.toLowerCase().indexOf("from");
            String selectCondition = hql.toLowerCase().substring(selectIndex + "select".length(), fromIndex);
            if (selectCondition.contains("distinct")) {
                Preconditions.checkState((!selectCondition.replaceAll(" ", "").toLowerCase().contains("distinct(") ? 1 : 0) != 0, (Object)"This method needs to run count(...), but Hibernate does not support \"select count(distinct(name))\", please use \"select distinct name\" (without brackets)");
                countCondition = selectCondition;
            }
            hql = hql.substring(fromIndex);
        }
        String countHql = String.format("SELECT COUNT(%s) %s", countCondition, hql);
        long count = this.count(countHql, params);
        ArrayList emptyList = Lists.newArrayList();
        PaginationResult result = PaginationResult.of((List)emptyList, (long)count, (PaginationParameter)firstPage);
        return result;
    }

    @Override
    public void addTopiaEntityListener(TopiaEntityListener listener) {
        this.topiaFiresSupport.addTopiaEntityListener(this.getEntityClass(), listener);
    }

    @Override
    public void addTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.topiaFiresSupport.addTopiaEntityVetoable(this.getEntityClass(), vetoable);
    }

    @Override
    public void removeTopiaEntityListener(TopiaEntityListener listener) {
        this.topiaFiresSupport.removeTopiaEntityListener(this.getEntityClass(), listener);
    }

    @Override
    public void removeTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.topiaFiresSupport.removeTopiaEntityVetoable(this.getEntityClass(), vetoable);
    }

    @Override
    public E create(E entity) {
        if (StringUtils.isBlank((CharSequence)entity.getTopiaId())) {
            String topiaId = this.topiaIdFactory.newTopiaId(this.getEntityClass(), (TopiaEntity)entity);
            entity.setTopiaId(topiaId);
        }
        if (entity instanceof TopiaEntityContextable) {
            TopiaEntityContextable contextable = (TopiaEntityContextable)entity;
            contextable.setTopiaDaoSupplier(this.topiaDaoSupplier);
        }
        this.topiaJpaSupport.save(entity);
        this.topiaFiresSupport.notifyEntityCreated((TopiaEntity)entity);
        return entity;
    }

    @Override
    public E create(String propertyName, Object propertyValue, Object ... otherPropertyNamesAndValues) {
        Map<String, Object> properties = TopiaUtil.convertPropertiesArrayToMap(propertyName, propertyValue, otherPropertyNamesAndValues);
        E result = this.create(properties);
        return result;
    }

    @Override
    public E create(Map<String, Object> properties) {
        E result = this.newInstance(properties);
        this.create(result);
        return result;
    }

    @Override
    public E create() {
        E result = this.newInstance();
        this.create(result);
        return result;
    }

    @Override
    public Iterable<E> createAll(Iterable<E> entities) {
        for (TopiaEntity entity : entities) {
            this.create(entity);
        }
        return entities;
    }

    @Override
    public E update(E entity) {
        this.topiaJpaSupport.saveOrUpdate(entity);
        this.topiaFiresSupport.notifyEntityUpdated((TopiaEntity)entity);
        return entity;
    }

    @Override
    public Iterable<E> updateAll(Iterable<E> entities) {
        for (TopiaEntity entity : entities) {
            this.update(entity);
        }
        return entities;
    }

    @Override
    public void delete(E entity) {
        this.topiaJpaSupport.delete(entity);
        entity.notifyDeleted();
        this.topiaFiresSupport.notifyEntityDeleted((TopiaEntity)entity);
    }

    @Override
    public void deleteAll(Iterable<E> entities) {
        for (TopiaEntity entity : entities) {
            this.delete(entity);
        }
    }

    protected HqlAndParametersBuilder<E> newHqlAndParametersBuilder(FilterRuleGroupOperator filterRuleGroupOperator) {
        HqlAndParametersBuilder<E> result = new HqlAndParametersBuilder<E>(this.getEntityClass(), filterRuleGroupOperator);
        return result;
    }

    protected HqlAndParametersBuilder<E> newHqlAndParametersBuilder() {
        return this.newHqlAndParametersBuilder(FilterRuleGroupOperator.AND);
    }

    protected HqlAndParametersBuilder<E> getHqlForProperties(String propertyName, Object propertyValue, Object ... otherPropertyNamesAndValues) {
        Map<String, Object> properties = TopiaUtil.convertPropertiesArrayToMap(propertyName, propertyValue, otherPropertyNamesAndValues);
        HqlAndParametersBuilder<E> result = this.getHqlForProperties(properties);
        return result;
    }

    protected HqlAndParametersBuilder<E> getHqlForNoConstraint() {
        Map<String, Object> properties = Collections.emptyMap();
        HqlAndParametersBuilder<E> result = this.getHqlForProperties(properties);
        return result;
    }

    protected HqlAndParametersBuilder<E> getHqlForProperties(Map<String, Object> properties) {
        HqlAndParametersBuilder<E> result = this.newHqlAndParametersBuilder();
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            result.addEquals(property.getKey(), property.getValue());
        }
        return result;
    }

    protected InnerTopiaQueryBuilderRunQueryStep<E> forHql(String hql) {
        Map<String, Object> properties = Collections.emptyMap();
        InnerTopiaQueryBuilderRunQueryStep<E> result = this.forHql(hql, properties);
        return result;
    }

    protected InnerTopiaQueryBuilderRunQueryStep<E> forHql(String hql, Map<String, Object> hqlParameters) {
        boolean withOrderByClause = false;
        InnerTopiaQueryBuilderRunQueryStep result = new InnerTopiaQueryBuilderRunQueryStep(this, true, withOrderByClause, hql, hqlParameters);
        return result;
    }

    protected InnerTopiaQueryBuilderRunQueryStep<E> forHql(String hql, String parameterName, Object parameterValue, Object ... otherParameterNamesAndValues) {
        Map<String, Object> hqlParameters = TopiaUtil.convertPropertiesArrayToMap(parameterName, parameterValue, otherParameterNamesAndValues);
        InnerTopiaQueryBuilderRunQueryStep<E> result = this.forHql(hql, hqlParameters);
        return result;
    }

    @Override
    public InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forAll() {
        TopiaQueryBuilderAddCriteriaStep result = this.newQueryBuilder();
        return result;
    }

    @Override
    public InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProperties(Map<String, Object> properties) {
        HqlAndParametersBuilder<E> hqlAndParametersBuilder = this.getHqlForProperties(properties);
        InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = new InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E>(this, hqlAndParametersBuilder);
        return result;
    }

    @Override
    public InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forProperties(String propertyName, Object propertyValue, Object ... otherPropertyNamesAndValues) {
        HqlAndParametersBuilder<E> hqlAndParametersBuilder = this.getHqlForProperties(propertyName, propertyValue, otherPropertyNamesAndValues);
        InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = new InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E>(this, hqlAndParametersBuilder);
        return result;
    }

    @Override
    public InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E> newQueryBuilder() {
        return this.newQueryBuilder(FilterRuleGroupOperator.AND);
    }

    @Override
    public InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E> newQueryBuilder(FilterRuleGroupOperator filterRuleGroupOperator) {
        HqlAndParametersBuilder<E> hqlAndParametersBuilder = this.newHqlAndParametersBuilder(filterRuleGroupOperator);
        InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = new InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E>(this, hqlAndParametersBuilder);
        return result;
    }

    @Override
    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forContains(String propertyName, Object propertyValue) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep result = ((InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep)this.newQueryBuilder()).addContains(propertyName, propertyValue);
        return result;
    }

    @Override
    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEquals(String propertyName, Object propertyValue) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep result = ((InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep)this.newQueryBuilder()).addEquals(propertyName, propertyValue);
        return result;
    }

    @Override
    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forIn(String propertyName, Collection<?> propertyValues) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep result = ((InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep)this.newQueryBuilder()).addIn(propertyName, propertyValues);
        return result;
    }

    protected boolean exists(String hql, Map<String, Object> hqlParameters) {
        TopiaEntity entity = (TopiaEntity)this.topiaJpaSupport.findAny(hql, hqlParameters);
        boolean result = entity != null;
        return result;
    }

    protected long count(String hql, Map<String, Object> hqlParameters) {
        Preconditions.checkArgument((boolean)hql.toLowerCase().trim().startsWith("select count("), (Object)"Your HQL query must start with \"select count(\"");
        Long result = (Long)this.findUnique(hql, hqlParameters);
        return result;
    }

    protected <O> O findUnique(String hql, Map<String, Object> hqlParameters) throws TopiaNoResultException, TopiaNonUniqueResultException {
        O result = this.findUniqueOrNull(hql, hqlParameters);
        if (result == null) {
            throw new TopiaNoResultException(hql, hqlParameters);
        }
        return result;
    }

    protected <O> Optional<O> tryFindUnique(String hql, Map<String, Object> hqlParameters) throws TopiaNonUniqueResultException {
        O uniqueOrNull = this.findUniqueOrNull(hql, hqlParameters);
        Optional result = Optional.fromNullable(uniqueOrNull);
        return result;
    }

    protected <O> O findUniqueOrNull(String hql, Map<String, Object> hqlParameters) throws TopiaNonUniqueResultException {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        Object result = this.topiaJpaSupport.findUnique(hql, hqlParameters);
        return (O)result;
    }

    protected <O> O findFirst(String hql, Map<String, Object> hqlParameters) throws QueryMissingOrderException {
        O result = this.findFirstOrNull(hql, hqlParameters);
        if (result == null) {
            throw new TopiaNoResultException(hql, hqlParameters);
        }
        return result;
    }

    protected <O> Optional<O> tryFindFirst(String hql, Map<String, Object> hqlParameters) throws QueryMissingOrderException {
        O firstOrNull = this.findFirstOrNull(hql, hqlParameters);
        Optional result = Optional.fromNullable(firstOrNull);
        return result;
    }

    protected <O> O findFirstOrNull(String hql, Map<String, Object> hqlParameters) throws QueryMissingOrderException {
        if (!this.hqlContainsOrderBy(hql)) {
            throw new QueryMissingOrderException(hql, hqlParameters);
        }
        O result = this.findAnyOrNull(hql, hqlParameters);
        return result;
    }

    protected <O> O findAny(String hql, Map<String, Object> hqlParameters) throws TopiaNoResultException {
        O result = this.findAnyOrNull(hql, hqlParameters);
        if (result == null) {
            throw new TopiaNoResultException(hql, hqlParameters);
        }
        return result;
    }

    protected <O> Optional<O> tryFindAny(String hql, Map<String, Object> hqlParameters) {
        O anyOrNull = this.findAnyOrNull(hql, hqlParameters);
        Optional result = Optional.fromNullable(anyOrNull);
        return result;
    }

    protected <O> O findAnyOrNull(String hql) {
        Preconditions.checkNotNull((Object)hql);
        Map<String, Object> hqlParameters = Collections.emptyMap();
        O result = this.findAnyOrNull(hql, hqlParameters);
        return result;
    }

    protected <O> O findAnyOrNull(String hql, Map<String, Object> hqlParameters) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        Object result = this.topiaJpaSupport.findAny(hql, hqlParameters);
        return (O)result;
    }

    protected <O> List<O> findAll(String hql) {
        Preconditions.checkNotNull((Object)hql);
        Map<String, Object> hqlParameters = Collections.emptyMap();
        List<O> result = this.findAll(hql, hqlParameters);
        return result;
    }

    protected <O> List<O> findAll(String hql, Map<String, Object> hqlParameters) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        List result = this.topiaJpaSupport.findAll(hql, hqlParameters);
        return result;
    }

    protected <O> Stream<O> stream(String hql) {
        Preconditions.checkNotNull((Object)hql);
        Map<String, Object> hqlParameters = Collections.emptyMap();
        Stream<O> result = this.stream(hql, hqlParameters);
        return result;
    }

    protected <O> Stream<O> stream(String hql, Map<String, Object> hqlParameters) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        Stream result = this.topiaJpaSupport.stream(hql, hqlParameters);
        return result;
    }

    protected <O> List<O> find(String hql, int startIndex, int endIndex) {
        Preconditions.checkNotNull((Object)hql);
        Map<String, Object> hqlParameters = Collections.emptyMap();
        List<O> result = this.find(hql, hqlParameters, startIndex, endIndex);
        return result;
    }

    protected <O> List<O> find(String hql, Map<String, Object> hqlParameters, int startIndex, int endIndex) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        List result = this.topiaJpaSupport.find(hql, startIndex, endIndex, hqlParameters);
        return result;
    }

    protected <O> List<O> find(String hql, Map<String, Object> hqlParameters, PaginationParameter page) {
        boolean pageContainsOrderClause;
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        Preconditions.checkNotNull((Object)page);
        boolean hqlContainsOrderClause = this.hqlContainsOrderBy((String)hql);
        boolean bl = pageContainsOrderClause = !page.getOrderClauses().isEmpty();
        if (!hqlContainsOrderClause && !pageContainsOrderClause) {
            throw new QueryMissingOrderException((String)hql, hqlParameters, page);
        }
        Preconditions.checkArgument((boolean)(hqlContainsOrderClause ^ pageContainsOrderClause), (Object)String.format("One 'order by' clause (and only one) must be specified. [orderByInHql=%b] [orderByInPage=%b]", hqlContainsOrderClause, pageContainsOrderClause));
        if (pageContainsOrderClause) {
            hql = (String)hql + " ORDER BY ";
            Iterable orderClauses = Iterables.transform((Iterable)page.getOrderClauses(), PAGINATION_ORDER_TO_HQL);
            hql = (String)hql + Joiner.on((String)", ").join(orderClauses);
        }
        List result = this.topiaJpaSupport.find((String)hql, page.getStartIndex(), page.getEndIndex(), hqlParameters);
        return result;
    }

    protected <O> PaginationResult<O> findPage(String hql, Map<String, Object> hqlParameters, PaginationParameter page) {
        List<O> elements = this.find(hql, hqlParameters, page);
        Object countHql = "select count(topiaId) ";
        countHql = this.hqlStartsWithSelect(hql) ? (String)countHql + hql.substring(hql.toLowerCase().indexOf(" from ")) : (String)countHql + hql;
        if (this.hqlContainsOrderBy((String)countHql)) {
            countHql = ((String)countHql).substring(0, ((String)countHql).toLowerCase().indexOf("order by"));
        }
        long count = this.count((String)countHql, hqlParameters);
        PaginationResult result = PaginationResult.of(elements, (long)count, (PaginationParameter)page);
        return result;
    }

    protected <O> Iterable<O> findAllLazy(String hql) {
        Map<String, Object> hqlParameters = Collections.emptyMap();
        Iterable<O> result = this.findAllLazy(hql, hqlParameters);
        return result;
    }

    protected <O> Iterable<O> findAllLazy(String hql, Map<String, Object> hqlParameters) {
        Iterable<O> result = this.findAllLazy(hql, hqlParameters, this.batchSize);
        return result;
    }

    protected <O> Iterable<O> findAllLazy(String hql, int batchSize) {
        Map<String, Object> hqlParameters = Collections.emptyMap();
        Iterable<O> result = this.findAllLazy(hql, hqlParameters, batchSize);
        return result;
    }

    protected <O> Iterable<O> findAllLazy(String hql, Map<String, Object> hqlParameters, int batchSize) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        final FindAllIterator iterator = new FindAllIterator(this, batchSize, hql, hqlParameters);
        Iterable result = new Iterable<O>(){

            @Override
            public Iterator<O> iterator() {
                return iterator;
            }
        };
        return result;
    }

    @Override
    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTopiaIdEquals(String topiaId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topiaId), (Object)"given topiaId is blank");
        TopiaQueryBuilderRunQueryStep result = this.forEquals("topiaId", topiaId);
        return result;
    }

    @Override
    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTopiaIdIn(Collection<String> topiaIds) {
        Preconditions.checkNotNull(topiaIds, (Object)"given topiaIds is null");
        TopiaQueryBuilderRunQueryStep result = this.forIn("topiaId", (Collection)topiaIds);
        return result;
    }

    @Override
    @Deprecated
    public E findByTopiaId(String topiaId) throws TopiaNoResultException {
        try {
            Object result = this.forTopiaIdEquals(topiaId).findAny();
            return result;
        }
        catch (TopiaNoResultException tnre) {
            if (log.isWarnEnabled()) {
                String message = String.format("Unexpected behavior : entity '%s' not found with topiaId='%s'", this.getEntityClass().getName(), topiaId);
                log.warn((Object)message);
            }
            throw tnre;
        }
    }

    @Override
    @Deprecated
    public Optional<E> tryFindByTopiaId(String topiaId) {
        Optional result = this.forTopiaIdEquals(topiaId).tryFindAny();
        return result;
    }

    @Override
    public List<String> findAllIds() {
        List<String> result = ((InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep)this.newQueryBuilder()).findAllIds();
        return result;
    }

    @Override
    public List<E> findAll() {
        List result = ((InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep)this.newQueryBuilder()).findAll();
        return result;
    }

    @Override
    public Stream<E> streamAll() {
        Stream result = ((InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep)this.newQueryBuilder()).stream();
        return result;
    }

    @Override
    public Iterable<E> findAllLazy() {
        String hql = " FROM " + this.getTopiaEntityEnum().getImplementationFQN() + " ORDER BY id ";
        Map<String, Object> hqlParameters = Collections.emptyMap();
        Iterable result = this.findAllLazy(hql, hqlParameters);
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        Iterator<E> result = this.findAllLazy().iterator();
        return result;
    }

    @Override
    public long count() {
        long result = ((InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep)this.newQueryBuilder()).count();
        return result;
    }

    protected boolean hqlContainsOrderBy(String hql) {
        return hql.toLowerCase().contains("order by");
    }

    protected boolean hqlStartsWithSelect(String hql) {
        return hql.toLowerCase().trim().startsWith("select ");
    }

    protected boolean hqlContainsCount(String hql) {
        return hql.toLowerCase().contains("count(");
    }

    public static class InnerTopiaQueryBuilderRunQueryStep<E extends TopiaEntity>
    implements TopiaQueryBuilderRunQueryStep<E> {
        protected final String hql;
        protected final Map<String, Object> hqlParameters;
        protected final AbstractTopiaDao<E> topiaDao;
        protected final boolean fromHql;
        protected final boolean withOrderByClause;
        protected final String hqlForFetchStep1;
        protected final String hqlForFetchStep2;

        protected InnerTopiaQueryBuilderRunQueryStep(AbstractTopiaDao<E> topiaDao, boolean fromHql, boolean withOrderByClause, String hql, Map<String, Object> hqlParameters) {
            this(topiaDao, fromHql, withOrderByClause, hql, hqlParameters, null, null);
        }

        protected InnerTopiaQueryBuilderRunQueryStep(AbstractTopiaDao<E> topiaDao, boolean fromHql, boolean withOrderByClause, String hql, Map<String, Object> hqlParameters, String hqlForFetchStep1, String hqlForFetchStep2) {
            this.fromHql = fromHql;
            this.withOrderByClause = withOrderByClause;
            this.hql = hql;
            this.hqlParameters = hqlParameters;
            this.topiaDao = topiaDao;
            this.hqlForFetchStep1 = hqlForFetchStep1;
            this.hqlForFetchStep2 = hqlForFetchStep2;
        }

        @Override
        public boolean exists() {
            return this.topiaDao.exists(this.hql, this.hqlParameters);
        }

        @Override
        public long count() {
            String hqlWithSelectClause = "select count(topiaId) " + this.hql;
            return this.topiaDao.count(hqlWithSelectClause, this.hqlParameters);
        }

        @Override
        public E findUnique() throws TopiaNoResultException, TopiaNonUniqueResultException {
            return (E)((TopiaEntity)this.topiaDao.findUnique(this.hql, this.hqlParameters));
        }

        @Override
        public E findUniqueOrNull() throws TopiaNonUniqueResultException {
            return (E)((TopiaEntity)this.topiaDao.findUniqueOrNull(this.hql, this.hqlParameters));
        }

        @Override
        public Optional<E> tryFindUnique() throws TopiaNonUniqueResultException {
            return this.topiaDao.tryFindUnique(this.hql, this.hqlParameters);
        }

        @Override
        public E findFirst() throws QueryMissingOrderException, TopiaNoResultException {
            return (E)((TopiaEntity)this.topiaDao.findFirst(this.hql, this.hqlParameters));
        }

        @Override
        public E findFirstOrNull() throws QueryMissingOrderException {
            return (E)((TopiaEntity)this.topiaDao.findFirstOrNull(this.hql, this.hqlParameters));
        }

        @Override
        public Optional<E> tryFindFirst() throws QueryMissingOrderException {
            return this.topiaDao.tryFindFirst(this.hql, this.hqlParameters);
        }

        @Override
        public E findAny() throws TopiaNoResultException {
            return (E)((TopiaEntity)this.topiaDao.findAny(this.hql, this.hqlParameters));
        }

        @Override
        public E findAnyOrNull() {
            return (E)((TopiaEntity)this.topiaDao.findAnyOrNull(this.hql, this.hqlParameters));
        }

        @Override
        public Optional<E> tryFindAny() {
            return this.topiaDao.tryFindAny(this.hql, this.hqlParameters);
        }

        @Override
        public List<E> findAll() {
            return this.topiaDao.findAll(this.hql, this.hqlParameters);
        }

        @Override
        public Stream<E> stream() {
            return this.topiaDao.stream(this.hql, this.hqlParameters);
        }

        @Override
        public Iterable<E> findAllLazy() {
            return this.topiaDao.findAllLazy(this.hql + (this.fromHql || this.withOrderByClause ? "" : " ORDER BY id "), this.hqlParameters);
        }

        @Override
        public Iterable<E> findAllLazy(int batchSize) {
            return this.topiaDao.findAllLazy(this.hql + (this.fromHql || this.withOrderByClause ? "" : " ORDER BY id "), this.hqlParameters, batchSize);
        }

        @Override
        public List<E> find(int startIndex, int endIndex) {
            List result;
            if (!Strings.isNullOrEmpty((String)this.hqlForFetchStep1) && !Strings.isNullOrEmpty((String)this.hqlForFetchStep2)) {
                List<String> step1ResultTopiaIds = this.topiaDao.find(this.hqlForFetchStep1, this.hqlParameters, startIndex, endIndex);
                if (CollectionUtils.isEmpty(step1ResultTopiaIds)) {
                    result = Lists.newArrayList();
                } else {
                    HashMap step2Args = Maps.newHashMap();
                    step2Args.put("topiaIdsForFetch_", step1ResultTopiaIds);
                    List<E> entities = this.topiaDao.forHql(this.hqlForFetchStep2, step2Args).findAll();
                    result = this.sortAccordingToIds(entities, step1ResultTopiaIds);
                }
            } else {
                result = this.topiaDao.find(this.hql, this.hqlParameters, startIndex, endIndex);
            }
            return result;
        }

        @Override
        public List<E> find(PaginationParameter page) {
            return this.topiaDao.find(this.hql, this.hqlParameters, page);
        }

        @Override
        public PaginationResult<E> findPage(PaginationParameter page) {
            PaginationResult result;
            if (!Strings.isNullOrEmpty((String)this.hqlForFetchStep1) && !Strings.isNullOrEmpty((String)this.hqlForFetchStep2)) {
                List sortedEntities;
                PaginationResult pageResult = this.topiaDao.findPage(this.hqlForFetchStep1, this.hqlParameters, page);
                List step1ResultTopiaIds = pageResult.getElements();
                if (CollectionUtils.isEmpty((Collection)step1ResultTopiaIds)) {
                    sortedEntities = Lists.newArrayList();
                } else {
                    HashMap step2Args = Maps.newHashMap();
                    step2Args.put("topiaIdsForFetch_", step1ResultTopiaIds);
                    List<E> entities = this.topiaDao.forHql(this.hqlForFetchStep2, step2Args).findAll();
                    sortedEntities = this.sortAccordingToIds(entities, step1ResultTopiaIds);
                }
                result = PaginationResult.of((List)sortedEntities, (long)pageResult.getCount(), (PaginationParameter)pageResult.getCurrentPage());
            } else {
                result = this.topiaDao.findPage(this.hql, this.hqlParameters, page);
            }
            return result;
        }

        protected <O extends TopiaEntity> List<O> sortAccordingToIds(List<O> entities, List<String> idsList) {
            ImmutableMap entitiesIndex = Maps.uniqueIndex(entities, TopiaEntities.getTopiaIdFunction());
            Iterable transformed = Iterables.transform(idsList, (Function)new Function<String, O>(){
                final /* synthetic */ Map val$entitiesIndex;
                {
                    this.val$entitiesIndex = map;
                }

                public O apply(String input) {
                    return (TopiaEntity)this.val$entitiesIndex.get(input);
                }
            });
            ArrayList result = Lists.newArrayList((Iterable)transformed);
            return result;
        }

        @Override
        public List<String> findAllIds() {
            String hqlWithSelectClause = "select topiaId " + this.hql;
            return this.topiaDao.findAll(hqlWithSelectClause, this.hqlParameters);
        }

        @Override
        public List<String> findIds(int startIndex, int endIndex) {
            String hqlWithSelectClause = "select topiaId " + this.hql;
            return this.topiaDao.find(hqlWithSelectClause, this.hqlParameters, startIndex, endIndex);
        }

        @Override
        public List<String> findIds(PaginationParameter page) {
            String hqlWithSelectClause = "select topiaId " + this.hql;
            return this.topiaDao.find(hqlWithSelectClause, this.hqlParameters, page);
        }

        @Override
        public PaginationResult<String> findIdsPage(PaginationParameter page) {
            List<String> elements = this.findIds(page);
            long count = this.count();
            PaginationResult result = PaginationResult.of(elements, (long)count, (PaginationParameter)page);
            return result;
        }
    }

    public static class InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep<E extends TopiaEntity>
    implements TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> {
        protected AbstractTopiaDao<E> topiaDao;
        protected HqlAndParametersBuilder<E> hqlAndParametersBuilder;

        protected InnerTopiaQueryBuilderAddCriteriaOrRunQueryStep(AbstractTopiaDao<E> topiaDao, HqlAndParametersBuilder<E> hqlAndParametersBuilder) {
            this.topiaDao = topiaDao;
            this.hqlAndParametersBuilder = hqlAndParametersBuilder;
        }

        @Override
        public InnerTopiaQueryBuilderRunQueryStep<E> setOrderByArguments(LinkedHashSet<String> orderByArguments) {
            this.hqlAndParametersBuilder.setOrderByArguments(orderByArguments);
            return this.getNextStep();
        }

        @Override
        public InnerTopiaQueryBuilderRunQueryStep<E> setOrderByArguments(String ... orderByArguments) {
            this.hqlAndParametersBuilder.setOrderByArguments(orderByArguments);
            return this.getNextStep();
        }

        @Override
        public TopiaQueryBuilderRunQueryStep<E> setOrderByArguments(Collection<PaginationOrder> paginationOrders) {
            this.hqlAndParametersBuilder.setOrderByArguments(paginationOrders);
            return this.getNextStep();
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addEquals(String property, Object value) {
            this.hqlAndParametersBuilder.addEquals(property, value);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNotEquals(String property, Object value) {
            this.hqlAndParametersBuilder.addNotEquals(property, value);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addIn(String property, Collection<?> values) {
            this.hqlAndParametersBuilder.addIn(property, values);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNotIn(String property, Collection<?> values) {
            this.hqlAndParametersBuilder.addNotIn(property, values);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addContains(String property, Object value) {
            this.hqlAndParametersBuilder.addContains(property, value);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNotContains(String property, Object value) {
            this.hqlAndParametersBuilder.addNotContains(property, value);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNull(String property) {
            this.hqlAndParametersBuilder.addNull(property);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNotNull(String property) {
            this.hqlAndParametersBuilder.addNotNull(property);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addTopiaIdEquals(String property, String topiaId) {
            this.hqlAndParametersBuilder.addTopiaIdEquals(property, topiaId);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addTopiaIdIn(String property, Collection<String> topiaIds) {
            this.hqlAndParametersBuilder.addTopiaIdIn(property, topiaIds);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addTopiaIdNotEquals(String property, String topiaId) {
            this.hqlAndParametersBuilder.addTopiaIdNotEquals(property, topiaId);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addTopiaIdNotIn(String property, Collection<String> topiaIds) {
            this.hqlAndParametersBuilder.addTopiaIdNotIn(property, topiaIds);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addFetch(String property) {
            this.hqlAndParametersBuilder.addFetch(property);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addAllFetches(String property, String ... otherProperties) {
            this.hqlAndParametersBuilder.addAllFetches(property, otherProperties);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addAllFetches(Collection<String> properties) {
            this.hqlAndParametersBuilder.addAllFetches(properties);
            return this;
        }

        @Override
        public boolean exists() {
            return this.getNextStep().exists();
        }

        @Override
        public E findAnyOrNull() {
            return this.getNextStep().findAnyOrNull();
        }

        @Override
        public E findUniqueOrNull() {
            return this.getNextStep().findUniqueOrNull();
        }

        @Override
        public E findAny() {
            return this.getNextStep().findAny();
        }

        @Override
        public E findUnique() {
            return this.getNextStep().findUnique();
        }

        @Override
        public E findFirst() {
            return this.getNextStep().findFirst();
        }

        @Override
        public E findFirstOrNull() {
            return this.getNextStep().findFirstOrNull();
        }

        @Override
        public Optional<E> tryFindAny() {
            return this.getNextStep().tryFindAny();
        }

        @Override
        public Optional<E> tryFindFirst() {
            return this.getNextStep().tryFindFirst();
        }

        @Override
        public Optional<E> tryFindUnique() {
            return this.getNextStep().tryFindUnique();
        }

        @Override
        public List<E> findAll() {
            return this.getNextStep().findAll();
        }

        @Override
        public Stream<E> stream() {
            return this.getNextStep().stream();
        }

        @Override
        public List<E> find(int startIndex, int endIndex) {
            return this.getNextStep().find(startIndex, endIndex);
        }

        @Override
        public List<E> find(PaginationParameter page) {
            return this.getNextStep().find(page);
        }

        @Override
        public PaginationResult<E> findPage(PaginationParameter page) {
            return this.getNextStep().findPage(page);
        }

        @Override
        public Iterable<E> findAllLazy() {
            return this.getNextStep().findAllLazy();
        }

        @Override
        public Iterable<E> findAllLazy(int batchSize) {
            return this.getNextStep().findAllLazy(batchSize);
        }

        @Override
        public long count() {
            return this.getNextStep().count();
        }

        @Override
        public List<String> findIds(int startIndex, int endIndex) {
            return this.getNextStep().findIds(startIndex, endIndex);
        }

        @Override
        public List<String> findIds(PaginationParameter page) {
            return this.getNextStep().findIds(page);
        }

        @Override
        public PaginationResult<String> findIdsPage(PaginationParameter page) {
            return this.getNextStep().findIdsPage(page);
        }

        @Override
        public List<String> findAllIds() {
            return this.getNextStep().findAllIds();
        }

        protected InnerTopiaQueryBuilderRunQueryStep<E> getNextStep() {
            InnerTopiaQueryBuilderRunQueryStep<E> nextStep;
            String hql = this.hqlAndParametersBuilder.getHql();
            Map<String, Object> hqlParameters = this.hqlAndParametersBuilder.getHqlParameters();
            boolean withOrderByClause = this.hqlAndParametersBuilder.isOrderByClausePresent();
            if (this.hqlAndParametersBuilder.hasFetchProperties()) {
                String hqlForFetchStep1 = this.hqlAndParametersBuilder.getHqlForFetchStep1();
                String hqlForFetchStep2 = this.hqlAndParametersBuilder.getHqlForFetchStep2();
                nextStep = new InnerTopiaQueryBuilderRunQueryStep<E>(this.topiaDao, false, withOrderByClause, hql, hqlParameters, hqlForFetchStep1, hqlForFetchStep2);
            } else {
                nextStep = new InnerTopiaQueryBuilderRunQueryStep<E>(this.topiaDao, false, withOrderByClause, hql, hqlParameters);
            }
            return nextStep;
        }
    }

    public static class FindAllIterator<E extends TopiaEntity, O>
    implements Iterator<O> {
        protected Iterator<O> data;
        protected final AbstractTopiaDao<E> dao;
        protected final String hql;
        protected final Map<String, Object> params;
        protected PaginationResult<E> pager;
        protected boolean firstPageLoaded;

        public FindAllIterator(AbstractTopiaDao<E> dao, int batchSize, String hql, Map<String, Object> params) {
            if (!dao.hqlContainsOrderBy(hql)) {
                throw new QueryMissingOrderException(hql, params);
            }
            this.dao = dao;
            this.hql = hql;
            this.params = params;
            this.pager = dao.initPagination(hql, params, batchSize);
            this.data = Collections.emptyIterator();
            this.firstPageLoaded = false;
        }

        @Override
        public boolean hasNext() {
            boolean result = this.data.hasNext() || !this.firstPageLoaded && this.pager.getCount() > 0L || this.firstPageLoaded && this.pager.hasNextPage();
            return result;
        }

        @Override
        public O next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.data.hasNext()) {
                PaginationParameter pageToLoad;
                if (this.firstPageLoaded) {
                    pageToLoad = this.pager.getNextPage();
                } else {
                    pageToLoad = this.pager.getCurrentPage();
                    this.firstPageLoaded = true;
                }
                List values = this.dao.find(this.hql, this.params, pageToLoad);
                this.data = values.iterator();
                this.pager = PaginationResult.of((List)this.pager.getElements(), (long)this.pager.getCount(), (PaginationParameter)pageToLoad);
            }
            O next = this.data.next();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support remove operation.");
        }
    }
}

