/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.tool.schema.internal.AbstractSchemaValidator;
import org.nuiton.topia.persistence.TopiaException;

public class SchemaValidationTopiaException
extends TopiaException {
    protected static final Predicate<StackTraceElement> IS_STACK_TRACE_ELEMENT_ABOUT_SCHEMA_VALIDATION = new Predicate<StackTraceElement>(){

        public boolean apply(StackTraceElement input) {
            return input.getClassName().equals(AbstractSchemaValidator.class.getName()) && input.getMethodName().equals("doValidation");
        }
    };

    public SchemaValidationTopiaException(String message, HibernateException e) {
        super(message, (Throwable)e);
    }

    public static void throwIfHibernateExceptionIsAboutSchemaValidation(HibernateException hibernateException) {
        boolean stackTraceIsAboutSchemaValidation = Iterables.any(Arrays.asList(hibernateException.getStackTrace()), IS_STACK_TRACE_ELEMENT_ABOUT_SCHEMA_VALIDATION);
        if (stackTraceIsAboutSchemaValidation) {
            throw new SchemaValidationTopiaException(hibernateException.getMessage(), hibernateException);
        }
    }
}

