package org.nuiton.topia.persistence;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaDaoSupplier.java 2949 2013-12-20 14:59:42Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-8/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaDaoSupplier.java $
 * %%
 * Copyright (C) 2004 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;

/**
 * @author bleny
 */
public interface TopiaDaoSupplier {

    /**
     * Get Dao for specified class. If the specialized Dao exists then it is
     * returned otherwise a TopiaException will be thrown
     *
     * @param entityClass type of entity
     * @return the expected dao
     */
    <E extends TopiaEntity> TopiaDao<E> getDao(Class<E> entityClass);

    /**
     * Get Dao for specified class. If the specialized Dao exists then it is
     * returned otherwise a TopiaException will be thrown
     *
     * @param entityClass type of entity
     * @param daoClass    the concrete dao class to use
     * @return the expected dao
     */
    <E extends TopiaEntity, D extends TopiaDao<E>> D getDao(Class<E> entityClass, Class<D> daoClass);

}
