/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.QueryMissingOrderException;
import org.nuiton.topia.TopiaDaoSupplier;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaJpaSupport;
import org.nuiton.topia.TopiaListenableSupport;
import org.nuiton.topia.TopiaNoResultException;
import org.nuiton.topia.TopiaNonUniqueResultException;
import org.nuiton.topia.TopiaSqlSupport;
import org.nuiton.topia.event.TopiaEntityListener;
import org.nuiton.topia.event.TopiaEntityVetoable;
import org.nuiton.topia.framework.TopiaFiresSupport;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.topia.persistence.HqlAndParametersBuilder;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaIdFactory;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.topia.persistence.pager.TopiaPagerBean;
import org.nuiton.util.PagerBean;
import org.nuiton.util.PagerBeanUtil;

public abstract class AbstractTopiaDao<E extends TopiaEntity>
implements TopiaDao<E> {
    private static Log log = LogFactory.getLog(AbstractTopiaDao.class);
    protected int batchSize = 1000;
    protected TopiaJpaSupport topiaJpaSupport;
    protected TopiaSqlSupport topiaSqlSupport;
    protected TopiaListenableSupport topiaListenableSupport;
    protected TopiaIdFactory topiaIdFactory;
    protected TopiaFiresSupport topiaFiresSupport;
    protected TopiaDaoSupplier topiaDaoSupplier;

    public abstract TopiaEntityEnum getTopiaEntityEnum();

    @Override
    public abstract Class<E> getEntityClass();

    public void init(TopiaJpaSupport topiaJpaSupport, TopiaSqlSupport topiaSqlSupport, TopiaListenableSupport topiaListenableSupport, TopiaIdFactory topiaIdFactory, TopiaFiresSupport topiaFiresSupport, TopiaDaoSupplier topiaDaoSupplier) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init dao for " + this.getEntityClass()));
        }
        this.topiaJpaSupport = topiaJpaSupport;
        this.topiaSqlSupport = topiaSqlSupport;
        this.topiaListenableSupport = topiaListenableSupport;
        this.topiaIdFactory = topiaIdFactory;
        this.topiaFiresSupport = topiaFiresSupport;
        this.topiaDaoSupplier = topiaDaoSupplier;
    }

    public TopiaFiresSupport getTopiaFiresSupport() {
        return this.topiaFiresSupport;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    protected String newFromClause(String alias) {
        String hql = "from " + this.getTopiaEntityEnum().getImplementationFQN();
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            hql = hql + " " + alias;
        }
        return hql;
    }

    @Override
    public E newInstance() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("entityClass = " + this.getEntityClass()));
        }
        Class<? extends TopiaEntity> implementation = this.getTopiaEntityEnum().getImplementation();
        try {
            TopiaEntity newInstance = implementation.newInstance();
            return (E)newInstance;
        }
        catch (InstantiationException e) {
            throw new TopiaException("Impossible de trouver ou d'instancier la classe " + implementation);
        }
        catch (IllegalAccessException e) {
            throw new TopiaException("Impossible de trouver ou d'instancier la classe " + implementation);
        }
    }

    @Override
    public void addTopiaEntityListener(TopiaEntityListener listener) {
        this.topiaListenableSupport.addTopiaEntityListener(this.getEntityClass(), listener);
    }

    @Override
    public void addTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.topiaListenableSupport.addTopiaEntityVetoable(this.getEntityClass(), vetoable);
    }

    @Override
    public void removeTopiaEntityListener(TopiaEntityListener listener) {
        this.topiaListenableSupport.removeTopiaEntityListener(this.getEntityClass(), listener);
    }

    @Override
    public void removeTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.topiaListenableSupport.removeTopiaEntityVetoable(this.getEntityClass(), vetoable);
    }

    @Override
    public E create(E entity) {
        if (StringUtils.isBlank((CharSequence)entity.getTopiaId())) {
            String topiaId = this.topiaIdFactory.newTopiaId(this.getEntityClass(), (TopiaEntity)entity);
            entity.setTopiaId(topiaId);
        }
        if (entity instanceof TopiaEntityContextable) {
            TopiaEntityContextable contextable = (TopiaEntityContextable)entity;
            contextable.setTopiaDAOSupplier(this.topiaDaoSupplier);
        }
        this.topiaJpaSupport.save(entity);
        this.topiaFiresSupport.warnOnCreateEntity((TopiaEntity)entity);
        return entity;
    }

    @Override
    public E create(String propertyName, Object propertyValue, Object ... otherPropertyNamesAndValues) {
        Map<String, Object> properties = TopiaUtil.convertPropertiesArrayToMap(propertyName, propertyValue, otherPropertyNamesAndValues);
        E result = this.create(properties);
        return result;
    }

    @Override
    public E create(Map<String, Object> properties) {
        E result = this.newInstance();
        try {
            for (Map.Entry<String, Object> e : properties.entrySet()) {
                String propertyName = e.getKey();
                Object value = e.getValue();
                PropertyUtils.setProperty(result, (String)propertyName, (Object)value);
            }
        }
        catch (IllegalAccessException eee) {
            throw new IllegalArgumentException("Can't put properties on new Object", eee);
        }
        catch (InvocationTargetException eee) {
            throw new IllegalArgumentException("Can't put properties on new Object", eee);
        }
        catch (NoSuchMethodException eee) {
            throw new IllegalArgumentException("Can't put properties on new Object", eee);
        }
        this.create(result);
        return result;
    }

    @Override
    public E create() {
        E result = this.newInstance();
        this.create(result);
        return result;
    }

    @Override
    public Iterable<E> createAll(Iterable<E> entities) {
        for (TopiaEntity entity : entities) {
            this.create(entity);
        }
        return entities;
    }

    @Override
    public E update(E entity) {
        this.topiaJpaSupport.saveOrUpdate(entity);
        this.topiaFiresSupport.warnOnUpdateEntity((TopiaEntity)entity);
        return entity;
    }

    @Override
    public Iterable<E> updateAll(Iterable<E> entities) {
        for (TopiaEntity entity : entities) {
            this.update(entity);
        }
        return entities;
    }

    @Override
    public void delete(E entity) {
        this.topiaJpaSupport.delete(entity);
        entity.notifyDeleted();
        this.topiaFiresSupport.warnOnDeleteEntity((TopiaEntity)entity);
    }

    @Override
    public void deleteAll(Iterable<E> entities) {
        for (TopiaEntity entity : entities) {
            this.delete(entity);
        }
    }

    protected HqlAndParametersBuilder<E> newHqlAndParametersBuilder() {
        HqlAndParametersBuilder<E> result = new HqlAndParametersBuilder<E>(this.getEntityClass());
        return result;
    }

    protected HqlAndParametersBuilder<E> getHqlForProperties(String propertyName, Object propertyValue, Object ... otherPropertyNamesAndValues) {
        Map<String, Object> properties = TopiaUtil.convertPropertiesArrayToMap(propertyName, propertyValue, otherPropertyNamesAndValues);
        HqlAndParametersBuilder<E> result = this.getHqlForProperties(properties);
        return result;
    }

    protected HqlAndParametersBuilder<E> getHqlForNoConstraint() {
        Map<String, Object> properties = Collections.emptyMap();
        HqlAndParametersBuilder<E> result = this.getHqlForProperties(properties);
        return result;
    }

    protected HqlAndParametersBuilder<E> getHqlForProperties(Map<String, Object> properties) {
        HqlAndParametersBuilder<E> result = this.newHqlAndParametersBuilder();
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            result.addEquals(property.getKey(), property.getValue());
        }
        return result;
    }

    protected TopiaQueryBuilderRunQueryStep<E> forHql(String hql) {
        Map<String, Object> properties = Collections.emptyMap();
        TopiaQueryBuilderRunQueryStep<E> result = this.forHql(hql, properties);
        return result;
    }

    protected TopiaQueryBuilderRunQueryStep<E> forHql(String hql, Map<String, Object> hqlParameters) {
        TopiaQueryBuilderRunQueryStep result = new TopiaQueryBuilderRunQueryStep(this, hql, hqlParameters);
        return result;
    }

    protected TopiaQueryBuilderRunQueryStep<E> forHql(String hql, String parameterName, Object parameterValue, Object ... otherParameterNamesAndValues) {
        Map<String, Object> hqlParameters = TopiaUtil.convertPropertiesArrayToMap(parameterName, parameterValue, otherParameterNamesAndValues);
        TopiaQueryBuilderRunQueryStep<E> result = this.forHql(hql, hqlParameters);
        return result;
    }

    @Override
    public TopiaQueryBuilderAddCriteriaStep<E> forProperties(Map<String, Object> properties) {
        HqlAndParametersBuilder<E> hqlAndParametersBuilder = this.getHqlForProperties(properties);
        TopiaQueryBuilderAddCriteriaStep<E> result = new TopiaQueryBuilderAddCriteriaStep<E>(this, hqlAndParametersBuilder);
        return result;
    }

    @Override
    public TopiaQueryBuilderAddCriteriaStep<E> forProperties(String propertyName, Object propertyValue, Object ... otherPropertyNamesAndValues) {
        HqlAndParametersBuilder<E> hqlAndParametersBuilder = this.getHqlForProperties(propertyName, propertyValue, otherPropertyNamesAndValues);
        TopiaQueryBuilderAddCriteriaStep<E> result = new TopiaQueryBuilderAddCriteriaStep<E>(this, hqlAndParametersBuilder);
        return result;
    }

    @Override
    public TopiaQueryBuilderAddCriteriaStep<E> newQueryBuilder() {
        HqlAndParametersBuilder<E> hqlAndParametersBuilder = this.newHqlAndParametersBuilder();
        TopiaQueryBuilderAddCriteriaStep<E> result = new TopiaQueryBuilderAddCriteriaStep<E>(this, hqlAndParametersBuilder);
        return result;
    }

    @Override
    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forContains(String propertyName, Object propertyValue) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep result = ((TopiaQueryBuilderAddCriteriaStep)this.newQueryBuilder()).addContains(propertyName, propertyValue);
        return result;
    }

    @Override
    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forEquals(String propertyName, Object propertyValue) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep result = ((TopiaQueryBuilderAddCriteriaStep)this.newQueryBuilder()).addEquals(propertyName, propertyValue);
        return result;
    }

    @Override
    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forIn(String propertyName, Iterable<Object> propertyValues) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep result = ((TopiaQueryBuilderAddCriteriaStep)this.newQueryBuilder()).addIn(propertyName, propertyValues);
        return result;
    }

    protected boolean exists(String hql, Map<String, Object> hqlParameters) {
        List entities = this.topiaJpaSupport.find(hql, 0, 0, hqlParameters);
        boolean result = !entities.isEmpty();
        return result;
    }

    protected long count(String hql, Map<String, Object> hqlParameters) {
        Preconditions.checkArgument((boolean)hql.toLowerCase().trim().startsWith("select count("));
        Long result = this.findUnique(hql, hqlParameters, Long.class);
        return result;
    }

    protected E findUnique(String hql, Map<String, Object> hqlParameters) throws TopiaNoResultException {
        TopiaEntity result = (TopiaEntity)this.findUnique(hql, hqlParameters, this.getEntityClass());
        return (E)result;
    }

    protected E findUniqueOrNull(String hql, Map<String, Object> hqlParameters) throws TopiaNonUniqueResultException {
        TopiaEntity result = (TopiaEntity)this.findUniqueOrNull(hql, hqlParameters, this.getEntityClass());
        return (E)result;
    }

    protected Optional<E> tryFindUnique(String hql, Map<String, Object> hqlParameters) {
        Optional<E> result = this.tryFindUnique(hql, hqlParameters, this.getEntityClass());
        return result;
    }

    protected E findFirst(String hql, Map<String, Object> hqlParameters) throws TopiaNoResultException {
        TopiaEntity result = (TopiaEntity)this.findFirst(hql, hqlParameters, this.getEntityClass());
        return (E)result;
    }

    protected E findFirstOrNull(String hql, Map<String, Object> hqlParameters) throws QueryMissingOrderException {
        TopiaEntity result = (TopiaEntity)this.findFirstOrNull(hql, hqlParameters, this.getEntityClass());
        return (E)result;
    }

    protected Optional<E> tryFindFirst(String hql, Map<String, Object> hqlParameters) throws QueryMissingOrderException {
        Optional<E> result = this.tryFindFirst(hql, hqlParameters, this.getEntityClass());
        return result;
    }

    protected E findAny(String hql, Map<String, Object> hqlParameters) throws TopiaNoResultException {
        TopiaEntity result = (TopiaEntity)this.findAny(hql, hqlParameters, this.getEntityClass());
        return (E)result;
    }

    protected E findAnyOrNull(String hql, Map<String, Object> hqlParameters) {
        TopiaEntity result = (TopiaEntity)this.findAnyOrNull(hql, hqlParameters, this.getEntityClass());
        return (E)result;
    }

    protected Optional<E> tryFindAny(String hql, Map<String, Object> hqlParameters) {
        Optional<E> result = this.tryFindAny(hql, hqlParameters, this.getEntityClass());
        return result;
    }

    protected <R> R findUnique(String hql, Map<String, Object> hqlParameters, Class<R> type) throws TopiaNoResultException, TopiaNonUniqueResultException {
        R result = this.findUniqueOrNull(hql, hqlParameters, type);
        if (result == null) {
            throw new TopiaNoResultException(hql, hqlParameters);
        }
        return result;
    }

    protected <R> Optional<R> tryFindUnique(String hql, Map<String, Object> hqlParameters, Class<R> type) throws TopiaNonUniqueResultException {
        R uniqueOrNull = this.findUniqueOrNull(hql, hqlParameters, type);
        Optional result = Optional.fromNullable(uniqueOrNull);
        return result;
    }

    protected <R> R findUniqueOrNull(String hql, Map<String, Object> hqlParameters, Class<R> type) throws TopiaNonUniqueResultException {
        List<R> results = this.find(hql, hqlParameters, type, 0, 1);
        if (results.size() > 1) {
            throw new TopiaNonUniqueResultException(hql, hqlParameters);
        }
        Object result = Iterables.getOnlyElement(results, null);
        return (R)result;
    }

    protected <R> R findFirst(String hql, Map<String, Object> hqlParameters, Class<R> type) throws QueryMissingOrderException {
        R result = this.findFirstOrNull(hql, hqlParameters, type);
        if (result == null) {
            throw new TopiaNoResultException(hql, hqlParameters);
        }
        return result;
    }

    protected <R> Optional<R> tryFindFirst(String hql, Map<String, Object> hqlParameters, Class<R> type) throws QueryMissingOrderException {
        R firstOrNull = this.findFirstOrNull(hql, hqlParameters, type);
        Optional result = Optional.fromNullable(firstOrNull);
        return result;
    }

    protected <R> R findFirstOrNull(String hql, Map<String, Object> hqlParameters, Class<R> type) throws QueryMissingOrderException {
        if (!hql.toLowerCase().contains("order by")) {
            throw new QueryMissingOrderException(hql, hqlParameters);
        }
        R result = this.findAnyOrNull(hql, hqlParameters, type);
        return result;
    }

    protected <R> R findAny(String hql, Map<String, Object> hqlParameters, Class<R> type) throws TopiaNoResultException {
        R result = this.findAnyOrNull(hql, hqlParameters, type);
        if (result == null) {
            throw new TopiaNoResultException(hql, hqlParameters);
        }
        return result;
    }

    protected <R> Optional<R> tryFindAny(String hql, Map<String, Object> hqlParameters, Class<R> type) {
        R anyOrNull = this.findAnyOrNull(hql, hqlParameters, type);
        Optional result = Optional.fromNullable(anyOrNull);
        return result;
    }

    protected <R> R findAnyOrNull(String hql, Map<String, Object> hqlParameters, Class<R> type) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        List<R> results = this.find(hql, hqlParameters, type, 0, 0);
        Object result = Iterables.getOnlyElement(results, null);
        return (R)result;
    }

    protected List<E> findAll(String hql, Map<String, Object> hqlParameters) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        List result = this.topiaJpaSupport.findAll(hql, hqlParameters);
        return result;
    }

    protected List<E> find(String hql, Map<String, Object> hqlParameters, int startIndex, int endIndex) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        List result = this.topiaJpaSupport.find(hql, startIndex, endIndex, hqlParameters);
        return result;
    }

    protected List<E> find(String hql, Map<String, Object> hqlParameters, TopiaPagerBean pager) {
        List<E> result = this.find(hql, hqlParameters, this.getEntityClass(), pager);
        return result;
    }

    protected <R> List<R> findAll(String hql, Map<String, Object> hqlParameters, Class<R> type) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        Preconditions.checkNotNull(type);
        List result = this.topiaJpaSupport.findAll(hql, hqlParameters);
        return result;
    }

    protected <R> List<R> find(String hql, Map<String, Object> hqlParameters, Class<R> type, int startIndex, int endIndex) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        Preconditions.checkNotNull(type);
        List result = this.topiaJpaSupport.find(hql, startIndex, endIndex, hqlParameters);
        return result;
    }

    protected <R> List<R> find(String hql, Map<String, Object> hqlParameters, Class<R> type, TopiaPagerBean pager) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull((Object)((Object)pager));
        if (StringUtils.isNotBlank((CharSequence)pager.getSortColumn())) {
            hql = hql + " order by " + pager.getSortColumn();
            if (!pager.isSortAscendant()) {
                hql = hql + " desc";
            }
        }
        List result = this.topiaJpaSupport.find(hql, (int)pager.getRecordStartIndex(), (int)pager.getRecordEndIndex() - 1, hqlParameters);
        return result;
    }

    protected Iterable<E> findAllLazy(String hql, Map<String, Object> hqlParameters) {
        Iterable<E> result = this.findAllLazy(hql, hqlParameters, this.getEntityClass());
        return result;
    }

    protected <R> Iterable<R> findAllLazy(String hql, Map<String, Object> hqlParameters, Class<R> type) {
        Preconditions.checkNotNull((Object)hql);
        Preconditions.checkNotNull(hqlParameters);
        Preconditions.checkNotNull(type);
        final FindAllIterator iterator = new FindAllIterator(this, type, this.batchSize, hql, hqlParameters);
        Iterable result = new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return iterator;
            }
        };
        return result;
    }

    @Override
    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTopiaIdEquals(String topiaId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)topiaId), (Object)"given topiaId is blank");
        org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryStep result = this.forEquals("topiaId", topiaId);
        return result;
    }

    @Override
    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forTopiaIdIn(Iterable<String> topiaIds) {
        Preconditions.checkNotNull(topiaIds, (Object)"given topiaIds is null");
        org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryStep result = this.forIn("topiaId", topiaIds);
        return result;
    }

    @Override
    public E findByTopiaId(String topiaId) throws TopiaNoResultException {
        Object result = this.forTopiaIdEquals(topiaId).findAny();
        return result;
    }

    @Override
    public Optional<E> tryFindByTopiaId(String topiaId) {
        Optional result = this.forTopiaIdEquals(topiaId).tryFindAny();
        return result;
    }

    @Override
    public List<String> findAllIds() {
        List<String> result = ((TopiaQueryBuilderAddCriteriaStep)this.newQueryBuilder()).findAllIds();
        return result;
    }

    @Override
    public List<E> findAll() {
        List result = ((TopiaQueryBuilderAddCriteriaStep)this.newQueryBuilder()).findAll();
        return result;
    }

    @Override
    public Iterable<E> findAllLazy() {
        String hql = "from " + this.getTopiaEntityEnum().getImplementationFQN() + " order by id";
        Map<String, Object> hqlParameters = Collections.emptyMap();
        Iterable<E> result = this.findAllLazy(hql, hqlParameters);
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        Iterator<E> result = this.findAllLazy().iterator();
        return result;
    }

    @Override
    public long count() {
        long result = ((TopiaQueryBuilderAddCriteriaStep)this.newQueryBuilder()).count();
        return result;
    }

    public static class TopiaQueryBuilderRunQueryStep<E extends TopiaEntity>
    implements org.nuiton.topia.persistence.TopiaQueryBuilderRunQueryStep<E> {
        protected final String hql;
        protected final Map<String, Object> hqlParameters;
        protected AbstractTopiaDao<E> topiaDAO;

        protected TopiaQueryBuilderRunQueryStep(AbstractTopiaDao<E> topiaDAO, String hql, Map<String, Object> hqlParameters) {
            this.hql = hql;
            this.hqlParameters = hqlParameters;
            this.topiaDAO = topiaDAO;
        }

        @Override
        public boolean exists() {
            return this.topiaDAO.exists(this.hql, this.hqlParameters);
        }

        @Override
        public long count() {
            String hqlWithSelectClause = "select count(topiaId) " + this.hql;
            return this.topiaDAO.count(hqlWithSelectClause, this.hqlParameters);
        }

        @Override
        public E findUnique() throws TopiaNoResultException, TopiaNonUniqueResultException {
            return this.topiaDAO.findUnique(this.hql, this.hqlParameters);
        }

        @Override
        public E findUniqueOrNull() throws TopiaNonUniqueResultException {
            return this.topiaDAO.findUniqueOrNull(this.hql, this.hqlParameters);
        }

        @Override
        public Optional<E> tryFindUnique() throws TopiaNonUniqueResultException {
            return this.topiaDAO.tryFindUnique(this.hql, this.hqlParameters);
        }

        @Override
        public E findFirst() throws QueryMissingOrderException, TopiaNoResultException {
            return this.topiaDAO.findFirst(this.hql, this.hqlParameters);
        }

        @Override
        public E findFirstOrNull() throws QueryMissingOrderException {
            return this.topiaDAO.findFirstOrNull(this.hql, this.hqlParameters);
        }

        @Override
        public Optional<E> tryFindFirst() throws QueryMissingOrderException {
            return this.topiaDAO.tryFindFirst(this.hql, this.hqlParameters);
        }

        @Override
        public E findAny() throws TopiaNoResultException {
            return this.topiaDAO.findAny(this.hql, this.hqlParameters);
        }

        @Override
        public E findAnyOrNull() {
            return this.topiaDAO.findAnyOrNull(this.hql, this.hqlParameters);
        }

        @Override
        public Optional<E> tryFindAny() {
            return this.topiaDAO.tryFindAny(this.hql, this.hqlParameters);
        }

        @Override
        public List<E> findAll() {
            return this.topiaDAO.findAll(this.hql, this.hqlParameters);
        }

        @Override
        public Iterable<E> findAllLazy() {
            return this.topiaDAO.findAllLazy(this.hql, this.hqlParameters);
        }

        @Override
        public List<E> find(int startIndex, int endIndex) {
            return this.topiaDAO.find(this.hql, this.hqlParameters, startIndex, endIndex);
        }

        @Override
        public List<String> findAllIds() {
            String hqlWithSelectClause = "select topiaId " + this.hql;
            return this.topiaDAO.findAll(hqlWithSelectClause, this.hqlParameters, String.class);
        }

        @Override
        public List<String> findIds(int startIndex, int endIndex) {
            String hqlWithSelectClause = "select topiaId " + this.hql;
            return this.topiaDAO.find(hqlWithSelectClause, this.hqlParameters, String.class, startIndex, endIndex);
        }
    }

    public static class TopiaQueryBuilderAddCriteriaStep<E extends TopiaEntity>
    implements TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> {
        protected AbstractTopiaDao<E> topiaDAO;
        protected HqlAndParametersBuilder<E> hqlAndParametersBuilder;
        protected boolean hasOrderByClause = false;

        protected TopiaQueryBuilderAddCriteriaStep(AbstractTopiaDao<E> topiaDAO, HqlAndParametersBuilder<E> hqlAndParametersBuilder) {
            this.topiaDAO = topiaDAO;
            this.hqlAndParametersBuilder = hqlAndParametersBuilder;
        }

        @Override
        public TopiaQueryBuilderRunQueryStep<E> setOrderByArguments(Set<String> orderByArguments) {
            this.hasOrderByClause = !Iterables.isEmpty(orderByArguments);
            this.hqlAndParametersBuilder.setOrderByArguments(orderByArguments);
            return this.getNextStep();
        }

        @Override
        public TopiaQueryBuilderRunQueryStep<E> setOrderByArguments(String ... orderByArguments) {
            this.hqlAndParametersBuilder.setOrderByArguments(orderByArguments);
            return this.getNextStep();
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addEquals(String property, Object value) {
            this.hqlAndParametersBuilder.addEquals(property, value);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNotEquals(String property, Object value) {
            this.hqlAndParametersBuilder.addNotEquals(property, value);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addIn(String property, Iterable<Object> values) {
            this.hqlAndParametersBuilder.addIn(property, values);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNotIn(String property, Iterable<Object> values) {
            this.hqlAndParametersBuilder.addNotIn(property, values);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addContains(String property, Object value) {
            this.hqlAndParametersBuilder.addContains(property, value);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNotContains(String property, Object value) {
            this.hqlAndParametersBuilder.addNotContains(property, value);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNull(String property) {
            this.hqlAndParametersBuilder.addNull(property);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addNotNull(String property) {
            this.hqlAndParametersBuilder.addNotNull(property);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addTopiaIdEquals(String property, String topiaId) {
            this.hqlAndParametersBuilder.addTopiaIdEquals(property, topiaId);
            return this;
        }

        @Override
        public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> addTopiaIdIn(String property, Iterable<String> topiaIds) {
            this.hqlAndParametersBuilder.addTopiaIdIn(property, topiaIds);
            return this;
        }

        @Override
        public boolean exists() {
            return this.getNextStep().exists();
        }

        @Override
        public E findAnyOrNull() {
            return this.getNextStep().findAnyOrNull();
        }

        @Override
        public E findUniqueOrNull() {
            return this.getNextStep().findUniqueOrNull();
        }

        @Override
        public E findAny() {
            return this.getNextStep().findAny();
        }

        @Override
        public E findUnique() {
            return this.getNextStep().findUnique();
        }

        @Override
        public E findFirst() {
            return this.getNextStep().findFirst();
        }

        @Override
        public E findFirstOrNull() {
            return this.getNextStep().findFirstOrNull();
        }

        @Override
        public Optional<E> tryFindAny() {
            return this.getNextStep().tryFindAny();
        }

        @Override
        public Optional<E> tryFindFirst() {
            return this.getNextStep().tryFindFirst();
        }

        @Override
        public Optional<E> tryFindUnique() {
            return this.getNextStep().tryFindUnique();
        }

        @Override
        public List<E> findAll() {
            return this.getNextStep().findAll();
        }

        @Override
        public List<E> find(int startIndex, int endIndex) {
            return this.getNextStep().find(startIndex, endIndex);
        }

        @Override
        public Iterable<E> findAllLazy() {
            return this.getNextStep().findAllLazy();
        }

        @Override
        public long count() {
            return this.getNextStep().count();
        }

        @Override
        public List<String> findIds(int startIndex, int endIndex) {
            return this.getNextStep().findIds(startIndex, endIndex);
        }

        @Override
        public List<String> findAllIds() {
            return this.getNextStep().findAllIds();
        }

        protected TopiaQueryBuilderRunQueryStep<E> getNextStep() {
            String hql = this.hqlAndParametersBuilder.getHql();
            Map<String, Object> hqlParameters = this.hqlAndParametersBuilder.getHqlParameters();
            TopiaQueryBuilderRunQueryStep<E> nextStep = new TopiaQueryBuilderRunQueryStep<E>(this.topiaDAO, hql, hqlParameters);
            return nextStep;
        }
    }

    public static class FindAllIterator<E extends TopiaEntity, R>
    implements Iterator<R> {
        protected Iterator<R> data;
        protected final AbstractTopiaDao<E> dao;
        protected final Class<R> type;
        protected final String hql;
        protected final Map<String, Object> params;
        protected TopiaPagerBean pager;

        public FindAllIterator(AbstractTopiaDao<E> dao, Class<R> type, int batchSize, String hql, Map<String, Object> params) {
            this.dao = dao;
            this.type = type;
            this.hql = hql;
            this.params = params;
            String hql2 = hql.toLowerCase();
            int i = hql2.indexOf("order by");
            if (i == -1) {
                throw new QueryMissingOrderException(hql, params);
            }
            long count2 = dao.count("SELECT COUNT(*) " + hql.substring(0, i), params);
            this.pager = new TopiaPagerBean();
            this.pager.setRecords(count2);
            this.pager.setPageSize(batchSize);
            PagerBeanUtil.computeRecordIndexesAndPagesNumber((PagerBean)this.pager);
            this.data = Iterators.emptyIterator();
        }

        @Override
        public boolean hasNext() {
            boolean result = this.data.hasNext() || (long)this.pager.getPageIndex() < this.pager.getPagesNumber();
            return result;
        }

        @Override
        public R next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.data.hasNext()) {
                this.pager.setPageIndex(this.pager.getPageIndex() + 1);
                PagerBeanUtil.computeRecordIndexesAndPagesNumber((PagerBean)this.pager);
                this.data = this.dao.find(this.hql, this.params, this.type, this.pager).iterator();
            }
            R next = this.data.next();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support remove operation.");
        }
    }
}

