package org.nuiton.topia.persistence.csv.out;
/*
 * #%L
 * ToPIA :: Persistence
 * $Id: EntityAssociationExportModel.java 2784 2013-07-25 17:03:03Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-6/topia-persistence/src/main/java/org/nuiton/topia/persistence/csv/out/EntityAssociationExportModel.java $
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.metadata.AssociationMeta;
import org.nuiton.topia.persistence.csv.TopiaCsvCommons;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.ext.AbstractExportModel;

/**
 * A model to export associations of entities into csv files.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.6.12
 */
public class EntityAssociationExportModel<T extends TopiaEntityEnum, E extends TopiaEntity> extends AbstractExportModel<E> {

    protected final AssociationMeta meta;

    public static <T extends TopiaEntityEnum, E extends TopiaEntity> ExportModel<E> newExportModel(char separator,
                                                                                                   AssociationMeta<T> meta
    ) {
        EntityAssociationExportModel<T, E> model = new EntityAssociationExportModel<T, E>(
                separator,
                meta);

        // topiaId <-> topiaId
        model.newColumnForExport(TopiaEntity.PROPERTY_TOPIA_ID);

        model.newColumnForExport(
                meta.getName(),
                TopiaCsvCommons.newAssociationValueFormatter()
        );
        return model;
    }

    EntityAssociationExportModel(char separator, AssociationMeta<T> meta) {
        super(separator);
        this.meta = meta;
    }
}
