/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topiatest.deletetest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.nuiton.topia.TopiaDaoSupplier;
import org.nuiton.topia.TopiaDatabase;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.TopiaTestTopiaPersistenceContext;
import org.nuiton.topiatest.Gender;
import org.nuiton.topiatest.Personne;
import org.nuiton.topiatest.PersonneDAO;
import org.nuiton.topiatest.deletetest.Contact2;
import org.nuiton.topiatest.deletetest.Contact2DAO;
import org.nuiton.topiatest.deletetest.Party2;
import org.nuiton.topiatest.deletetest.Party2DAO;

public class DeleteEntityTest {
    private static final Log log = LogFactory.getLog(DeleteEntityTest.class);
    @Rule
    public final TopiaDatabase db = new TopiaDatabase();

    @Test
    public void testDeleteEntityWithInheritance() throws TopiaException {
        log.debug((Object)"START TEST : testDeleteEntityWithInheritance");
        TopiaTestTopiaPersistenceContext transaction = this.db.beginTransaction();
        log.debug((Object)"DAO : PersonneDAO");
        PersonneDAO dao = TopiaTestDAOHelper.getPersonneDAO((TopiaDaoSupplier)transaction);
        log.debug((Object)"CREATE PERSONNE : Bob Marley");
        Personne personne = (Personne)dao.create("name", "Bob Marley", new Object[0]);
        transaction.commitTransaction();
        String idPersonne = personne.getTopiaId();
        Assert.assertNotNull((Object)idPersonne);
        log.debug((Object)"ENTITY PERSONNE SAVED !");
        log.debug((Object)"DELETE PERSONNE");
        dao.delete(personne);
        transaction.commitTransaction();
        Personne res = (Personne)dao.forTopiaIdEquals(idPersonne).findAnyOrNull();
        Assert.assertNull((Object)res);
        log.debug((Object)"ENTITY PERSONNE DELETED !");
        log.debug((Object)"CREATE PERSONNE : Ziggy Marley");
        Personne personne2 = (Personne)dao.create("name", "Ziggy Marley", new Object[0]);
        transaction.commitTransaction();
        String idPersonne2 = personne2.getTopiaId();
        Assert.assertNotNull((Object)idPersonne2);
        log.debug((Object)"ENTITY PERSONNE SAVED !");
        log.debug((Object)"DAO parent (abstract) : PartyDAO");
        Party2DAO dao2 = TopiaTestDAOHelper.getParty2DAO((TopiaDaoSupplier)transaction);
        log.debug((Object)"DELETE PERSONNE with PartyDAO");
        dao2.delete(personne2);
        transaction.commitTransaction();
        Party2 res2 = (Party2)dao2.forTopiaIdEquals(idPersonne2).findAnyOrNull();
        Assert.assertNull((Object)res2);
        log.debug((Object)"ENTITY PERSONNE DELETED !");
    }

    @Test
    public void testDeleteEntityWithManyToManyRelation() throws TopiaException {
        log.debug((Object)"START TEST : testDeleteEntityWithManyToManyRelation");
        TopiaTestTopiaPersistenceContext transaction = this.db.beginTransaction();
        PersonneDAO dao = TopiaTestDAOHelper.getPersonneDAO((TopiaDaoSupplier)transaction);
        log.debug((Object)"CREATE PERSONNE : Bob Marley");
        Personne personne = (Personne)dao.create("name", "Bob Marley", new Object[0]);
        transaction.commitTransaction();
        String idPersonne = personne.getTopiaId();
        Assert.assertNotNull((Object)idPersonne);
        log.debug((Object)"ENTITY PERSONNE SAVED !");
        Contact2DAO contactDAO = TopiaTestDAOHelper.getContact2DAO((TopiaDaoSupplier)transaction);
        log.debug((Object)"CREATE CONTACT : jaja@codelutin.com");
        Contact2 contact = (Contact2)contactDAO.create("contactValue", "jaja@codelutin.com", new Object[0]);
        transaction.commitTransaction();
        String idContact = contact.getTopiaId();
        Assert.assertNotNull((Object)idContact);
        log.debug((Object)"ENTITY CONTACT SAVED !");
        log.debug((Object)"ADD CONTACT TO PERSONNE");
        personne.addContacts(contact);
        transaction.commitTransaction();
        Assert.assertEquals((long)1L, (long)personne.getContacts().size());
        log.debug((Object)"CONTACT ADDED !");
        log.debug((Object)"DELETE PERSONNE");
        dao.delete(personne);
        transaction.commitTransaction();
        Personne res = (Personne)dao.forTopiaIdEquals(idPersonne).findAnyOrNull();
        Assert.assertNull((Object)res);
        log.debug((Object)"ENTITY PERSONNE DELETED !");
        Assert.assertEquals((long)0L, (long)contact.getParty2().size());
        log.debug((Object)"DELETE CONTACT");
        contactDAO.delete(contact);
        transaction.commitTransaction();
        Contact2 res2 = (Contact2)contactDAO.forTopiaIdEquals(idContact).findAnyOrNull();
        Assert.assertNull((Object)res2);
        log.debug((Object)"ENTITY PERSONNE DELETED !");
    }

    @Test
    public void testIsPersisted() {
        log.debug((Object)"START TEST : testIsPersisted");
        TopiaTestTopiaPersistenceContext transaction = this.db.beginTransaction();
        PersonneDAO dao = TopiaTestDAOHelper.getPersonneDAO((TopiaDaoSupplier)transaction);
        Personne person = (Personne)dao.newInstance();
        Assert.assertNull((Object)person.getTopiaId());
        person.setName("Arno");
        person.setGender(Gender.MALE);
        Assert.assertFalse((boolean)person.isPersisted());
        Personne person2 = (Personne)dao.create(person);
        Assert.assertTrue((boolean)person.isPersisted());
        Assert.assertTrue((boolean)person2.isPersisted());
        dao.delete(person2);
        Assert.assertFalse((boolean)person.isPersisted());
        Assert.assertFalse((boolean)person2.isPersisted());
    }
}

