/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.test.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.Pet;

public abstract class PersonAbstract
extends TopiaEntityAbstract
implements Person {
    protected String name;
    protected String firstname;
    protected Collection<Pet> pet;
    private static final long serialVersionUID = 3979040660960470069L;

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start((TopiaEntity)this);
        visitor.visit((TopiaEntity)this, "name", String.class, (Object)this.name);
        visitor.visit((TopiaEntity)this, "firstname", String.class, (Object)this.firstname);
        visitor.visit((TopiaEntity)this, "pet", Collection.class, Pet.class, this.pet);
        visitor.end((TopiaEntity)this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        this.fireOnPreWrite("name", oldValue, name);
        this.name = name;
        this.fireOnPostWrite("name", oldValue, name);
    }

    @Override
    public String getName() {
        this.fireOnPreRead("name", this.name);
        String result = this.name;
        this.fireOnPostRead("name", this.name);
        return result;
    }

    @Override
    public void setFirstname(String firstname) {
        String oldValue = this.firstname;
        this.fireOnPreWrite("firstname", oldValue, firstname);
        this.firstname = firstname;
        this.fireOnPostWrite("firstname", oldValue, firstname);
    }

    @Override
    public String getFirstname() {
        this.fireOnPreRead("firstname", this.firstname);
        String result = this.firstname;
        this.fireOnPostRead("firstname", this.firstname);
        return result;
    }

    @Override
    public void addPet(Pet pet) {
        this.fireOnPreWrite("pet", null, pet);
        if (this.pet == null) {
            this.pet = new ArrayList<Pet>();
        }
        pet.setPerson(this);
        this.pet.add(pet);
        this.fireOnPostWrite("pet", this.pet.size(), null, pet);
    }

    @Override
    public void addAllPet(Collection<Pet> pet) {
        if (pet == null) {
            return;
        }
        for (Pet item : pet) {
            this.addPet(item);
        }
    }

    @Override
    public void setPet(Collection<Pet> pet) {
        ArrayList<Pet> oldValue = this.pet != null ? new ArrayList<Pet>(this.pet) : null;
        this.fireOnPreWrite("pet", oldValue, pet);
        this.pet = pet;
        this.fireOnPostWrite("pet", oldValue, pet);
    }

    @Override
    public void removePet(Pet pet) {
        this.fireOnPreWrite("pet", pet, null);
        if (this.pet == null || !this.pet.remove(pet)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        pet.setPerson(null);
        this.fireOnPostWrite("pet", this.pet.size() + 1, pet, null);
    }

    @Override
    public void clearPet() {
        if (this.pet == null) {
            return;
        }
        for (Pet item : this.pet) {
            item.setPerson(null);
        }
        ArrayList<Pet> oldValue = new ArrayList<Pet>(this.pet);
        this.fireOnPreWrite("pet", oldValue, this.pet);
        this.pet.clear();
        this.fireOnPostWrite("pet", oldValue, this.pet);
    }

    @Override
    public Collection<Pet> getPet() {
        return this.pet;
    }

    @Override
    public Pet getPetByTopiaId(String topiaId) {
        return (Pet)TopiaEntityHelper.getEntityByTopiaId(this.pet, (String)topiaId);
    }

    @Override
    public int sizePet() {
        if (this.pet == null) {
            return 0;
        }
        return this.pet.size();
    }

    @Override
    public boolean isPetEmpty() {
        int size = this.sizePet();
        return size == 0;
    }

    public List<TopiaEntity> getAggregate() throws TopiaException {
        throw new UnsupportedOperationException("Since ToPIA 3.0, 'getComposite' is only available for contextable entities");
    }

    public List<TopiaEntity> getComposite() throws TopiaException {
        throw new UnsupportedOperationException("Since ToPIA 3.0, 'getComposite' is only available for contextable entities");
    }

    public String toString() {
        String result = new ToStringBuilder((Object)this).append("name", (Object)this.name).append("firstname", (Object)this.firstname).toString();
        return result;
    }

    static {
        I18n.n_((String)"topia.test.common.person", (Object[])new Object[0]);
        I18n.n_((String)"topia.test.common.name", (Object[])new Object[0]);
        I18n.n_((String)"topia.test.common.firstname", (Object[])new Object[0]);
        I18n.n_((String)"topia.test.common.pet", (Object[])new Object[0]);
    }
}

