/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.nuiton.topia.TopiaDatabase;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaJpaSupport;
import org.nuiton.topia.TopiaTestTopiaPersistenceContext;
import org.nuiton.topiatest.Address;
import org.nuiton.topiatest.AddressTopiaDao;
import org.nuiton.topiatest.Gender;
import org.nuiton.topiatest.Personne;
import org.nuiton.topiatest.PersonneTopiaDao;

public class TopiaJpaSupportTest {
    @Rule
    public final TopiaDatabase db = new TopiaDatabase();
    protected TopiaTestTopiaPersistenceContext persistenceContext;
    protected TopiaJpaSupport jpaSupport;
    protected AddressTopiaDao addressDAO;
    protected PersonneTopiaDao personneDAO;
    protected Address address;

    @Before
    public void createCompanies() throws TopiaException {
        this.persistenceContext = this.db.beginTransaction();
        this.jpaSupport = this.persistenceContext.jpaSupport;
        this.personneDAO = this.persistenceContext.getPersonneDao();
        this.addressDAO = this.persistenceContext.getAddressDao();
        this.address = (Address)this.addressDAO.create("adress", "17 rue de la Pote Gell\u00e9e, 44200 NANTES", new Object[0]);
        this.personneDAO.create("name", "Arnaud", new Object[]{"gender", Gender.MALE});
        this.personneDAO.create("name", "Charlotte", new Object[]{"gender", Gender.FEMALE});
        this.personneDAO.create("name", "Hortense", new Object[]{"gender", Gender.FEMALE});
        this.persistenceContext.commitTransaction();
    }

    @Test
    public void testFindDAO() throws TopiaException {
        Assert.assertEquals((long)3L, (long)this.personneDAO.count());
        Assert.assertEquals((long)2L, (long)this.personneDAO.findAllByGender(Gender.FEMALE).size());
        Assert.assertNotNull(this.personneDAO.findByGender(Gender.FEMALE));
        Assert.assertNotNull(this.personneDAO.findByGender(Gender.MALE));
        Assert.assertNull(this.personneDAO.findByGender(null));
        Assert.assertEquals((long)0L, (long)this.personneDAO.findAllByName("nobody").size());
    }

    @Test
    public void testFindAll() throws TopiaException {
        Assert.assertEquals((long)3L, (long)this.personneDAO.count());
        String query = "from " + Personne.class.getName() + " where " + "gender" + "=:g";
        List females = this.jpaSupport.findAll(query, new Object[]{"g", Gender.FEMALE});
        Assert.assertEquals((long)2L, (long)females.size());
        List males = this.jpaSupport.findAll(query, new Object[]{"g", Gender.MALE});
        Assert.assertEquals((long)1L, (long)males.size());
        List all = this.jpaSupport.findAll("from " + Personne.class.getName(), new Object[0]);
        Assert.assertEquals((long)3L, (long)all.size());
        List none = this.jpaSupport.findAll("from " + Personne.class.getName() + " where " + "name" + "=:pax", new Object[]{"pax", "nobody"});
        Assert.assertEquals((long)0L, (long)none.size());
    }

    @Test
    public void testFind() throws TopiaException {
        Assert.assertEquals((long)3L, (long)this.personneDAO.count());
        String query = "from " + Personne.class.getName() + " where " + "gender" + "=:g";
        List females = this.jpaSupport.find(query, 0, 100, new Object[]{"g", Gender.FEMALE});
        Assert.assertEquals((long)2L, (long)females.size());
        females = this.jpaSupport.find(query, 0, 0, new Object[]{"g", Gender.FEMALE});
        Assert.assertEquals((long)1L, (long)females.size());
        Personne charlotte = (Personne)females.get(0);
        females = this.jpaSupport.find(query, 1, 1, new Object[]{"g", Gender.FEMALE});
        Assert.assertEquals((long)1L, (long)females.size());
        Personne hortense = (Personne)females.get(0);
        Assert.assertFalse((boolean)hortense.equals(charlotte));
    }

    @Test
    public void testFindUnique() throws TopiaException {
        Assert.assertEquals((long)3L, (long)this.personneDAO.count());
        String query = "from " + Personne.class.getName() + " where " + "gender" + "=:g";
        Object male = this.jpaSupport.findUnique(query, new Object[]{"g", Gender.MALE});
        Assert.assertNotNull((Object)male);
        Object none = this.jpaSupport.findUnique("from " + Personne.class.getName() + " where " + "name" + "=:pax", new Object[]{"pax", "nobody"});
        Assert.assertNull((Object)none);
    }

    @Test(expected=TopiaException.class)
    public void testFindUniqueOutOfBounds() throws TopiaException {
        Assert.assertEquals((long)3L, (long)this.personneDAO.count());
        String query = "from " + Personne.class.getName() + " where " + "gender" + "=:g";
        Object female = this.jpaSupport.findUnique(query, new Object[]{"g", Gender.FEMALE});
        Assert.assertNotNull((Object)female);
    }
}

