package org.nuiton.topia.persistence.csv.out;
/*
 * #%L
 * ToPIA :: Persistence
 * $Id: PrepareDataForExport.java 2657 2012-09-05 15:59:50Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-3.1/topia-persistence/src/main/java/org/nuiton/topia/persistence/csv/out/PrepareDataForExport.java $
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.metadata.AssociationMeta;
import org.nuiton.topia.persistence.metadata.TableMeta;

/**
 * Prepare data to export.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.6.12
 */
public interface PrepareDataForExport<T extends TopiaEntityEnum> {

    <E extends TopiaEntity> Iterable<E> prepareData(TableMeta<T> tableMeta);

    <E extends TopiaEntity> Iterable<E> prepareData(AssociationMeta<T> associationMeta);
}
