package org.nuiton.topia.persistence;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: DefaultTopiaIdFactory.java 2787 2013-08-03 01:14:27Z athimel $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-2/topia-persistence/src/main/java/org/nuiton/topia/persistence/DefaultTopiaIdFactory.java $
 * %%
 * Copyright (C) 2004 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.UUID;

import org.nuiton.topia.TopiaException;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;

/**
 * Default implementation of {@link TopiaIdFactory}. Generates an FQN followed
 * by an random UUID.
 *
 * @author Brendan Le Ny <leny@codelutin.com>
 * @since 3.0
 */
public class DefaultTopiaIdFactory implements TopiaIdFactory {

    @Override
    public <E extends TopiaEntity> String newTopiaId(Class<E> entityClass, TopiaEntity topiaEntity) {
        if (!entityClass.isInterface()) {
            throw new IllegalArgumentException(
                    "Only interface is permit to create id: " + entityClass);
        }
        String result = entityClass.getName() + '_' + UUID.randomUUID().toString();
        return result;
    }

    @Override
    public <E extends TopiaEntity> Class<E> getClassName(String topiaId) {
        String className = Iterables.get(Splitter.on('_').split(topiaId), 0);
        try {
            Class<E> entityClass = (Class<E>) Class.forName(className);
            return entityClass;
        } catch (ClassNotFoundException e) {
            throw new TopiaException("can't find class for topiaId = '" + topiaId + "'", e);
        }
    }

}
