/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaNotFoundException;
import org.nuiton.topia.persistence.support.TopiaHibernateSupport;
import org.nuiton.util.RecursiveProperties;
import org.nuiton.util.Resource;

public class TopiaUtil {
    private static final Log log = LogFactory.getLog(TopiaUtil.class);

    public static Properties getProperties(String pathOrUrl) throws TopiaNotFoundException {
        return TopiaUtil.getProperties(null, pathOrUrl);
    }

    public static Properties getProperties(Properties parent, String pathOrUrl) throws TopiaNotFoundException {
        RecursiveProperties result = new RecursiveProperties(parent);
        if (pathOrUrl != null && !pathOrUrl.equals("")) {
            try {
                URL propURL = Resource.getURL((String)pathOrUrl);
                log.info((Object)("Properties file used for " + pathOrUrl + " is: " + propURL));
                result.load(propURL.openStream());
            }
            catch (Exception eee) {
                throw new TopiaNotFoundException("Properties file can't be found: " + pathOrUrl, eee);
            }
        }
        return result;
    }

    public static Pattern getTopiaPattern(String format, Class<? extends TopiaEntity> ... classes) {
        String[] entityPatterns = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            Class<? extends TopiaEntity> aClass = classes[i];
            entityPatterns[i] = "(" + TopiaUtil.getTopiaIdPattern(aClass) + ")";
        }
        String s = String.format(format, entityPatterns);
        if (log.isDebugEnabled()) {
            log.debug((Object)s);
        }
        return Pattern.compile(s);
    }

    public static String getTopiaIdPattern(Class<? extends TopiaEntity> klass) {
        StringBuilder buffer = new StringBuilder();
        StringTokenizer stk = new StringTokenizer(klass.getName(), ".");
        while (stk.hasMoreTokens()) {
            buffer.append("\\.").append(stk.nextToken());
        }
        buffer.append("#(?:\\d+?)#(?:\\d+)\\.(?:\\d+)");
        return buffer.substring(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSchemaExist(TopiaHibernateSupport topiaHibernateSupport, String entityName) {
        ConnectionProviderSupplier connectionProviderSupplier = new ConnectionProviderSupplier(topiaHibernateSupport);
        boolean exist = false;
        try {
            Configuration configuration = topiaHibernateSupport.getHibernateConfiguration();
            PersistentClass classMapping = configuration.getClassMapping(entityName);
            if (classMapping == null) {
                if (log.isInfoEnabled()) {
                    Iterator itr = configuration.getClassMappings();
                    while (itr.hasNext()) {
                        log.info((Object)("available mapping " + itr.next()));
                    }
                }
                throw new IllegalArgumentException("could not find entity with name " + entityName);
            }
            Table testTable = classMapping.getTable();
            if (testTable == null) {
                throw new IllegalArgumentException("could not find entity with name " + entityName);
            }
            ConnectionProvider connectionProvider = connectionProviderSupplier.get();
            Dialect dialect = Dialect.getDialect((Properties)configuration.getProperties());
            Connection connection = null;
            try {
                connection = connectionProvider.getConnection();
                DatabaseMetadata meta = new DatabaseMetadata(connection, dialect, configuration);
                TableMetadata tmd = meta.getTableMetadata(testTable.getName(), testTable.getSchema(), testTable.getCatalog(), testTable.isQuoted());
                if (tmd != null) {
                    exist = true;
                }
            }
            finally {
                connectionProvider.closeConnection(connection);
            }
        }
        catch (SQLException e) {
            log.error((Object)"Cant connect to database", (Throwable)e);
        }
        catch (TopiaNotFoundException e) {
            log.error((Object)"Cant connect to database", (Throwable)e);
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSchemaExist(Configuration configuration, String entityName) {
        ConnectionProviderSupplier connectionProviderSupplier = new ConnectionProviderSupplier(configuration);
        boolean exist = false;
        try {
            PersistentClass classMapping = configuration.getClassMapping(entityName);
            if (classMapping == null) {
                if (log.isInfoEnabled()) {
                    Iterator itr = configuration.getClassMappings();
                    while (itr.hasNext()) {
                        log.info((Object)("available mapping " + itr.next()));
                    }
                }
                throw new IllegalArgumentException("could not find entity with name " + entityName);
            }
            Table testTable = classMapping.getTable();
            if (testTable == null) {
                throw new IllegalArgumentException("could not find entity with name " + entityName);
            }
            ConnectionProvider connectionProvider = connectionProviderSupplier.get();
            Dialect dialect = Dialect.getDialect((Properties)configuration.getProperties());
            Connection connection = null;
            try {
                connection = connectionProvider.getConnection();
                DatabaseMetadata meta = new DatabaseMetadata(connection, dialect, configuration);
                TableMetadata tmd = meta.getTableMetadata(testTable.getName(), testTable.getSchema(), testTable.getCatalog(), testTable.isQuoted());
                if (tmd != null) {
                    exist = true;
                }
            }
            finally {
                connectionProvider.closeConnection(connection);
            }
        }
        catch (SQLException e) {
            log.error((Object)"Cant connect to database", (Throwable)e);
        }
        try {
            connectionProviderSupplier.close();
        }
        catch (IOException e) {
            log.error((Object)"Cant close connection provider", (Throwable)e);
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSchemaEmpty(Configuration configuration) {
        ConnectionProviderSupplier connectionProviderSupplier = new ConnectionProviderSupplier(configuration);
        try {
            ConnectionProvider connectionProvider = connectionProviderSupplier.get();
            Dialect dialect = Dialect.getDialect((Properties)configuration.getProperties());
            Connection connection = null;
            try {
                connection = connectionProvider.getConnection();
                DatabaseMetadata meta = new DatabaseMetadata(connection, dialect, configuration);
                Iterator itr = configuration.getClassMappings();
                while (itr.hasNext()) {
                    PersistentClass classMapping = (PersistentClass)itr.next();
                    Table testTable = classMapping.getTable();
                    if (testTable == null) {
                        throw new IllegalArgumentException("could not find entity with name " + classMapping.getClassName());
                    }
                    TableMetadata tmd = meta.getTableMetadata(testTable.getName(), testTable.getSchema(), testTable.getCatalog(), testTable.isQuoted());
                    if (tmd == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Existing table found " + testTable.getName() + " for entity " + classMapping.getClassName() + ", db is not empty."));
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                connectionProvider.closeConnection(connection);
            }
        }
        catch (SQLException e) {
            log.error((Object)"Cant connect to database", (Throwable)e);
        }
        try {
            connectionProviderSupplier.close();
            return true;
        }
        catch (IOException e) {
            log.error((Object)"Cant close connection provider", (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSchemaEmpty(TopiaHibernateSupport topiaHibernateSupport) {
        ConnectionProviderSupplier connectionProviderSupplier = new ConnectionProviderSupplier(topiaHibernateSupport);
        Configuration configuration = topiaHibernateSupport.getHibernateConfiguration();
        try {
            ConnectionProvider connectionProvider = connectionProviderSupplier.get();
            Dialect dialect = Dialect.getDialect((Properties)configuration.getProperties());
            Connection connection = null;
            try {
                connection = connectionProvider.getConnection();
                DatabaseMetadata meta = new DatabaseMetadata(connection, dialect, configuration);
                Iterator itr = configuration.getClassMappings();
                while (itr.hasNext()) {
                    PersistentClass classMapping = (PersistentClass)itr.next();
                    Table testTable = classMapping.getTable();
                    if (testTable == null) {
                        throw new IllegalArgumentException("could not find entity with name " + classMapping.getClassName());
                    }
                    TableMetadata tmd = meta.getTableMetadata(testTable.getName(), testTable.getSchema(), testTable.getCatalog(), testTable.isQuoted());
                    if (tmd == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Existing table found " + testTable.getName() + " for entity " + classMapping.getClassName() + ", db is not empty."));
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                connectionProvider.closeConnection(connection);
            }
        }
        catch (SQLException e) {
            log.error((Object)"Cant connect to database", (Throwable)e);
        }
        try {
            connectionProviderSupplier.close();
            return true;
        }
        catch (IOException e) {
            log.error((Object)"Cant close connection provider", (Throwable)e);
        }
        return true;
    }

    public static String getSchemaName(Configuration config) {
        return config.getProperty("hibernate.default_schema");
    }

    public static Map<String, Object> convertPropertiesArrayToMap(Object ... propertyNamesAndValues) throws IllegalArgumentException {
        int propertiesLength = propertyNamesAndValues.length;
        Preconditions.checkArgument((propertiesLength % 2 == 0 ? 1 : 0) != 0, (Object)("Wrong number of argument " + propertiesLength + ", you must have even number."));
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        int i = 0;
        while (i < propertyNamesAndValues.length) {
            Object aPropertyName = propertyNamesAndValues[i++];
            Object value = propertyNamesAndValues[i++];
            Preconditions.checkArgument((boolean)(aPropertyName instanceof String), (Object)("Argument at position [" + (i - 1) + "] " + "should be a property name (says a String) but was " + aPropertyName));
            properties.put((String)aPropertyName, value);
        }
        return properties;
    }

    public static Map<String, Object> convertPropertiesArrayToMap(String propertyName, Object propertyValue, Object ... otherPropertyNamesAndValues) throws IllegalArgumentException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, propertyValue);
        properties.putAll(TopiaUtil.convertPropertiesArrayToMap(otherPropertyNamesAndValues));
        return properties;
    }

    public static class ConnectionProviderSupplier
    implements Supplier<ConnectionProvider>,
    Closeable {
        protected ServiceRegistry serviceRegistry;
        protected ConnectionProvider connectionProvider;
        protected final boolean inlineRegistry;

        public ConnectionProviderSupplier(TopiaHibernateSupport topiaHibernateSupport) {
            this.inlineRegistry = false;
            SessionFactory sessionFactory = topiaHibernateSupport.getHibernateFactory();
            SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)sessionFactory;
            this.serviceRegistry = sessionFactoryImplementor.getServiceRegistry();
        }

        public ConnectionProviderSupplier(Configuration configuration) {
            this.inlineRegistry = true;
            Properties properties = configuration.getProperties();
            ServiceRegistryBuilder builder = new ServiceRegistryBuilder().applySettings((Map)properties);
            this.serviceRegistry = builder.buildServiceRegistry();
        }

        public ConnectionProvider get() {
            if (this.connectionProvider == null) {
                this.connectionProvider = (ConnectionProvider)this.serviceRegistry.getService(ConnectionProvider.class);
            }
            return this.connectionProvider;
        }

        @Override
        public void close() throws IOException {
            if (this.inlineRegistry) {
                ServiceRegistryBuilder.destroy((ServiceRegistry)this.serviceRegistry);
            }
        }
    }
}

