package org.nuiton.topia.test.entities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper.TopiaTestEntityEnum;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

@Generated(value = "org.nuiton.topia.generator.EntityDAOTransformer", date = "Tue Jul 23 18:25:33 CEST 2013")
public abstract class PetDAOAbstract<E extends Pet> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Pet.class;
    }

    @Override
    public TopiaTestEntityEnum getTopiaEntityEnum() {
        return TopiaTestEntityEnum.Pet;
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Pet.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Pet.PROPERTY_NAME, v);
        return result;
    }

    public E findByType(String v) throws TopiaException {
        E result = findByProperty(Pet.PROPERTY_TYPE, v);
        return result;
    }

    public List<E> findAllByType(String v) throws TopiaException {
        List<E> result = findAllByProperty(Pet.PROPERTY_TYPE, v);
        return result;
    }

    public E findByPerson(Person v) throws TopiaException {
        E result = findByProperty(Pet.PROPERTY_PERSON, v);
        return result;
    }

    public List<E> findAllByPerson(Person v) throws TopiaException {
        List<E> result = findAllByProperty(Pet.PROPERTY_PERSON, v);
        return result;
    }

    public E findByRace(Race v) throws TopiaException {
        E result = findByProperty(Pet.PROPERTY_RACE, v);
        return result;
    }

    public List<E> findAllByRace(Race v) throws TopiaException {
        List<E> result = findAllByProperty(Pet.PROPERTY_RACE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Person.class) {
            PersonDAO dao = (PersonDAO)
                getContext().getDAO(Person.class);
            tmp = dao.findAllContainsPet(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Person.class, entity);
        if (!list.isEmpty()) {
            result.put(Person.class, list);
        }

        return result;
    }

} //PetDAOAbstract<E extends Pet>
