/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;

public class TopiaConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final Log log = LogFactory.getLog(TopiaConnectionProvider.class);
    private static final long serialVersionUID = -8190835231054317644L;
    protected String url;
    protected Properties connectionProps;
    protected Integer isolation;
    protected boolean autocommit;
    protected int poolSize;
    private boolean stopped;
    protected final List<Connection> pool = new ArrayList<Connection>();

    public void configure(Map configurationValues) throws HibernateException {
        String driverClass;
        this.poolSize = ConfigurationHelper.getInt((String)"hibernate.connection.pool_size", (Map)configurationValues, (int)20);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Connection pool size: " + this.poolSize));
        }
        this.autocommit = ConfigurationHelper.getBoolean((String)"hibernate.connection.autocommit", (Map)configurationValues);
        if (log.isDebugEnabled()) {
            log.debug((Object)("autocommit mode: " + this.autocommit));
        }
        this.isolation = ConfigurationHelper.getInteger((String)"hibernate.connection.isolation", (Map)configurationValues);
        if (this.isolation != null && log.isDebugEnabled()) {
            log.debug((Object)("JDBC isolation level: " + Environment.isolationLevelToString((int)this.isolation)));
        }
        if ((driverClass = ConfigurationHelper.getString((String)"hibernate.connection.driver_class", (Map)configurationValues)) == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"no JDBC Driver class was specified by property hibernate.connection.driver_class");
            }
        } else {
            try {
                Class.forName(driverClass);
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    ReflectHelper.classForName((String)driverClass);
                }
                catch (ClassNotFoundException e) {
                    String msg = "JDBC Driver class not found: " + driverClass;
                    log.error((Object)msg, (Throwable)e);
                    throw new HibernateException(msg, (Throwable)e);
                }
            }
        }
        this.url = (String)configurationValues.get("hibernate.connection.url");
        if (this.url == null) {
            String msg = "JDBC URL was not specified by property hibernate.connection.url";
            if (log.isErrorEnabled()) {
                log.error((Object)msg);
            }
            throw new HibernateException(msg);
        }
        this.connectionProps = ConnectionProviderInitiator.getConnectionProperties((Map)configurationValues);
        if (log.isDebugEnabled()) {
            log.debug((Object)("using driver: " + driverClass + " at URL: " + this.url));
        }
        if (log.isTraceEnabled()) {
            log.debug((Object)("connection properties: " + this.connectionProps));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("connection properties: " + ConfigurationHelper.maskOut((Properties)this.connectionProps, (String)"password")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        Connection connection = null;
        List<Connection> list = this.pool;
        synchronized (list) {
            while (!this.pool.isEmpty() && connection == null) {
                int last = this.pool.size() - 1;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("using pooled JDBC connection, pool size: " + last));
                }
                if (!(connection = this.pool.remove(last)).isClosed()) continue;
                connection = null;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Remove already closed connection from pool " + connection));
            }
        }
        if (connection == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("opening new JDBC connection to " + this.url));
            }
            connection = DriverManager.getConnection(this.url, this.connectionProps);
        }
        if (this.isolation != null) {
            connection.setTransactionIsolation(this.isolation);
        }
        if (connection.getAutoCommit() != this.autocommit) {
            connection.setAutoCommit(this.autocommit);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(Connection conn) throws SQLException {
        if (conn.isClosed()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Connection [" + conn + "] alreay closed!, will not use it any longer "));
            }
            return;
        }
        List<Connection> list = this.pool;
        synchronized (list) {
            int currentSize = this.pool.size();
            if (currentSize < this.getPoolSize()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("returning connection to pool, pool size: " + (currentSize + 1)));
                }
                this.pool.add(conn);
                return;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"closing JDBC connection");
        }
        conn.close();
    }

    protected void finalize() throws Throwable {
        if (!this.stopped) {
            this.stop();
        }
        super.finalize();
    }

    public void stop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("cleaning up connection pool: " + this.url));
        }
        for (Connection connection : this.pool) {
            try {
                connection.close();
            }
            catch (SQLException sqle) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"problem closing pooled connection", (Throwable)sqle);
            }
        }
        this.pool.clear();
        this.stopped = true;
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public String getUrl() {
        return this.url;
    }

    public Properties getConnectionProps() {
        return this.connectionProps;
    }

    public Integer getIsolation() {
        return this.isolation;
    }

    public List<Connection> getPool() {
        return this.pool;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public boolean isAutocommit() {
        return this.autocommit;
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return ConnectionProvider.class.equals((Object)unwrapType) || this.getClass().isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || this.getClass().isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }
}

