package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper.TopiaTestEntityEnum;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

@Generated(value = "org.nuiton.topia.generator.EntityDAOTransformer", date = "Fri Jul 04 16:00:31 CEST 2014")
public abstract class DepartmentDAOAbstract<E extends Department> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Department.class;
    }

    @Override
    public TopiaTestEntityEnum getTopiaEntityEnum() {
        return TopiaTestEntityEnum.Department;
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Department.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Department.PROPERTY_NAME, v);
        return result;
    }

    public E findByLeader(Employe v) throws TopiaException {
        E result = findByProperty(Department.PROPERTY_LEADER, v);
        return result;
    }

    public List<E> findAllByLeader(Employe v) throws TopiaException {
        List<E> result = findAllByProperty(Department.PROPERTY_LEADER, v);
        return result;
    }

    public E findByCompany(Company v) throws TopiaException {
        E result = findByProperty(Department.PROPERTY_COMPANY, v);
        return result;
    }

    public List<E> findAllByCompany(Company v) throws TopiaException {
        List<E> result = findAllByProperty(Department.PROPERTY_COMPANY, v);
        return result;
    }

    public E findContainsProduct(Product v) throws TopiaException {
        E result = findContains(Department.PROPERTY_PRODUCT, v);
        return result;
    }

    public List<E> findAllContainsProduct(Product v) throws TopiaException {
        List<E> result = findAllContains(Department.PROPERTY_PRODUCT, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Company.class) {
            CompanyDAO dao = (CompanyDAO)
                getContext().getDAO(Company.class);
            tmp = dao.findAllContainsDepartment(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Company.class, entity);
        if (!list.isEmpty()) {
            result.put(Company.class, list);
        }

        return result;
    }

} //DepartmentDAOAbstract<E extends Department>
