package org.nuiton.topia.test.entities;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class PersonDTO implements Serializable {

    protected String topiaId;

    public String name;

    public String firstname;

    public PetDTO[] pet;

    protected final PropertyChangeSupport p = new PropertyChangeSupport(this);

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }

    public void setName(String value) {
        java.lang.String oldValue = this.name;
        this.name = value;
        p.firePropertyChange("name", oldValue, value);
    }

    public String getName() {
        return name;
    }

    public void setFirstname(String value) {
        java.lang.String oldValue = this.firstname;
        this.firstname = value;
        p.firePropertyChange("firstname", oldValue, value);
    }

    public String getFirstname() {
        return firstname;
    }

    public void setPet(PetDTO[] values) {
        org.nuiton.topia.test.entities.PetDTO[] oldValues = this.pet;
        this.pet = values;
        p.firePropertyChange("pet", oldValues, values);
    }

    public PetDTO[] getPet() {
        return pet;
    }

    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("firstname", this.firstname).
         toString();
        return result;
}

} //PersonDTO
