/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: TopiaStereoTypes.java 2300 2011-06-20 16:59:45Z bleny $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.6/topia-persistence/src/main/java/org/nuiton/topia/generator/TopiaStereoTypes.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topia.generator;

import org.nuiton.eugene.EugeneStereoTypes;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;

import static org.nuiton.eugene.ModelPropertiesUtil.StereotypeDefinition;

/**
 * All extra stereotypes usable in topia generators.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.5
 */
public interface TopiaStereoTypes extends EugeneStereoTypes {

    /**
     * Stéréotype pour les attributs considérés comme des tableaux.
     *
     * @see TopiaGeneratorUtil#hasArrayStereotype(ObjectModelAttribute)
     * @deprecated since 2.5 : only BeanTransformer use it and it is a deprecated transformer, will be remove in version 3.0
     */
    @Deprecated
    @StereotypeDefinition(target = ObjectModelAttribute.class,
                          documentation = "Deprecated! To specify that an attribute is an array")
    String STEREOTYPE_ARRAY = "array";

    /**
     * Stéréotype pour les interfaces devant être générées sous forme de facades.
     *
     * @deprecated since 2.5 : nobydy use it, will be remove in version 3.0
     */
    @Deprecated
    String STEREOTYPE_FACADE = "facade";

    /**
     * Stéréotype pour les objets devant être générées sous forme d'entités
     *
     * @see TopiaGeneratorUtil#isEntity(ObjectModelClassifier)
     * @see TopiaGeneratorUtil#hasEntityStereotype(ObjectModelAttribute)
     */
    @StereotypeDefinition(target = {ObjectModelClassifier.class, ObjectModelAttribute.class},
                          documentation = "To specify that a class is an Entity")
    String STEREOTYPE_ENTITY = "entity";

    /**
     * Stéréotype pour les objets devant être générées sous forme de DTO.
     *
     * @see TopiaGeneratorUtil#hasDtoStereotype(ObjectModelClassifier)
     */
    @StereotypeDefinition(target = ObjectModelClassifier.class,
                          documentation = "to specify that a class is a DTO")
    String STEREOTYPE_DTO = "dto";

    /**
     * Stéréotype pour les interfaces devant être générées sous forme de
     * services.
     *
     * @see ServiceTransformer
     * @see TopiaGeneratorUtil#hasServiceStereotype(ObjectModelClassifier)
     */
    @StereotypeDefinition(target = ObjectModelClassifier.class,
                          documentation = "To specify that a class is a Service")
    String STEREOTYPE_SERVICE = "service";

    /**
     * Stéréotype pour les interfaces devant être générées sous forme de DAO.
     *
     * @see TopiaGeneratorUtil#hasDaoStereotype(ObjectModelClassifier)
     * @see TopiaGeneratorUtil#hasDaoStereotype(ObjectModelOperation)
     */
    @StereotypeDefinition(target = {ObjectModelClassifier.class, ObjectModelOperation.class},
                          documentation = "To Specify that a classifier or an operation should be generated as (or in) a DAO")
    String STEREOTYPE_DAO = "dao";

    /**
     * Stéréotype pour les collections avec unicité.
     *
     * @see TopiaGeneratorUtil#hasUniqueStereotype(ObjectModelAttribute)
     */
    @StereotypeDefinition(target = ObjectModelAttribute.class,
                          documentation = "To specify that an attribute is unique (Hibernate mapping)")
    String STEREOTYPE_UNIQUE = "unique";

    /**
     * Stéréotype pour les attributs étant des clés primaires.
     *
     * @see TopiaGeneratorUtil#hasPrimaryKeyStereotype(ObjectModelAttribute)
     */
    @StereotypeDefinition(target = ObjectModelAttribute.class,
                          documentation = "To specify that an attribute is part of a primary key (Hibernate mapping)")
    String STEREOTYPE_PRIMARYKAY = "primaryKey";
}
