/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.validator.ObjectModelValidator;
import org.nuiton.topia.generator.TopiaGeneratorUtil;

public class TopiaJavaValidator
extends ObjectModelValidator {
    public TopiaJavaValidator(ObjectModel model) {
        super(model);
    }

    protected boolean validateAttribute(ObjectModelAttribute attr) {
        boolean isValid = super.validateAttribute(attr);
        if (attr.getType() == null || attr.getType().isEmpty()) {
            isValid = false;
            this.addError(attr, "Invalid type \"" + attr.getType() + "\"");
        }
        if (!TopiaJavaValidator.isJavaIdentifier(attr.getName())) {
            isValid = false;
            this.addError(attr, "Attribute name " + attr.getName() + " is not valid java identifier");
        }
        return isValid;
    }

    protected boolean validateClass(ObjectModelClass clazz) {
        boolean isValid = super.validateClass(clazz);
        HashSet<String> attributesName = new HashSet<String>();
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            String attrName;
            if (!attr.isNavigable() || attributesName.add(attrName = attr.getName())) continue;
            this.addError(attr, "Attribute name " + attrName + " already exists");
            isValid = false;
        }
        if (TopiaGeneratorUtil.isEntity((ObjectModelClassifier)clazz)) {
            HashSet<String> methodsName = new HashSet<String>();
            for (ObjectModelAttribute attr : clazz.getAttributes()) {
                String capitalizeAttrName = StringUtils.capitalize((String)attr.getName());
                methodsName.add("is" + capitalizeAttrName);
                methodsName.add("get" + capitalizeAttrName);
                methodsName.add("set" + capitalizeAttrName);
            }
            for (ObjectModelOperation operation : clazz.getOperations()) {
                String operationName = operation.getName();
                if (!methodsName.contains(operationName)) continue;
                this.addError(operation, "Operation name " + operationName + " is already reserved for a getter/setter of an entity attribute");
                isValid = false;
            }
        }
        return isValid;
    }

    protected boolean validateModel(ObjectModel model) {
        return super.validateModel(model);
    }

    public static boolean isJavaIdentifier(String s) {
        if (s.length() == 0 || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

