/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: EntityDTOTransformer.java 2300 2011-06-20 16:59:45Z bleny $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.6.3/topia-persistence/src/main/java/org/nuiton/topia/generator/EntityDTOTransformer.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.generator;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.*;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;






/**
 * Created: 14 déc. 2009
 *
 * @author tchemit <chemit@codelutin.com>
 * @version $Id: EntityDTOTransformer.java 2300 2011-06-20 16:59:45Z bleny $ 
 * @since 2.3.0
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.EntityDTOTransformer"
 */
public class EntityDTOTransformer extends ObjectModelTransformerToJava {

    public boolean isEntity(String type) {
        ObjectModelClassifier clazz = model.getClassifier(type);
        return clazz != null && ! clazz.isEnum()
               && TopiaGeneratorUtil.isEntity(clazz);
    }

    @Override
    public void transformFromClass(ObjectModelClass clazz) {
        if (!TopiaGeneratorUtil.isEntity(clazz)) {
            return;
        }
        String clazzName = clazz.getName();
        ObjectModelClass result;
        result = createClass(clazzName + "DTO", clazz.getPackageName());
        addImport(result, ToStringBuilder.class);
        addImport(result, PropertyChangeListener.class);

        setDocumentation(result, "Implantation DTO pour l'entité " + StringUtils.capitalize(clazzName) + ".");
        String extendClass = "";
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            extendClass = parent.getQualifiedName() + "DTO";
            // no multi-inheritance in java
            break;
        }
        if (extendClass.length() > 0) {
            setSuperClass(result, extendClass);
        }
        addInterface(result, Serializable.class);


        addAttributes(result,clazz);
        
        addOperations(result,clazz);

    }

    protected void addAttributes(ObjectModelClass result, ObjectModelClass clazz) {

        String svUID = TopiaGeneratorUtil.findTagValue("dto-serialVersionUID", clazz, model);
        if (svUID != null) {
            addAttribute(result, "serialVersionUID", "long", svUID, ObjectModelModifier.FINAL, ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC);
        }

        ObjectModelAttribute attr2;
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();

            // pour les asso quoi qu'il arrive il faut les lier des 2 cotes
            // pour pouvoir supprimer en cascade l'asso lors de la suppression
            // d'un des cotes
            if (!(attr.isNavigable()
                    || hasUnidirectionalRelationOnAbstractType(reverse, model)
                    || attr.hasAssociationClass())) {
                continue;
            }

            String attrVisibility = attr.getVisibility();
            ObjectModelModifier modifier = ObjectModelModifier.toValue(attrVisibility);
            if (!attr.hasAssociationClass()) {
                String attrType = attr.getType();
                String attrName = attr.getName();
                if (isEntity(attrType)) {
                    attrType += "DTO";
                }
                if (!GeneratorUtil.isNMultiplicity(attr)) {
                    attr2 = addAttribute(result, attrName, attrType, null, modifier);
                } else {
                    attr2 = addAttribute(result, attrName, attrType + "[]", null, modifier);
                }
            } else {
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                if (!GeneratorUtil.isNMultiplicity(attr)) {
                    attr2 = addAttribute(result, GeneratorUtil.toLowerCaseFirstLetter(assocAttrName), assocClassFQN + "DTO", null, modifier);
                } else {
                    attr2 = addAttribute(result, GeneratorUtil.toLowerCaseFirstLetter(assocAttrName), assocClassFQN + "DTO[]", null, modifier);
                }
            }
            if (attr2 != null) {
                if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                    setDocumentation(attr2, attr.getDocumentation());
                }

                String annotation = TopiaGeneratorUtil.getAnnotationTagValue(attr);
                if (!StringUtils.isEmpty(annotation)) {
                    addAnnotation(result, attr2, annotation);
                }
            }
        }

        //Déclaration des attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass) clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr != null) {
                    String attrVisibility = attr.getVisibility();
                    ObjectModelModifier modifier = ObjectModelModifier.toValue(attrVisibility);
                    String attrType = attr.getType();
                    String attrName = attr.getName();
                    if (isEntity(attrType)) {
                        attrType += "DTO";
                    }
                    addAttribute(result, GeneratorUtil.toLowerCaseFirstLetter(attrName), attrType, null, modifier);
                }
            }
        }

        addAttribute(result,"p", PropertyChangeSupport.class,"new PropertyChangeSupport(this)",ObjectModelModifier.PROTECTED,ObjectModelModifier.FINAL);
    }

    protected void addOperations(ObjectModelClass result,ObjectModelClass clazz) {

        ObjectModelOperation op;
        op = addOperation(result, "addPropertyChangeListener", "void");
        addParameter(op,PropertyChangeListener.class,"listener");
        setOperationBody(op,""
+"\n"
+"        p.addPropertyChangeListener(listener);\n"
+"    "
        );

        op = addOperation(result, "addPropertyChangeListener", "void");
        addParameter(op, String.class, "propertyName");
        addParameter(op, PropertyChangeListener.class, "listener");
        setOperationBody(op, ""
+"\n"
+"        p.addPropertyChangeListener(propertyName, listener);\n"
+"    "
        );

        op = addOperation(result, "removePropertyChangeListener", "void");
        addParameter(op, PropertyChangeListener.class, "listener");
        setOperationBody(op, ""
+"\n"
+"        p.removePropertyChangeListener(listener);\n"
+"    "
        );

        op = addOperation(result, "removePropertyChangeListener", "void");
        addParameter(op, String.class, "propertyName");
        addParameter(op, PropertyChangeListener.class, "listener");
        setOperationBody(op, ""
+"\n"
+"        p.removePropertyChangeListener(propertyName, listener);\n"
+"    "
        );

        for (ObjectModelAttribute attr : clazz.getAttributes()) {

            ObjectModelAttribute reverse = attr.getReverseAttribute();

            if (!(attr.isNavigable() || hasUnidirectionalRelationOnAbstractType(reverse, model))) {
                continue;
            }

            String attrName = attr.getName();

            if (!attr.hasAssociationClass()) {
                String attrType = attr.getType();
                if (isEntity(attrType)) {
                    attrType += "DTO";
                }
                String capitalizedAttrName = StringUtils.capitalize(attrName);
                if (!GeneratorUtil.isNMultiplicity(attr)) {
                    op = addOperation(result, "set" + capitalizedAttrName, "void", ObjectModelModifier.PUBLIC);
                    addParameter(op, attrType, "value");
                    setOperationBody(op, ""
+"\n"
+"        "+attrType+" oldValue = this."+attrName+";\n"
+"        this."+attrName+" = value;\n"
+"        p.firePropertyChange(\""+attrName+"\", oldValue, value);\n"
+"    "
                    );

                    op = addOperation(result, "get" + capitalizedAttrName, attrType, ObjectModelModifier.PUBLIC);
                    setOperationBody(op, ""
+"\n"
+"        return "+attrName+";\n"
+"    "
                    );

                       } else {

                    op = addOperation(result, "set" + capitalizedAttrName, "void", ObjectModelModifier.PUBLIC);
                    addParameter(op, attrType+"[]", "values");
                    setOperationBody(op, ""
+"\n"
+"        "+attrType+"[] oldValues = this."+attrName+";\n"
+"        this."+attrName+" = values;\n"
+"        p.firePropertyChange(\""+attrName+"\", oldValues, values);\n"
+"    "
                    );

                    op = addOperation(result, "get" + capitalizedAttrName, attrType+"[]", ObjectModelModifier.PUBLIC);
                    setOperationBody(op, ""
+"\n"
+"        return "+attrName+";\n"
+"    "
                    );
                }
            } else {
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                String propertyName = GeneratorUtil.toLowerCaseFirstLetter(assocAttrName);
                String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                String capitaliedAttrName = StringUtils.capitalize(assocAttrName);
                if (!GeneratorUtil.isNMultiplicity(attr)) {
                    op = addOperation(result, "set" + capitaliedAttrName, "void", ObjectModelModifier.PUBLIC);
                    addParameter(op, assocClassFQN + "DTO", "association");
                    setOperationBody(op, ""
+"\n"
+"        "+assocClassFQN+"DTO oldAssocation= this."+propertyName+";\n"
+"        this."+propertyName+" = association;\n"
+"        p.firePropertyChange(\""+attrName+"\", oldAssocation, assocation);\n"
+"    "
                    );

                    op = addOperation(result, "get" + capitaliedAttrName, assocClassFQN + "DTO", ObjectModelModifier.PUBLIC);
                    setOperationBody(op, ""
+"\n"
+"        return "+propertyName+";\n"
+"    "
                    );

                } else {
                    op = addOperation(result, "set" + capitaliedAttrName, "void", ObjectModelModifier.PUBLIC);
                    addParameter(op, assocClassFQN + "DTO[]", "values");
                    setOperationBody(op, ""
+"\n"
+"        "+assocClassFQN+"DTO[] oldValues = this."+propertyName+";\n"
+"        this."+propertyName+" = values;\n"
+"        p.firePropertyChange(\""+attrName+"\", oldValues, values);\n"
+"    "
                    );

                    op = addOperation(result, "get" + capitaliedAttrName, assocClassFQN + "DTO[]", ObjectModelModifier.PUBLIC);
                    setOperationBody(op, ""
+"\n"
+"        return this."+propertyName+";\n"
+"    "
                    );
                }
            }
        }

        op = addOperation(result,"toString",String.class, ObjectModelModifier.PUBLIC);
        StringBuilder buffer = new StringBuilder();

        buffer.append(""
+"\n"
+"        String result = new ToStringBuilder(this).\n"
+""
                );

        for (Object o : clazz.getAttributes()) {
            ObjectModelAttribute attr = (ObjectModelAttribute) o;
            //FIXME possibilité de boucles (non directes)
            ObjectModelClass attrEntity = null;
            if (model.hasClass(attr.getType())) {
                attrEntity = model.getClass(attr.getType());
            }
            boolean isEntity = attrEntity != null && TopiaGeneratorUtil.isEntity(attrEntity);
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (isEntity && (reverse == null || !reverse.isNavigable()) && !attr.hasAssociationClass() || !isEntity) {
            	String attrName = attr.getName();
                buffer.append(""
+"            append(\""+attrName+"\", this."+attrName+").\n"
+""
                );
            }
        }
        buffer.append(""
+"         toString();\n"
+"        return result;\n"
+""
        );
        setOperationBody(op, buffer.toString());
    }
}
