package org.nuiton.topiatest.beangen;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Collection;
import org.nuiton.i18n.I18n;
import org.nuiton.topiatest.Personne;

public  abstract class Voiture implements Vehicule, Serializable {

    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_IMMATRICULATION = "immatriculation";
    public static final String PROPERTY_MODELE = "modele";
    public static final String PROPERTY_PROPRIETAIRE = "proprietaire";
    public static final String PROPERTY_ROUE = "roue";
    public static final String PROPERTY_SIEGE = "siege";
    protected int immatriculation;
    protected String modele;
    protected Personne proprietaire;
    protected Collection<Roue> roue;
    protected Collection<Siege> siege;
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);;

static {
    
        I18n.n_("topia.test.common.voiture");
        I18n.n_("topia.test.common.immatriculation");
        I18n.n_("topia.test.common.modele");
        I18n.n_("topia.test.common.proprietaire");
        I18n.n_("topia.test.common.roue");
        I18n.n_("topia.test.common.siege");
    }
     /**
      * getImmatriculation :
      * @return int 
      */
    public int getImmatriculation() {
        return immatriculation;
    }

     /**
      * setImmatriculation :
      * @param immatriculation 
      */
    public void setImmatriculation(int immatriculation) {
        int oldValue = getImmatriculation();
        this.immatriculation = immatriculation;
        firePropertyChange(PROPERTY_IMMATRICULATION, oldValue, immatriculation);
    }

     /**
      * getModele :
      * @return String 
      */
    public String getModele() {
        return modele;
    }

     /**
      * setModele :
      * @param modele 
      */
    public void setModele(String modele) {
        String oldValue = getModele();
        this.modele = modele;
        firePropertyChange(PROPERTY_MODELE, oldValue, modele);
    }

     /**
      * getProprietaire :
      * @return Personne 
      */
    public Personne getProprietaire() {
        return proprietaire;
    }

     /**
      * setProprietaire :
      * @param proprietaire 
      */
    public void setProprietaire(Personne proprietaire) {
        Personne oldValue = getProprietaire();
        this.proprietaire = proprietaire;
        firePropertyChange(PROPERTY_PROPRIETAIRE, oldValue, proprietaire);
    }

     /**
      * getRoue :
      * @param index 
      * @return Roue 
      */
    public Roue getRoue(int index) {
        Roue o = getChild(roue, index);
        return o;
    }

     /**
      * addRoue :
      * @param roue 
      */
    public void addRoue(Roue roue) {
        getRoue().add(roue);
    
        firePropertyChange(PROPERTY_ROUE, null, roue);
    }

     /**
      * addAllRoue :
      * @param roue 
      */
    public void addAllRoue(Collection<Roue> roue) {
        getRoue().addAll(roue);
    
        firePropertyChange(PROPERTY_ROUE, null, roue);
    }

     /**
      * removeRoue :
      * @param roue 
      * @return boolean 
      */
    public boolean removeRoue(Roue roue) {
        boolean  removed = getRoue().remove(roue);
    
        if (removed) {
            firePropertyChange(PROPERTY_ROUE, roue, null);
      }
    
        return removed;
    }

     /**
      * removeAllRoue :
      * @param roue 
      * @return boolean 
      */
    public boolean removeAllRoue(Collection<Roue> roue) {
        boolean  removed = getRoue().removeAll(roue);
    
        if (removed) {
            firePropertyChange(PROPERTY_ROUE, roue, null);
      }
    
        return removed;
    }

     /**
      * containsRoue :
      * @param roue 
      * @return boolean 
      */
    public boolean containsRoue(Roue roue) {
        boolean contains = getRoue().contains(roue);
    
        return contains;
    }

     /**
      * containsAllRoue :
      * @param roue 
      * @return boolean 
      */
    public boolean containsAllRoue(Collection<Roue> roue) {
        boolean  contains = getRoue().containsAll(roue);
    
        return contains;
    }

     /**
      * getRoue :
      * @return Collection<Roue> 
      */
    public Collection<Roue> getRoue() {
        return roue;
    }

     /**
      * setRoue :
      * @param roue 
      */
    public void setRoue(Collection<Roue> roue) {
        Collection<Roue> oldValue = getRoue();
        this.roue = roue;
        firePropertyChange(PROPERTY_ROUE, oldValue, roue);
    }

     /**
      * getSiege :
      * @param index 
      * @return Siege 
      */
    public Siege getSiege(int index) {
        Siege o = getChild(siege, index);
        return o;
    }

     /**
      * addSiege :
      * @param siege 
      */
    public void addSiege(Siege siege) {
        getSiege().add(siege);
    
        firePropertyChange(PROPERTY_SIEGE, null, siege);
    }

     /**
      * addAllSiege :
      * @param siege 
      */
    public void addAllSiege(Collection<Siege> siege) {
        getSiege().addAll(siege);
    
        firePropertyChange(PROPERTY_SIEGE, null, siege);
    }

     /**
      * removeSiege :
      * @param siege 
      * @return boolean 
      */
    public boolean removeSiege(Siege siege) {
        boolean  removed = getSiege().remove(siege);
    
        if (removed) {
            firePropertyChange(PROPERTY_SIEGE, siege, null);
      }
    
        return removed;
    }

     /**
      * removeAllSiege :
      * @param siege 
      * @return boolean 
      */
    public boolean removeAllSiege(Collection<Siege> siege) {
        boolean  removed = getSiege().removeAll(siege);
    
        if (removed) {
            firePropertyChange(PROPERTY_SIEGE, siege, null);
      }
    
        return removed;
    }

     /**
      * containsSiege :
      * @param siege 
      * @return boolean 
      */
    public boolean containsSiege(Siege siege) {
        boolean contains = getSiege().contains(siege);
    
        return contains;
    }

     /**
      * containsAllSiege :
      * @param siege 
      * @return boolean 
      */
    public boolean containsAllSiege(Collection<Siege> siege) {
        boolean  contains = getSiege().containsAll(siege);
    
        return contains;
    }

     /**
      * getSiege :
      * @return Collection<Siege> 
      */
    public Collection<Siege> getSiege() {
        return siege;
    }

     /**
      * setSiege :
      * @param siege 
      */
    public void setSiege(Collection<Siege> siege) {
        Collection<Siege> oldValue = getSiege();
        this.siege = siege;
        firePropertyChange(PROPERTY_SIEGE, oldValue, siege);
    }

     /**
      * addPropertyChangeListener :
      * @param listener 
      */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

     /**
      * addPropertyChangeListener :
      * @param propertyName 
      * @param listener 
      */
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

     /**
      * removePropertyChangeListener :
      * @param listener 
      */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

     /**
      * removePropertyChangeListener :
      * @param propertyName 
      * @param listener 
      */
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

     /**
      * firePropertyChange :
      * @param propertyName 
      * @param oldValue 
      * @param newValue 
      */
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

     /**
      * firePropertyChange :
      * @param propertyName 
      * @param newValue 
      */
    protected void firePropertyChange(String propertyName, Object newValue) {
        firePropertyChange(propertyName, null, newValue);
    }

     /**
      * getChild :
      * @param childs 
      * @param index 
      * @return <T> T 
      */
    protected <T> T getChild(Collection<T> childs, int index) {
        if (childs != null) {
            int i = 0;
            for (T o : childs) {
                if (index == i) {
                    return o;
                }
                i++;
            }
        }
        return null;
    }


} //Voiture
