package org.nuiton.topiatest;

import java.util.Collection;
import org.nuiton.topia.persistence.TopiaEntity;

public interface Company extends TopiaEntity {

     String PROPERTY_NAME = "name";
     String PROPERTY_SIRET = "siret";
     String PROPERTY_EMPLOYE = "employe";
     String PROPERTY_STORE_BILL = "storeBill";
     String PROPERTY_DEPARTMENT = "department";

     /**
      * setName :
      * @param name La valeur de l'attribut à positionner.
      */
     void setName(String name);

     /**
      * getName :
      * @return String 
      */
     String getName();

     /**
      * setSiret :
      * @param siret La valeur de l'attribut à positionner.
      */
     void setSiret(int siret);

     /**
      * getSiret :
      * @return int 
      */
     int getSiret();

     /**
      * addEmploye :
      * @param employe L'instance de org.nuiton.topiatest.Employe à ajouter
      */
     void addEmploye(Employe employe);

     /**
      * addAllEmploye :
      * @param employe Les instances de org.nuiton.topiatest.Employe à ajouter
      */
     void addAllEmploye(Collection<Employe> employe);

     /**
      * setEmploye :
      * @param employe La valeur de l'attribut à positionner.
      */
     void setEmploye(Collection<Employe> employe);

     /**
      * removeEmploye :
      * @param employe L'instance de org.nuiton.topiatest.Employe à retirer
      */
     void removeEmploye(Employe employe);

     /**
      * clearEmploye :
      */
     void clearEmploye();

     /**
      * getEmploye :
      * Retourne la collection.
      * @return Collection<Employe> 
      */
     Collection<Employe> getEmploye();

     /**
      * getEmployeByTopiaId :
      * Recupère l'attribut employe à partir de son topiaId
      * @param topiaId le topia id de l'entité recherchée
      * @return Employe 
      */
     Employe getEmployeByTopiaId(String topiaId);

     /**
      * sizeEmploye :
      * Retourne le nombre d'éléments de la collection employe
      * @return int 
      */
     int sizeEmploye();

     /**
      * isEmployeEmpty :
      * Retourne {@code true} si la collection employe est vide.
      * @return boolean 
      */
     boolean isEmployeEmpty();

     /**
      * addStoreBill :
      * @param storeBill L'instance de org.nuiton.topiatest.Bill à ajouter
      */
     void addStoreBill(Bill storeBill);

     /**
      * addAllStoreBill :
      * @param storeBill Les instances de org.nuiton.topiatest.Bill à ajouter
      */
     void addAllStoreBill(Collection<Bill> storeBill);

     /**
      * setStoreBill :
      * @param storeBill La valeur de l'attribut à positionner.
      */
     void setStoreBill(Collection<Bill> storeBill);

     /**
      * removeStoreBill :
      * @param storeBill L'instance de org.nuiton.topiatest.Bill à retirer
      */
     void removeStoreBill(Bill storeBill);

     /**
      * clearStoreBill :
      */
     void clearStoreBill();

     /**
      * getStoreBill :
      * Retourne la collection.
      * @return Collection<Bill> 
      */
     Collection<Bill> getStoreBill();

     /**
      * getStoreBillByTopiaId :
      * Recupère l'attribut storeBill à partir de son topiaId
      * @param topiaId le topia id de l'entité recherchée
      * @return Bill 
      */
     Bill getStoreBillByTopiaId(String topiaId);

     /**
      * getStoreBill :
      * @param store 
      * @return Bill 
      */
     Bill getStoreBill(Store store);

     /**
      * sizeStoreBill :
      * Retourne le nombre d'éléments de la collection storeBill
      * @return int 
      */
     int sizeStoreBill();

     /**
      * isStoreBillEmpty :
      * Retourne {@code true} si la collection storeBill est vide.
      * @return boolean 
      */
     boolean isStoreBillEmpty();

     /**
      * addDepartment :
      * @param department L'instance de org.nuiton.topiatest.Department à ajouter
      */
     void addDepartment(Department department);

     /**
      * addAllDepartment :
      * @param department Les instances de org.nuiton.topiatest.Department à ajouter
      */
     void addAllDepartment(Collection<Department> department);

     /**
      * setDepartment :
      * @param department La valeur de l'attribut à positionner.
      */
     void setDepartment(Collection<Department> department);

     /**
      * removeDepartment :
      * @param department L'instance de org.nuiton.topiatest.Department à retirer
      */
     void removeDepartment(Department department);

     /**
      * clearDepartment :
      */
     void clearDepartment();

     /**
      * getDepartment :
      * Retourne la collection.
      * @return Collection<Department> 
      */
     Collection<Department> getDepartment();

     /**
      * getDepartmentByTopiaId :
      * Recupère l'attribut department à partir de son topiaId
      * @param topiaId le topia id de l'entité recherchée
      * @return Department 
      */
     Department getDepartmentByTopiaId(String topiaId);

     /**
      * sizeDepartment :
      * Retourne le nombre d'éléments de la collection department
      * @return int 
      */
     int sizeDepartment();

     /**
      * isDepartmentEmpty :
      * Retourne {@code true} si la collection department est vide.
      * @return boolean 
      */
     boolean isDepartmentEmpty();


} //Company
