/*
 * #%L
 * ToPIA :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper.TopiaTestEntityEnum;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class GeneralizedNaturalizedEntityDAOAbstract<E extends GeneralizedNaturalizedEntity> extends NaturalizedEntityDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)GeneralizedNaturalizedEntity.class;
    }

    @Override
    public TopiaTestEntityEnum getTopiaEntityEnum() {
        return TopiaTestEntityEnum.GeneralizedNaturalizedEntity;
    }

    public E findByNaturalId(Integer naturalIdNotNull, String naturalIdNull) throws TopiaException {
        return findByProperties(GeneralizedNaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull, GeneralizedNaturalizedEntity.PROPERTY_NATURAL_ID_NULL, naturalIdNull);
    }

    public boolean existByNaturalId(Integer naturalIdNotNull, String naturalIdNull) throws TopiaException {
        return existByProperties(GeneralizedNaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull, GeneralizedNaturalizedEntity.PROPERTY_NATURAL_ID_NULL, naturalIdNull);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param naturalIdNotNull 
     * @param naturalIdNull 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(Integer naturalIdNotNull, String naturalIdNull) throws TopiaException {
        return create(GeneralizedNaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull, GeneralizedNaturalizedEntity.PROPERTY_NATURAL_ID_NULL, naturalIdNull);
    }

    public E createByNaturalId(Integer naturalIdNotNull, String naturalIdNull) throws TopiaException {
        return create(GeneralizedNaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull, GeneralizedNaturalizedEntity.PROPERTY_NATURAL_ID_NULL, naturalIdNull);
    }

    public E createByNotNull(Integer naturalIdNotNull) throws TopiaException {
        return create(GeneralizedNaturalizedEntity.PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull);
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //GeneralizedNaturalizedEntityDAOAbstract<E extends GeneralizedNaturalizedEntity>
