/*
 * #%L
 * ToPIA :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2004 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topia.test.ano1882;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class FrenchCompanyDTO implements Serializable {

    protected String topiaId;

    public SIRENDTO sIREN;

    public SIRETDTO[] sIRET;

    public SIRENDTO SIREN2;

    public SIRETDTO[] SIRET2;

    protected final PropertyChangeSupport p = new PropertyChangeSupport(this);

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }

    public void setsIREN(SIRENDTO value) {
        org.nuiton.topia.test.ano1882.SIRENDTO oldValue = this.sIREN;
        this.sIREN = value;
        p.firePropertyChange("sIREN", oldValue, value);
    }

    public SIRENDTO getsIREN() {
        return sIREN;
    }

    public void setsIRET(SIRETDTO[] values) {
        org.nuiton.topia.test.ano1882.SIRETDTO[] oldValues = this.sIRET;
        this.sIRET = values;
        p.firePropertyChange("sIRET", oldValues, values);
    }

    public SIRETDTO[] getsIRET() {
        return sIRET;
    }

    public void setSIREN2(SIRENDTO value) {
        org.nuiton.topia.test.ano1882.SIRENDTO oldValue = this.SIREN2;
        this.SIREN2 = value;
        p.firePropertyChange("SIREN2", oldValue, value);
    }

    public SIRENDTO getSIREN2() {
        return SIREN2;
    }

    public void setSIRET2(SIRETDTO[] values) {
        org.nuiton.topia.test.ano1882.SIRETDTO[] oldValues = this.SIRET2;
        this.SIRET2 = values;
        p.firePropertyChange("SIRET2", oldValues, values);
    }

    public SIRETDTO[] getSIRET2() {
        return SIRET2;
    }

    public String toString() {
        String result = new ToStringBuilder(this).
            append("sIREN", this.sIREN).
            append("sIRET", this.sIRET).
            append("SIREN2", this.SIREN2).
            append("SIRET2", this.SIRET2).
         toString();
        return result;
}

} //FrenchCompanyDTO
