package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public  abstract class NaturalizedEntityAbstract extends TopiaEntityAbstract implements NaturalizedEntity {

    /**
     * Nom de l'attribut en BD : naturalIdNotNull

     */
    protected Integer naturalIdNotNull;
    /**
     * Nom de l'attribut en BD : naturalIdNull

     */
    protected String naturalIdNull;
static {
    
        I18n.n_("topia.test.common.naturalizedEntity");
        I18n.n_("topia.test.common.naturalIdNotNull");
        I18n.n_("topia.test.common.naturalIdNull");
    }
    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NATURAL_ID_NOT_NULL, Integer.class, naturalIdNotNull);
        visitor.visit(this, PROPERTY_NATURAL_ID_NULL, String.class, naturalIdNull);
        visitor.end(this);
}

    /**
     * setNaturalIdNotNull :
     * @param naturalIdNotNull 
     */

    @Override
    public void setNaturalIdNotNull(Integer naturalIdNotNull) {
        Integer oldValue = this.naturalIdNotNull;
        fireOnPreWrite(PROPERTY_NATURAL_ID_NOT_NULL, oldValue, naturalIdNotNull);
        this.naturalIdNotNull = naturalIdNotNull;
        fireOnPostWrite(PROPERTY_NATURAL_ID_NOT_NULL, oldValue, naturalIdNotNull);
}

    /**
     * getNaturalIdNotNull :
     * @return Integer 
     */

    @Override
    public Integer getNaturalIdNotNull() {
        fireOnPreRead(PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull);
        Integer result = this.naturalIdNotNull;
        fireOnPostRead(PROPERTY_NATURAL_ID_NOT_NULL, naturalIdNotNull);
        return result;
}

    /**
     * setNaturalIdNull :
     * @param naturalIdNull 
     */

    @Override
    public void setNaturalIdNull(String naturalIdNull) {
        String oldValue = this.naturalIdNull;
        fireOnPreWrite(PROPERTY_NATURAL_ID_NULL, oldValue, naturalIdNull);
        this.naturalIdNull = naturalIdNull;
        fireOnPostWrite(PROPERTY_NATURAL_ID_NULL, oldValue, naturalIdNull);
}

    /**
     * getNaturalIdNull :
     * @return String 
     */

    @Override
    public String getNaturalIdNull() {
        fireOnPreRead(PROPERTY_NATURAL_ID_NULL, naturalIdNull);
        String result = this.naturalIdNull;
        fireOnPostRead(PROPERTY_NATURAL_ID_NULL, naturalIdNull);
        return result;
}

    /**
     * getAggregate :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NATURAL_ID_NOT_NULL, this.naturalIdNotNull).
            append(PROPERTY_NATURAL_ID_NULL, this.naturalIdNull).
         toString();
        return result;
}


} //NaturalizedEntityAbstract
