/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.generator.TopiaGeneratorUtil;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public class EntityTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(EntityTransformer.class);
    protected ObjectModelInterface outputInterface;
    protected ObjectModelClass outputAbstract;
    protected ObjectModelClass outputImpl;
    private boolean associationClass;
    private ObjectModelOperation acceptOperation;
    private StringBuilder acceptOperationBody;

    protected void clean() {
        this.outputInterface = null;
        this.outputAbstract = null;
        this.outputImpl = null;
    }

    public void transformFromClass(ObjectModelClass input) {
        boolean generateImpl;
        String prefix;
        if (!TopiaGeneratorUtil.hasEntityStereotype((ObjectModelClassifier)input)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("for entity : " + input.getQualifiedName()));
            log.info((Object)("Will use classLoader " + this.getClassLoader()));
        }
        if (StringUtils.isEmpty((String)(prefix = this.getConstantPrefix((ObjectModelClassifier)input, ""))) && log.isWarnEnabled()) {
            log.warn((Object)("[" + input.getName() + "] Will generate constants with NO prefix, not a good idea... \n" + "Use '" + "constantPrefix" + "' tagvalue in your xmi properties. For example " + "for all the model : model.tagvalue." + "constantPrefix" + "=PROPERTY_"));
        }
        this.setConstantPrefix(prefix);
        this.createEntityInterface(input);
        this.createEntityAbstractClass(input);
        String i18nPrefix = JavaGeneratorUtil.getI18nPrefixTagValue((ObjectModelElement)input, (ObjectModel)((ObjectModel)this.model));
        if (!StringUtils.isEmpty((String)i18nPrefix)) {
            this.generateI18nBlock((ObjectModelClassifier)input, (ObjectModelClassifier)this.outputAbstract, i18nPrefix);
        }
        this.createAcceptOperation();
        this.generateProperties(input.getAttributes());
        if (input instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass association = (ObjectModelAssociationClass)input;
            this.associationClass = true;
            this.generateProperties(association.getParticipantsAttributes());
            this.associationClass = false;
        }
        this.closeAcceptOperation();
        this.generateExtraConstants(input);
        this.generateExtraOperations(input);
        this.generateAggregateOperation(input);
        this.generateCompositeOperation(input);
        if (TopiaGeneratorUtil.generateToString(input, (ObjectModel)this.model)) {
            this.generateToStringOperation(input);
        }
        if (generateImpl = this.isGenerateImpl(input, input.getOperations())) {
            this.generateImpl(input);
        }
        this.clean();
    }

    protected void createEntityInterface(ObjectModelClass input) {
        this.outputInterface = this.createInterface(input.getName(), input.getPackageName());
        if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)input)) {
            this.setDocumentation((ObjectModelElement)this.outputInterface, input.getDocumentation());
        }
        for (ObjectModelInterface parent : input.getInterfaces()) {
            this.addInterface((ObjectModelClassifier)this.outputInterface, parent.getQualifiedName());
        }
        boolean needTopiaEntity = true;
        for (ObjectModelClass parent : input.getSuperclasses()) {
            if (!TopiaGeneratorUtil.hasEntityStereotype((ObjectModelClassifier)parent)) continue;
            this.addInterface((ObjectModelClassifier)this.outputInterface, parent.getQualifiedName());
            needTopiaEntity = false;
            break;
        }
        if (needTopiaEntity) {
            if (TopiaGeneratorUtil.isContextable((ObjectModelClassifier)input)) {
                this.addInterface((ObjectModelClassifier)this.outputInterface, TopiaEntityContextable.class);
            } else {
                this.addInterface((ObjectModelClassifier)this.outputInterface, TopiaEntity.class);
            }
        }
    }

    protected void createEntityAbstractClass(ObjectModelClass input) {
        String svUID;
        this.outputAbstract = this.createAbstractClass(input.getName() + "Abstract", input.getPackageName());
        StringBuilder doc = new StringBuilder();
        doc.append("Implantation POJO pour l'entit\u00e9 {@link ");
        doc.append(StringUtils.capitalize((String)this.outputInterface.getName()));
        doc.append("}\n");
        String dbName = TopiaGeneratorUtil.getDbName((ObjectModelElement)input);
        if (dbName != null) {
            doc.append("<p>Nom de l'entit\u00e9 en BD : ");
            doc.append(dbName);
            doc.append(".</p>");
        }
        this.setDocumentation((ObjectModelElement)this.outputAbstract, doc.toString());
        this.addInterface((ObjectModelClassifier)this.outputAbstract, this.outputInterface.getName());
        for (ObjectModelClass parent : input.getSuperclasses()) {
            String extendClass = parent.getQualifiedName();
            boolean abstractParent = TopiaGeneratorUtil.shouldBeAbstract(parent);
            if (TopiaGeneratorUtil.hasEntityStereotype((ObjectModelClassifier)parent)) {
                extendClass = abstractParent ? extendClass + "Abstract" : extendClass + "Impl";
            }
            this.setSuperClass(this.outputAbstract, extendClass);
        }
        if (this.outputAbstract.getSuperclasses().isEmpty()) {
            this.setSuperClass(this.outputAbstract, TopiaEntityAbstract.class);
        }
        if ((svUID = TopiaGeneratorUtil.findTagValue((String)"serialVersionUID", (ObjectModelElement)input, (Model)this.model)) != null) {
            this.addConstant((ObjectModelClassifier)this.outputInterface, "serialVersionUID", Long.TYPE, svUID, ObjectModelModifier.PRIVATE);
        }
        this.addContextableMethods(input, this.outputAbstract);
    }

    protected void addContextableMethods(ObjectModelClass input, ObjectModelClass outputAbstract) {
        if (TopiaGeneratorUtil.isContextable((ObjectModelClassifier)input)) {
            this.addImport((ObjectModelClassifier)outputAbstract, TopiaContextImplementor.class);
            ObjectModelOperation op = this.addOperation((ObjectModelClassifier)outputAbstract, "update", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
            this.addException(op, TopiaException.class);
            this.setDocumentation((ObjectModelElement)op, "@since 2.5.3");
            this.addAnnotation((ObjectModelClassifier)outputAbstract, (ObjectModelElement)op, Override.class.getSimpleName());
            this.setOperationBody(op, "\n        ((TopiaContextImplementor)getTopiaContext()).getDAO(" + input.getName() + ".class).update(this);\n" + "");
            op = this.addOperation((ObjectModelClassifier)outputAbstract, "delete", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
            this.addException(op, TopiaException.class);
            this.setDocumentation((ObjectModelElement)op, "@since 2.5.3");
            this.addAnnotation((ObjectModelClassifier)outputAbstract, (ObjectModelElement)op, Override.class.getSimpleName());
            this.setOperationBody(op, "\n        ((TopiaContextImplementor)getTopiaContext()).getDAO(" + input.getName() + ".class).delete(this);\n" + "");
        }
    }

    protected boolean isGenerateImpl(ObjectModelClass input, Collection<ObjectModelOperation> operations) {
        String fqn = input.getQualifiedName() + "Impl";
        URL fileLocation = this.getFileInClassPath(fqn);
        if (fileLocation != null) {
            if (this.isVerbose()) {
                log.info((Object)("Will not generate [" + fqn + "], already found in class-path at location : " + fileLocation));
            } else {
                log.info((Object)("Will not generate [" + fqn + "], already found in class-path."));
            }
            return false;
        }
        if (!operations.isEmpty()) {
            log.info((Object)("Will not generate [" + fqn + "], there is some operations to manually implement"));
            return false;
        }
        for (ObjectModelOperation otherOp : input.getAllOtherOperations(false)) {
            if (!otherOp.isAbstract()) continue;
            log.info((Object)("Will not generate [" + fqn + "], there is an abstract operation [" + otherOp.getName() + "] in allOtherOperations."));
            return false;
        }
        return true;
    }

    protected void generateImpl(ObjectModelClass input) {
        String implName = input.getName() + "Impl";
        String packageName = input.getPackageName();
        if (this.isVerbose()) {
            log.info((Object)("Will generate [" + implName + "]"));
        }
        this.outputImpl = this.isAbstract(input) ? this.createAbstractClass(implName, packageName) : this.createClass(implName, packageName);
        this.setDocumentation((ObjectModelElement)this.outputImpl, "Implantation des operations pour l'entit\u00e9 " + input.getName() + ".");
        this.setSuperClass(this.outputImpl, input.getQualifiedName() + "Abstract");
    }

    protected void generateExtraConstants(ObjectModelClass input) {
        Set constants = this.addConstantsFromDependency((ObjectModelClassifier)input, (ObjectModelClassifier)this.outputInterface);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add constants from dependency : " + constants));
        }
    }

    protected void generateExtraOperations(ObjectModelClass input) {
        for (ObjectModelOperation operation : input.getOperations()) {
            String opName = operation.getName();
            String opType = operation.getReturnType();
            ObjectModelModifier visibility = ObjectModelModifier.toValue((String)operation.getVisibility());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Extra operation for : " + input.getQualifiedName() + " - method : " + opName + " - returnType : " + opType + " - visibility : " + visibility));
            }
            if (TopiaGeneratorUtil.hasDaoStereotype(operation)) {
                return;
            }
            if (!visibility.equals((Object)ObjectModelModifier.PUBLIC)) {
                this.addOperation((ObjectModelClassifier)this.outputAbstract, opName, opType, new ObjectModelModifier[]{visibility, ObjectModelModifier.ABSTRACT});
                continue;
            }
            this.cloneOperationSignature(operation, (ObjectModelClassifier)this.outputInterface, true, new ObjectModelModifier[0]);
        }
    }

    protected void generateProperties(Collection<ObjectModelAttribute> attributes) {
        for (ObjectModelAttribute attribute : attributes) {
            if (!this.associationClass) {
                if (!attribute.isNavigable() && attribute.hasAssociationClass()) {
                    this.generatePropertyConstant(attribute);
                    this.generatePropertyAttribute(attribute);
                    this.updateAcceptOperation(attribute);
                }
                if (!attribute.isNavigable() && !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attribute.getReverseAttribute(), (ObjectModel)this.model)) continue;
            }
            this.generatePropertyConstant(attribute);
            this.generatePropertyAttribute(attribute);
            this.generatePropertyOperations(attribute);
            this.updateAcceptOperation(attribute);
        }
    }

    protected void generatePropertyConstant(ObjectModelAttribute attribute) {
        String attrName = this.getPropertyName(attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate constant for property : " + attrName));
        }
        this.addAttribute((ObjectModelClassifier)this.outputInterface, this.getConstantName(attrName), String.class, "\"" + attrName + "\"", new ObjectModelModifier[0]);
    }

    protected void generatePropertyAttribute(ObjectModelAttribute attribute) {
        String dbName;
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute);
        String collectionType = this.getCollectionType(attribute);
        if (collectionType != null) {
            attrType = collectionType + "<" + attrType + ">";
        }
        ObjectModelAttribute property = this.addAttribute((ObjectModelClassifier)this.outputAbstract, attrName, attrType, null, new ObjectModelModifier[]{ObjectModelModifier.PROTECTED});
        StringBuilder buffer = new StringBuilder();
        if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attribute)) {
            String attrDocumentation = attribute.getDocumentation();
            buffer.append(attrDocumentation).append('\n');
        }
        if (!StringUtils.isEmpty((String)(dbName = TopiaGeneratorUtil.getDbName((ObjectModelElement)attribute)))) {
            buffer.append("Nom de l'attribut en BD : ").append(dbName).append('\n');
        }
        this.setDocumentation((ObjectModelElement)property, buffer.toString());
        String annotation = TopiaGeneratorUtil.getAnnotationTagValue(attribute);
        if (!StringUtils.isEmpty((String)annotation)) {
            this.addAnnotation((ObjectModelClassifier)this.outputAbstract, (ObjectModelElement)property, annotation);
        }
    }

    protected void generatePropertyOperations(ObjectModelAttribute attribute) {
        if (attribute.getMaxMultiplicity() == 1 || this.associationClass) {
            this.addSingleSetOperation(attribute);
            this.addSingleGetOperation(attribute, null);
        } else {
            String collectionInterface = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attribute);
            String collectionImpl = TopiaGeneratorUtil.getNMultiplicityObjectType(attribute);
            this.addImport((ObjectModelClassifier)this.outputInterface, collectionInterface);
            this.addImport((ObjectModelClassifier)this.outputAbstract, collectionInterface);
            this.addImport((ObjectModelClassifier)this.outputAbstract, collectionImpl);
            collectionInterface = TopiaGeneratorUtil.getSimpleName((String)collectionInterface);
            collectionImpl = TopiaGeneratorUtil.getSimpleName((String)collectionImpl);
            this.addMultipleAddOperation(attribute, collectionImpl);
            this.addMultipleAddAllOperation(attribute, collectionInterface);
            this.addMultipleSetOperation(attribute, collectionInterface, collectionImpl);
            this.addMultipleRemoveOperation(attribute);
            this.addMultipleClearOperation(attribute, collectionInterface, collectionImpl);
            this.addMultipleGetOperation(attribute, collectionInterface);
            if (!TopiaGeneratorUtil.isPrimitiveType(attribute) && !TopiaGeneratorUtil.isDateType(attribute)) {
                this.addMultipleGetTopiaIdOperation(attribute);
            }
            if (attribute.hasAssociationClass()) {
                this.addMultipleGetOperationFromEntity(attribute);
            }
            this.addMultipleSizeOperation(attribute);
            this.addMultipleIsEmptyOperation(attribute);
        }
    }

    protected void addSingleSetOperation(ObjectModelAttribute attribute) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate single 'set' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.createPropertySetterSignature((ObjectModelClassifier)this.outputInterface, attrType, attrName, attribute.getDocumentation());
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = TopiaGeneratorUtil.getSimpleName((String)attrType);
        this.setOperationBody(implOperation, "\n        " + attrType + " oldValue = this." + attrName + ";\n" + "        fireOnPreWrite(" + this.getConstantName(attrName) + ", oldValue, " + attrName + ");\n" + "        this." + attrName + " = " + attrName + ";\n" + "        fireOnPostWrite(" + this.getConstantName(attrName) + ", oldValue, " + attrName + ");\n" + "");
    }

    protected void addSingleGetOperation(ObjectModelAttribute attribute, String operationPrefix) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute);
        if (operationPrefix == null) {
            operationPrefix = "get";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate single '" + operationPrefix + "' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, operationPrefix + StringUtils.capitalize((String)attrName), attrType, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attribute)) {
            this.setDocumentation((ObjectModelElement)interfaceOperation, attribute.getDocumentation());
        }
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = TopiaGeneratorUtil.getSimpleName((String)attrType);
        this.setOperationBody(implOperation, "\n        fireOnPreRead(" + this.getConstantName(attrName) + ", " + attrName + ");\n" + "        " + attrType + " result = this." + attrName + ";\n" + "        fireOnPostRead(" + this.getConstantName(attrName) + ", " + attrName + ");\n" + "        return result;\n" + "");
        if (attrType.toLowerCase().contains("boolean") && !operationPrefix.equals("is")) {
            this.addSingleGetOperation(attribute, "is");
        }
    }

    protected void addMultipleAddOperation(ObjectModelAttribute attribute, String collectionImpl) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute);
        ObjectModelAttribute reverse = attribute.getReverseAttribute();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'add' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, "add" + StringUtils.capitalize((String)attrName), Void.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        ObjectModelParameter param = this.addParameter(interfaceOperation, attrType, attrName);
        if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attribute)) {
            this.setDocumentation((ObjectModelElement)interfaceOperation, attribute.getDocumentation());
        }
        this.setDocumentation((ObjectModelElement)param, "L'instance de " + attrType + " \u00e0 ajouter");
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = TopiaGeneratorUtil.getSimpleName((String)attrType);
        StringBuilder body = new StringBuilder();
        body.append("\n        fireOnPreWrite(" + this.getConstantName(attrName) + ", null, " + attrName + ");\n" + "        if (this." + attrName + " == null) {\n" + "            this." + attrName + " = new " + collectionImpl + "<" + attrType + ">();\n" + "        }\n" + "");
        if (reverse != null && (reverse.isNavigable() || TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attribute, (ObjectModel)this.model))) {
            String reverseAttrName = StringUtils.capitalize((String)reverse.getName());
            String reverseAttrType = TopiaGeneratorUtil.getSimpleName((String)reverse.getType());
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                body.append("\n        " + attrName + ".set" + reverseAttrName + "(this);\n" + "");
            } else if (!attribute.hasAssociationClass()) {
                body.append("\n        if (" + attrName + ".get" + reverseAttrName + "() == null) {\n" + "            " + attrName + ".set" + reverseAttrName + "(new " + collectionImpl + "<" + reverseAttrType + ">());\n" + "        }\n" + "        " + attrName + ".get" + reverseAttrName + "().add(this);\n" + "");
            }
        }
        body.append("\n        this." + attrName + ".add(" + attrName + ");\n" + "        fireOnPostWrite(" + this.getConstantName(attrName) + ", this." + attrName + ".size(), null, " + attrName + ");\n" + "");
        this.setOperationBody(implOperation, body.toString());
    }

    protected void addMultipleAddAllOperation(ObjectModelAttribute attribute, String collectionInterface) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'addAll' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, "addAll" + StringUtils.capitalize((String)attrName), Void.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        ObjectModelParameter param = this.addParameter(interfaceOperation, collectionInterface + "<" + attrType + ">", attrName);
        if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attribute)) {
            this.setDocumentation((ObjectModelElement)interfaceOperation, attribute.getDocumentation());
        }
        this.setDocumentation((ObjectModelElement)param, "Les instances de " + attrType + " \u00e0 ajouter");
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = TopiaGeneratorUtil.getSimpleName((String)attrType);
        this.setOperationBody(implOperation, "\n        if (" + attrName + " == null) {\n" + "            return;\n" + "        }\n" + "        for (" + attrType + " item : " + attrName + ") {\n" + "            add" + StringUtils.capitalize((String)attrName) + "(item);\n" + "        }\n" + "");
    }

    protected void addMultipleSetOperation(ObjectModelAttribute attribute, String collectionInterface, String collectionImpl) {
        String attrName = this.getPropertyName(attribute);
        String referenceType = this.getPropertyType(attribute);
        String attrType = collectionInterface + "<" + referenceType + ">";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'set' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.createPropertySetterSignature((ObjectModelClassifier)this.outputInterface, attrType, attrName, attribute.getDocumentation());
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = TopiaGeneratorUtil.getSimpleName((String)attrType);
        referenceType = TopiaGeneratorUtil.getSimpleName((String)referenceType);
        this.setOperationBody(implOperation, "\n        // Copy elements to keep data for fire with new reference\n        " + attrType + " oldValue = this." + attrName + " != null ? new " + collectionImpl + "<" + referenceType + ">(this." + attrName + ") : null;\n" + "        fireOnPreWrite(" + this.getConstantName(attrName) + ", oldValue, " + attrName + ");\n" + "        this." + attrName + " = " + attrName + ";\n" + "        fireOnPostWrite(" + this.getConstantName(attrName) + ", oldValue, " + attrName + ");\n" + "");
    }

    protected void addMultipleRemoveOperation(ObjectModelAttribute attribute) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute);
        ObjectModelAttribute reverse = attribute.getReverseAttribute();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate 'remove' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, "remove" + StringUtils.capitalize((String)attrName), Void.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        ObjectModelParameter param = this.addParameter(interfaceOperation, attrType, attrName);
        if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attribute)) {
            this.setDocumentation((ObjectModelElement)interfaceOperation, attribute.getDocumentation());
        }
        this.setDocumentation((ObjectModelElement)param, "L'instance de " + attrType + " \u00e0 retirer");
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = TopiaGeneratorUtil.getSimpleName((String)attrType);
        StringBuilder body = new StringBuilder();
        body.append("\n        fireOnPreWrite(" + this.getConstantName(attrName) + ", " + attrName + ", null);\n" + "        if ((this." + attrName + " == null) || (!this." + attrName + ".remove(" + attrName + "))) {\n" + "            throw new IllegalArgumentException(\"List does not contain given element\");\n" + "        }\n" + "");
        if (reverse != null && (reverse.isNavigable() || TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attribute, (ObjectModel)this.model))) {
            String reverseAttrName = StringUtils.capitalize((String)reverse.getName());
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                body.append("\n        " + attrName + ".set" + reverseAttrName + "(null);\n" + "");
            } else if (!attribute.hasAssociationClass()) {
                body.append("\n        " + attrName + ".get" + reverseAttrName + "().remove(this);\n" + "");
            }
        }
        body.append("\n        fireOnPostWrite(" + this.getConstantName(attrName) + ", this." + attrName + ".size() + 1, " + attrName + ", null);\n" + "");
        this.setOperationBody(implOperation, body.toString());
    }

    protected void addMultipleClearOperation(ObjectModelAttribute attribute, String collectionInterface, String collectionImpl) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute);
        ObjectModelAttribute reverse = attribute.getReverseAttribute();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'clear' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, "clear" + StringUtils.capitalize((String)attrName), Void.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attribute)) {
            this.setDocumentation((ObjectModelElement)interfaceOperation, attribute.getDocumentation());
        }
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = TopiaGeneratorUtil.getSimpleName((String)attrType);
        StringBuilder body = new StringBuilder("\n        if (this." + attrName + " == null) {\n" + "            return;\n" + "        }\n" + "");
        if (reverse != null && (reverse.isNavigable() || TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(attribute, (ObjectModel)this.model))) {
            String reverseAttrName = StringUtils.capitalize((String)reverse.getName());
            body.append("        for (" + attrType + " item : this." + attrName + ") {\n" + "");
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse)) {
                body.append("            item.set" + reverseAttrName + "(null);\n" + "");
            } else if (!attribute.hasAssociationClass()) {
                body.append("            item.get" + reverseAttrName + "().remove(this);\n" + "");
            }
            body.append("        }\n");
        }
        body.append("        " + collectionInterface + "<" + attrType + "> oldValue = new " + collectionImpl + "<" + attrType + ">(this." + attrName + ");\n" + "        fireOnPreWrite(" + this.getConstantName(attrName) + ", oldValue, this." + attrName + ");\n" + "        this." + attrName + ".clear();\n" + "        fireOnPostWrite(" + this.getConstantName(attrName) + ", oldValue, this." + attrName + ");\n" + "");
        this.setOperationBody(implOperation, body.toString());
    }

    protected void addMultipleGetOperation(ObjectModelAttribute attribute, String collectionInterface) {
        String attrName = this.getPropertyName(attribute);
        String attrType = collectionInterface + "<" + this.getPropertyType(attribute) + ">";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'get' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, "get" + StringUtils.capitalize((String)attrName), attrType, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        this.setDocumentation((ObjectModelElement)interfaceOperation, "Retourne la collection.");
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        this.setOperationBody(implOperation, "\n        return " + attrName + ";\n" + "");
    }

    protected void addMultipleGetTopiaIdOperation(ObjectModelAttribute attribute) {
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'getByTopiaId' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, "get" + StringUtils.capitalize((String)attrName) + "ByTopiaId", attrType, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        ObjectModelParameter param = this.addParameter(interfaceOperation, String.class, "topiaId");
        this.setDocumentation((ObjectModelElement)interfaceOperation, "Recup\u00e8re l'attribut " + attrName + " \u00e0 partir de son topiaId");
        this.setDocumentation((ObjectModelElement)param, "le topia id de l'entit\u00e9 recherch\u00e9e");
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        this.addImport((ObjectModelClassifier)this.outputAbstract, TopiaEntityHelper.class);
        this.setOperationBody(implOperation, "\n        return TopiaEntityHelper.getEntityByTopiaId(" + attrName + ", topiaId);\n" + " ");
    }

    protected void addMultipleGetOperationFromEntity(ObjectModelAttribute attribute) {
        String referenceName = attribute.getName();
        String referenceType = attribute.getType();
        String attrName = this.getPropertyName(attribute);
        String attrType = this.getPropertyType(attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'getFromEntity' operation for property : " + attrName + " [" + attrType + "]"));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, "get" + StringUtils.capitalize((String)attrName), attrType, new ObjectModelModifier[0]);
        this.addParameter(interfaceOperation, referenceType, referenceName);
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        attrType = TopiaGeneratorUtil.getSimpleName((String)attrType);
        this.setOperationBody(implOperation, "\n        if (" + referenceName + " == null || this." + attrName + " == null) {\n" + "            return null;\n" + "        }\n" + "        for (" + attrType + " item : this." + attrName + ") {\n" + "            if (" + referenceName + ".equals(item.get" + StringUtils.capitalize((String)referenceName) + "())) {\n" + "                return item;\n" + "            }\n" + "        }\n" + "        return null;\n" + "");
    }

    protected void addMultipleSizeOperation(ObjectModelAttribute attribute) {
        String attrName = this.getPropertyName(attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'size' operation for property : " + attrName));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, "size" + StringUtils.capitalize((String)attrName), Integer.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        this.setDocumentation((ObjectModelElement)interfaceOperation, "Retourne le nombre d'\u00e9l\u00e9ments de la collection " + attrName);
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        this.setOperationBody(implOperation, "\n        if (" + attrName + " == null) {\n" + "            return 0;\n" + "        }\n" + "        return " + attrName + ".size();\n" + "");
    }

    protected void addMultipleIsEmptyOperation(ObjectModelAttribute attribute) {
        String attrName = this.getPropertyName(attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generate multiple 'isEmpty' operation for property : " + attrName));
        }
        ObjectModelOperation interfaceOperation = this.addOperation((ObjectModelClassifier)this.outputInterface, "is" + StringUtils.capitalize((String)attrName) + "Empty", Boolean.TYPE, new ObjectModelModifier[]{ObjectModelModifier.PACKAGE});
        this.setDocumentation((ObjectModelElement)interfaceOperation, "Retourne {@code true} si la collection " + attrName + " est vide.");
        ObjectModelOperation implOperation = this.createImplOperation(interfaceOperation);
        this.setOperationBody(implOperation, "\n        int size = size" + StringUtils.capitalize((String)attrName) + "();\n" + "        return size == 0;\n" + "");
    }

    protected void createAcceptOperation() {
        this.acceptOperation = this.addOperation((ObjectModelClassifier)this.outputAbstract, "accept", Void.TYPE, new ObjectModelModifier[0]);
        ObjectModelParameter param = this.addParameter(this.acceptOperation, EntityVisitor.class, "visitor");
        this.addException(this.acceptOperation, TopiaException.class);
        this.setDocumentation((ObjectModelElement)this.acceptOperation, "Envoi via les methodes du visitor l'ensemble des champs de l'entity\navec leur nom, type et valeur.");
        this.setDocumentation((ObjectModelElement)param, "le visiteur de l'entite.");
        this.acceptOperationBody = new StringBuilder("\n        visitor.start(this);\n");
    }

    protected void updateAcceptOperation(ObjectModelAttribute attribute) {
        String attrName = TopiaGeneratorUtil.getSimpleName((String)this.getPropertyName(attribute));
        String attrType = TopiaGeneratorUtil.getSimpleName((String)this.getPropertyType(attribute));
        String collectionType = this.getCollectionType(attribute);
        if (collectionType != null) {
            collectionType = TopiaGeneratorUtil.getSimpleName((String)collectionType);
            this.acceptOperationBody.append("        visitor.visit(this, " + this.getConstantName(attrName) + ", " + collectionType + ".class, " + attrType + ".class, " + attrName + ");\n" + "");
        } else {
            this.acceptOperationBody.append("        visitor.visit(this, " + this.getConstantName(attrName) + ", " + attrType + ".class, " + attrName + ");\n" + "");
        }
    }

    protected void closeAcceptOperation() {
        this.acceptOperationBody.append("        visitor.end(this);\n");
        this.setOperationBody(this.acceptOperation, this.acceptOperationBody.length() == 0 ? " " : this.acceptOperationBody.toString());
    }

    protected void generateToStringOperation(ObjectModelClass input) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("generate toString method for entity " + this.outputInterface.getQualifiedName()));
        }
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)this.outputAbstract, "toString", String.class, new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)this.outputAbstract, (ObjectModelElement)operation, Override.class.getSimpleName());
        this.addImport((ObjectModelClassifier)this.outputAbstract, ToStringBuilder.class);
        StringBuilder body = new StringBuilder("\n        String result = new ToStringBuilder(this).\n");
        for (ObjectModelAttribute attr : input.getAttributes()) {
            ObjectModelClass attrEntity = null;
            if (((ObjectModel)this.model).hasClass(attr.getType())) {
                attrEntity = ((ObjectModel)this.model).getClass(attr.getType());
            }
            boolean isEntity = attrEntity != null && TopiaGeneratorUtil.hasEntityStereotype(attrEntity);
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if ((!isEntity || reverse != null && reverse.isNavigable() || attr.hasAssociationClass()) && isEntity) continue;
            String attrName = attr.getName();
            body.append("            append(" + this.getConstantName(attrName) + ", this." + attrName + ").\n" + "");
        }
        body.append("         toString();\n        return result;\n");
        this.setOperationBody(operation, body.length() == 0 ? " " : body.toString());
    }

    protected void generateCompositeOperation(ObjectModelClass input) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)this.outputAbstract, "getComposite", List.class.getName() + '<' + TopiaEntity.class.getName() + '>', new ObjectModelModifier[0]);
        this.addException(operation, TopiaException.class);
        this.addAnnotation((ObjectModelClassifier)this.outputAbstract, (ObjectModelElement)operation, Override.class.getSimpleName());
        this.addImport((ObjectModelClassifier)this.outputAbstract, ArrayList.class);
        this.addImport((ObjectModelClassifier)this.outputAbstract, List.class);
        StringBuilder body = new StringBuilder("\n        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();\n\n        // pour tous les attributs rechecher les composites et les class d'asso\n        // on les ajoute dans tmp\n");
        for (ObjectModelAttribute attr : input.getAttributes()) {
            if (!attr.referenceClassifier() || !TopiaGeneratorUtil.hasEntityStereotype(attr.getClassifier())) continue;
            if (attr.isComposite()) {
                String attrName = attr.getName();
                String getterName = "get" + StringUtils.capitalize((String)attrName);
                if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                    body.append("        if (" + getterName + "() != null) {\n" + "              tmp.addAll(" + getterName + "());\n" + "           }\n" + "");
                    continue;
                }
                body.append("        tmp.add(" + getterName + "());\n" + "");
                continue;
            }
            if (!attr.hasAssociationClass()) continue;
            String assocAttrName = GeneratorUtil.getAssocAttrName((ObjectModelAttribute)attr);
            String assocClassFQN = TopiaGeneratorUtil.getSimpleName((String)attr.getAssociationClass().getQualifiedName());
            String ref = "this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                body.append("\n        if (" + ref + " != null) {\n" + "            tmp.add(" + ref + ");\n" + "        }\n" + "");
                continue;
            }
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            String reverseAttrName = reverse.getName();
            this.addImport((ObjectModelClassifier)this.outputAbstract, TopiaContextImplementor.class);
            body.append("\n        {\n            org.nuiton.topia.persistence.TopiaDAO<" + assocClassFQN + "> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(" + assocClassFQN + ".class);\n" + "            List<" + assocClassFQN + "> findAllByProperties = dao.findAllByProperties(\"" + reverseAttrName + "\", this);\n" + "            if (findAllByProperties != null) {\n" + "                tmp.addAll(findAllByProperties);\n" + "            }\n" + "        }\n" + "");
        }
        body.append("\n        // on refait un tour sur chaque entity de tmp pour recuperer leur\n        // composite\n        List<TopiaEntity> result = new ArrayList<TopiaEntity>();\n        for (TopiaEntity entity : tmp) {\n            if (entity != null) {\n                result.add(entity);\n                result.addAll(entity.getComposite());\n            }\n        }\n\n        return result;\n    ");
        this.setOperationBody(operation, body.length() == 0 ? " " : body.toString());
    }

    protected void generateAggregateOperation(ObjectModelClass input) {
        ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)this.outputAbstract, "getAggregate", List.class.getName() + '<' + TopiaEntity.class.getName() + '>', new ObjectModelModifier[0]);
        this.addException(operation, TopiaException.class);
        this.addAnnotation((ObjectModelClassifier)this.outputAbstract, (ObjectModelElement)operation, Override.class.getSimpleName());
        this.addImport((ObjectModelClassifier)this.outputAbstract, ArrayList.class);
        this.addImport((ObjectModelClassifier)this.outputAbstract, List.class);
        StringBuilder body = new StringBuilder("\n        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();\n\n        // pour tous les attributs rechecher les composites et les class d'asso\n        // on les ajoute dans tmp\n");
        for (ObjectModelAttribute attr : input.getAttributes()) {
            if (!attr.referenceClassifier() || !TopiaGeneratorUtil.hasEntityStereotype(attr.getClassifier()) || !attr.isAggregate()) continue;
            String attrName = attr.getName();
            String getterName = "get" + StringUtils.capitalize((String)attrName);
            if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                body.append("        tmp.addAll(" + getterName + "());\n" + "");
                continue;
            }
            body.append("        tmp.add(" + getterName + "());\n" + "");
        }
        body.append("\n        // on refait un tour sur chaque entity de tmp pour recuperer leur\n        // composite\n        List<TopiaEntity> result = new ArrayList<TopiaEntity>();\n        for (TopiaEntity entity : tmp) {\n            result.add(entity);\n            result.addAll(entity.getAggregate());\n        }\n\n        return result;\n");
        this.setOperationBody(operation, body.length() == 0 ? " " : body.toString());
    }

    @Deprecated
    protected void generateI18nBlock(ObjectModelClass input, String i18nPrefix) {
        this.generateI18nBlock((ObjectModelClassifier)input, (ObjectModelClassifier)this.outputAbstract, i18nPrefix);
    }

    @Deprecated
    protected void addI18n(StringBuilder buffer, String i18nPrefix, String suffix) {
        super.addI18n(buffer, i18nPrefix, suffix);
    }

    protected boolean isAbstract(ObjectModelClass clazz) {
        if (clazz.isAbstract()) {
            return true;
        }
        Collection allInterfaceOperations = clazz.getAllInterfaceOperations(true);
        allInterfaceOperations.removeAll(clazz.getAllOtherOperations(true));
        for (ObjectModelOperation op : allInterfaceOperations) {
            boolean implementationFound = false;
            for (ObjectModelClass superClazz : clazz.getSuperclasses()) {
                ObjectModelOperation matchingOp;
                Iterator i$ = superClazz.getOperations(op.getName()).iterator();
                while (i$.hasNext() && !(implementationFound = op.equals(matchingOp = (ObjectModelOperation)i$.next()) && !matchingOp.isAbstract())) {
                }
                if (!implementationFound) continue;
                break;
            }
            if (implementationFound) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)(clazz.getName() + " : abstract operation " + op));
            }
            return true;
        }
        return false;
    }

    protected String getCollectionType(ObjectModelAttribute attribute) {
        String result = null;
        if (!this.associationClass && TopiaGeneratorUtil.isNMultiplicity((ObjectModelAttribute)attribute)) {
            result = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attribute);
        }
        return result;
    }

    protected String getPropertyName(ObjectModelAttribute attribute) {
        String propertyName = attribute.getName();
        if (!this.associationClass && attribute.hasAssociationClass()) {
            propertyName = TopiaGeneratorUtil.getAssocAttrName((ObjectModelAttribute)attribute);
        }
        return propertyName;
    }

    protected String getPropertyType(ObjectModelAttribute attribute) {
        String propertyType = attribute.getType();
        if (!this.associationClass && attribute.hasAssociationClass()) {
            propertyType = attribute.getAssociationClass().getQualifiedName();
        }
        return propertyType;
    }

    protected ObjectModelOperation createImplOperation(ObjectModelOperation interfaceOperation) {
        ObjectModelOperation implOperation = this.cloneOperationSignature(interfaceOperation, (ObjectModelClassifier)this.outputAbstract, false, new ObjectModelModifier[0]);
        this.addAnnotation((ObjectModelClassifier)this.outputAbstract, (ObjectModelElement)implOperation, Override.class.getSimpleName());
        return implOperation;
    }

    protected ObjectModelOperation createPropertySetterSignature(ObjectModelClassifier classifier, String propertyType, String propertyName, String operationDocumentation) {
        ObjectModelOperation operation = this.addOperation(classifier, "set" + StringUtils.capitalize((String)propertyName), Void.TYPE, new ObjectModelModifier[0]);
        ObjectModelParameter param = this.addParameter(operation, propertyType, propertyName);
        if (StringUtils.isNotEmpty((String)operationDocumentation)) {
            this.setDocumentation((ObjectModelElement)operation, operationDocumentation);
        }
        this.setDocumentation((ObjectModelElement)param, "La valeur de l'attribut \u00e0 positionner.");
        return operation;
    }
}

