/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: TopiaModelPropertiesProviderTest.java 2168 2010-12-26 15:25:30Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.5.4/topia-persistence/src/test/java/org/nuiton/topia/generator/TopiaModelPropertiesProviderTest.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topia.generator;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuiton.eugene.ModelPropertiesUtil;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;

/**
 * To test {@link TopiaGeneratorUtil.TopiaModelPropertiesProvider}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.3
 */
public class TopiaModelPropertiesProviderTest {

    protected ModelPropertiesUtil.ModelPropertiesProvider provider;

    @Before
    public void setUp() throws Exception {
        provider = new TopiaGeneratorUtil.TopiaModelPropertiesProvider();
        provider.init();
    }

    @Test
    public void testGetTagValueTarget() throws Exception {
        testTagValue(TopiaTagValues.TAG_PERSISTENCE_TYPE, ObjectModelClassifier.class);
        //TODO Finish with other tag values...
    }

    @Test
    public void testGetStereotypeTarget() throws Exception {

        testStereotype(TopiaStereoTypes.STEREOTYPE_DAO, ObjectModelClassifier.class, ObjectModelOperation.class);
        //TODO Finish with other stereotypes...
    }

    @Test
    public void testGetStore() throws Exception {
    }

    protected void testStereotype(String name, Class<?>... expected) {
        Class<?>[] classes = provider.getStereotypeTarget(name);
        Assert.assertNotNull("Could not find target for " + name, classes);
        Assert.assertEquals("Should have " + expected.length + " targets for " + name + " but had " + classes.length, classes.length, expected.length);
        Assert.assertArrayEquals(expected, classes);
    }

    protected void testTagValue(String name, Class<?>... expected) {
        Class<?>[] classes = provider.getTagValueTarget(name);
        Assert.assertNotNull("Could not find target for " + name, classes);
        Assert.assertEquals("Should have " + expected.length + " targets for " + name + " but had " + classes.length, classes.length, expected.length);
        Assert.assertArrayEquals(expected, classes);
    }
}
