/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: EntityInterfaceTransformer.java 2071 2010-07-11 07:45:36Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.4.3/topia-persistence/src/main/java/org/nuiton/topia/generator/EntityInterfaceTransformer.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.generator;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.*;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

import java.util.*;






/**
 * Created: 14 déc. 2009
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Id: EntityInterfaceTransformer.java 2071 2010-07-11 07:45:36Z tchemit $
 * @since 2.3.0
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.EntityInterfaceTransformer"
 * @deprecated since 2.4 : all transformations needed for Entity is in {@link EntityTransformer} included in {@link TopiaMetaTransformer}
 */
@Deprecated
public class EntityInterfaceTransformer extends ObjectModelTransformerToJava {

    /**
     * Logger
     */
    private static final Log log = LogFactory.getLog(EntityInterfaceTransformer.class);

    @Override
    public void transformFromClass(ObjectModelClass clazz) {
        if (!clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
            return;
        }

        String clazzName = clazz.getName();

        ObjectModelInterface result;

        if (log.isDebugEnabled()) {
            log.debug("for entity : "+clazz.getQualifiedName());
        }

        result = createInterface(clazzName, clazz.getPackageName());

        addImport(result, SearchFields.class);
        addImport(result, TopiaEntity.class);
        if (TopiaGeneratorUtil.hasDocumentation(clazz)) {
            setDocumentation(result,clazz.getDocumentation());
        }

        String prefix = getConstantPrefix(clazz, "");

        if (StringUtils.isEmpty(prefix)) {

            // no specific prefix, so no prefix
            if (log.isWarnEnabled()) {
                log.warn("[" + clazz.getName() + "] Will generate constants with NO prefix, not a good idea...");
            }
        }
        
        setConstantPrefix(prefix);

        generateSearchFields(result, clazz);

        // super classes

        for (ObjectModelClassifier parent : clazz.getInterfaces()) {
            addInterface(result,parent.getQualifiedName());
        }

        for (ObjectModelClassifier parent : clazz.getSuperclasses()) {
            if (parent.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
                addInterface(result,parent.getQualifiedName());
                break;
            }
        }

        addInterface(result, TopiaEntity.class);

        generateStaticColumnNames(result, clazz);

        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() &&
                    !TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(
                            reverse, model)) {
                continue;
            }

            if (attr.hasAssociationClass()) {

                addAssociationAttribute(result, attr);

            } else {

                addNoneAssociationAttribute(result, attr);
            }
        }

        //Méthodes d'accès aux attributs d'une classe d'associations
        generateAssociationAttributes(result, clazz);

        generateInterfaceOperations(result, clazz);
    }

    protected void generateAssociationAttributes(ObjectModelInterface result,
                                                 ObjectModelClass clazz) {
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc =
                    (ObjectModelAssociationClass) clazz;
            for (ObjectModelAttribute attr :
                    assoc.getParticipantsAttributes()) {
                if (attr != null) {
                    String type = attr.getType();
                    String name = attr.getName();
                    generateAssociationAccessors(result, name, type);
                    if (attr.getReverseAttribute() == null) {
                        type = ((ObjectModelClassifier)
                                attr.getDeclaringElement()).getQualifiedName();
                        name = attr.getDeclaringElement().getName();
                        generateAssociationAccessors(result, name, type);
                    }
                }
            }
        }
    }


    protected void addNoneAssociationAttribute(ObjectModelInterface result,
                                               ObjectModelAttribute attr) {
        String attrName = attr.getName();
        String attrType = attr.getType();
        ObjectModelOperation op;
        ObjectModelParameter attr2;

        if (!GeneratorUtil.isNMultiplicity(attr)) {

            // setXXX

            op = addOperation(result,
                    "set" + StringUtils.capitalize(attrName),
                    "void",
                    ObjectModelModifier.PACKAGE);
            if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                setDocumentation(op, attr.getDocumentation());
            }
            attr2 = addParameter(op, attrType,
                                 GeneratorUtil.toLowerCaseFirstLetter(attrName));
            setDocumentation(attr2, "La valeur de l'attribut " + attrName
                    + " à positionner.");

            // getXXX

            op = addOperation(result,
                    "get" + StringUtils.capitalize(attrName),
                    attrType,
                    ObjectModelModifier.PACKAGE);
            if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                setDocumentation(op, attr.getDocumentation());
            }
        } else {
            String collectionInterface =
                    TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);

            // addXXX

            op = addOperation(result,
                    "add" + StringUtils.capitalize(attrName),
                    "void",
                    ObjectModelModifier.PACKAGE);
            if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                setDocumentation(op, attr.getDocumentation());
            }
            attr2 = addParameter(op, attrType,
                                 GeneratorUtil.toLowerCaseFirstLetter(attrName));
            setDocumentation(attr2,
                             "L'instance de " + attrName + " à ajouter");

            // addAllXXX

            op = addOperation(result,
                    "addAll" + StringUtils.capitalize(attrName),
                    "void",
                    ObjectModelModifier.PACKAGE);
            if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                setDocumentation(op, attr.getDocumentation());
            }
            attr2 = addParameter(op,
                                 collectionInterface + "<" + attrType + ">",
                                 GeneratorUtil.toLowerCaseFirstLetter(attrName));
            setDocumentation(attr2,
                             "Les instances de " + attrName + " à ajouter");

            // setXXX

            op = addOperation(result,
                    "set" + StringUtils.capitalize(attrName),
                    "void",
                    ObjectModelModifier.PACKAGE);
            if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                setDocumentation(op, attr.getDocumentation());
            }
            attr2 = addParameter(op,
                                 collectionInterface + "<" + attrType + ">",
                                 GeneratorUtil.toLowerCaseFirstLetter(attrName));
            setDocumentation(attr2,
                             "La Collection de " + attrName + " à ajouter");

            // removeXXX

            op = addOperation(result,
                    "remove" + StringUtils.capitalize(attrName),
                    "void",
                    ObjectModelModifier.PACKAGE);
            if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                setDocumentation(op, attr.getDocumentation());
            }
            attr2 = addParameter(op,
                                 attrType,
                                 GeneratorUtil.toLowerCaseFirstLetter(attrName));
            setDocumentation(attr2,
                             "L'instance de " + attrName + " à retirer");

            // clearXXX

            op = addOperation(result,
                    "clear" + StringUtils.capitalize(attrName),
                    "void",
                    ObjectModelModifier.PACKAGE);
            if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                setDocumentation(op, attr.getDocumentation());
            }
            setDocumentation(attr2, "Vide la Collection de " + attrName);

            // getXXX

            op = addOperation(result,
                    "get" + StringUtils.capitalize(attrName),
                    collectionInterface + "<" + attrType + ">",
                    ObjectModelModifier.PACKAGE);
            if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                setDocumentation(op, "Retourne la collection.");
            }

            if (!TopiaGeneratorUtil.isPrimitiveType(attr) &&
                !TopiaGeneratorUtil.isDateType(attr)) {

                // getXXXByTopiaId

                op = addOperation(result,
                        "get" + StringUtils.capitalize(attrName) + "ByTopiaId",
                        attrType,
                        ObjectModelModifier.PACKAGE);
                setDocumentation(op, "Recupère l'attribut " + attrName + " à partir de son topiaId");
                attr2 = addParameter(op, String.class, "topiaId");
                setDocumentation(attr2, "le topia id de l'entité recherchée");
            }

            // sizeXXX

            op = addOperation(result,
                    "size" + StringUtils.capitalize(attrName),
                    int.class,
                    ObjectModelModifier.PACKAGE);
            setDocumentation(op, "Retourne le nombre d'éléments de la collection " + attrName);

            // isXXXEmpty

            op = addOperation(result,
                    "is" + StringUtils.capitalize(attrName) + "Empty",
                    boolean.class,
                    ObjectModelModifier.PACKAGE);
            setDocumentation(op, "Retourne {@code true} si la collection " + attrName + " est vide.");
        }
    }

    protected void addAssociationAttribute(ObjectModelInterface result, ObjectModelAttribute attr) {
        String attrName = attr.getName();
        String attrType = attr.getType();
        String assocAttrName = GeneratorUtil.getAssocAttrName(attr);
        String assocClassFQN = attr.getAssociationClass().getQualifiedName();
        String assocClassName = attr.getAssociationClass().getName();

        ObjectModelOperation op;
        ObjectModelParameter attr2;

        if (!GeneratorUtil.isNMultiplicity(attr)) {

            // setXXX

            op = addOperation(result,
                    "set" + StringUtils.capitalize(assocAttrName),
                    "void",
                    ObjectModelModifier.PACKAGE);
            attr2 = addParameter(op, assocClassFQN, GeneratorUtil.toLowerCaseFirstLetter(assocClassName));
            setDocumentation(attr2, "La valeur de l'attribut " + assocClassName + " à positionner");

            // getXXX

            addOperation(result,
                    "get" + StringUtils.capitalize(assocAttrName),
                    assocClassFQN,
                    ObjectModelModifier.PACKAGE);

        } else {
            String collectionInterface = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);

            // addXXX

            op = addOperation(result,
                    "add" + StringUtils.capitalize(assocAttrName),
                    "void",
                    ObjectModelModifier.PACKAGE);
            attr2 = addParameter(op, assocClassFQN, GeneratorUtil.toLowerCaseFirstLetter(assocClassName));
            setDocumentation(attr2, "L'instance de " + assocClassName + " à ajouter");

            // addAllXXX

            op = addOperation(result,
                    "addAll" + StringUtils.capitalize(assocAttrName),
                    "void",
                    ObjectModelModifier.PACKAGE);
            attr2 = addParameter(op, collectionInterface + "<" + assocClassFQN + ">", GeneratorUtil.toLowerCaseFirstLetter(assocClassName));
            setDocumentation(attr2, "Les instances de " + assocClassName + " à ajouter");

            // setXXX

            op = addOperation(result,
                    "set" + StringUtils.capitalize(assocAttrName),
                    "void",
                    ObjectModelModifier.PACKAGE);
            attr2 = addParameter(op, collectionInterface + "<" + assocClassFQN + ">", GeneratorUtil.toLowerCaseFirstLetter(assocClassName));
            setDocumentation(attr2, "La Collection de " + assocClassName + " à ajouter");

            // removeXXX

            op = addOperation(result,
                    "remove" + StringUtils.capitalize(assocAttrName),
                    "void",
                    ObjectModelModifier.PACKAGE);
            attr2 = addParameter(op, assocClassFQN, GeneratorUtil.toLowerCaseFirstLetter(assocClassName));
            setDocumentation(attr2, "L'instance de " + assocClassName + " à retirer");

            // clearXXX

            op = addOperation(result,
                    "clear" + StringUtils.capitalize(assocAttrName),
                    "void",
                    ObjectModelModifier.PACKAGE);
            setDocumentation(op, "Vide la Collection de " + assocClassName + " .");

            // getXXX

            addOperation(result,
                    "get" + StringUtils.capitalize(assocAttrName),
                    collectionInterface + "<" + assocClassFQN + ">",
                    ObjectModelModifier.PACKAGE);

            if (!TopiaGeneratorUtil.isPrimitiveType(attr) && !TopiaGeneratorUtil.isDateType(attr)) {

                // getXXXByTopiaId

                op = addOperation(result,
                        "get" + StringUtils.capitalize(assocAttrName) + "ByTopiaId",
                        assocClassFQN,
                        ObjectModelModifier.PACKAGE);
                setDocumentation(op, "Recupère l'attribut " + attrName + " à partir de son topiaId");
                attr2 = addParameter(op, String.class, "topiaId");
                setDocumentation(attr2, "le topia id de l'entité recherchée");
            }

            // getXXX

            op = addOperation(result,
                    "get" + StringUtils.capitalize(assocAttrName),
                    assocClassFQN);
            addParameter(op, attrType, "value");


            // sizeXXX

            addOperation(result,
                    "size" + StringUtils.capitalize(assocAttrName),
                    int.class,
                    ObjectModelModifier.PACKAGE);


            // isXXXEmpty

            addOperation(result,
                    "is" + StringUtils.capitalize(assocAttrName) + "Empty",
                    boolean.class,
                    ObjectModelModifier.PACKAGE);
        }
    }

    private void generateInterfaceOperations(ObjectModelInterface output, ObjectModelClassifier classifier) {

        for (ObjectModelOperation op : classifier.getOperations()) {

            String visibility = op.getVisibility();
            if (op.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DAO) ||
                    !visibility.equals(ObjectModelModifier.PUBLIC.toString())) {
                // Pas de génération des signatures de méthodes pour celles à intégrer au DAO de l'entité
                continue;
            }
            
            String opName = op.getName();
            String opType = op.getReturnType();

            ObjectModelOperation op2 = addOperation(output, opName, opType, ObjectModelModifier.PACKAGE);
            if (TopiaGeneratorUtil.hasDocumentation(op)) {
                setDocumentation(op2, op.getDocumentation());
            }

            for (ObjectModelParameter param : op.getParameters()) {
                String paramName = param.getName();
                String paramType = param.getType();
                ObjectModelParameter param2 = addParameter(op2, paramType, paramName);
                if (TopiaGeneratorUtil.hasDocumentation(param)) {
                    setDocumentation(param2, param.getDocumentation());
                }
            }
            for (String exception : op.getExceptions()) {
                addException(op2, exception);
            }
        }
    }

    private void generateAssociationAccessors(ObjectModelInterface output, String attrName, String attrType) {

        ObjectModelOperation op;
        ObjectModelParameter param;

        op = addOperation(output,
                "set" + StringUtils.capitalize(attrName),
                "void",
                ObjectModelModifier.PACKAGE);
        param = addParameter(op, attrType, "value");
        setDocumentation(param, "La valeur de l'attribut " + attrName + " à positionner.");

        op = addOperation(output,
                "get" + StringUtils.capitalize(attrName),
                attrType,
                ObjectModelModifier.PACKAGE);
        setDocumentation(op, "Retourne la valeur de l'attribut " + attrName + ".");
    }

//    private static final String doubleQuote = "\"";
    private static final String comma = ", ";

    private String getStringRepresentation(ObjectModelInterface output,List<String> strings) {
        StringBuilder result = new StringBuilder();

        Iterator<String> it = strings.iterator();
        if (it.hasNext()) {
            result.append(output.getName());
            result.append('.');
            result.append(getConstantName(it.next()));
//            result.append(doubleQuote).append(it.next()).append(doubleQuote);
        }
        while (it.hasNext()) {
            result.append(comma);
            result.append(output.getName());
            result.append('.');
            result.append(getConstantName(it.next()));
//            result.append(comma).append(doubleQuote).append(it.next()).append(doubleQuote);
        }
        return result.toString();
    }

    private void generateSearchFields(ObjectModelInterface result, ObjectModelClass clazz)  {
        List<String> txtFields = new ArrayList<String>();
        List<String> numFields = new ArrayList<String>();
        List<String> boolFields = new ArrayList<String>();
        List<String> dateFields = new ArrayList<String>();
        List<ObjectModelAttribute> allAttrs = new ArrayList<ObjectModelAttribute>();
        allAttrs.addAll(clazz.getAttributes());
        allAttrs.addAll(clazz.getAllOtherAttributes());
        boolean needAnnotation = false;
        for (ObjectModelAttribute attr : allAttrs) {
            String name = GeneratorUtil.toLowerCaseFirstLetter(attr.getName());
            if (TopiaGeneratorUtil.isTextType(attr)) {
                txtFields.add(name);
                needAnnotation = true;
            } else if (TopiaGeneratorUtil.isNumericType(attr)) {
                numFields.add(name);
                needAnnotation = true;
            } else if (TopiaGeneratorUtil.isBooleanType(attr)) {
                boolFields.add(name);
                needAnnotation = true;
            } else if (TopiaGeneratorUtil.isDateType(attr)) {
                dateFields.add(name);
                needAnnotation = true;
            }
        }

        // generate @SearchFields annotation
        
        StringBuilder annotationCode = new StringBuilder();
        annotationCode.append(""
+"SearchFields ("
                );
        if (needAnnotation) {
            StringBuilder buffer = new StringBuilder();
            if (!txtFields.isEmpty()) {
                buffer.append("\n  txtFields={");
                buffer.append(getStringRepresentation(result,txtFields));
                buffer.append("}");
                if (!numFields.isEmpty() || !boolFields.isEmpty() ||
                        !dateFields.isEmpty()) {
                    buffer.append(",");
                }
            }
            if (!numFields.isEmpty()) {
                buffer.append("\n  numFields={");
                buffer.append(getStringRepresentation(result,numFields));
                buffer.append("}");
                if (!boolFields.isEmpty() || !dateFields.isEmpty()) {
                    buffer.append(",");
                }
            }
            if (!boolFields.isEmpty()) {
                buffer.append("\n  boolFields={");
                buffer.append(getStringRepresentation(result,boolFields));
                buffer.append("}");
                if (!dateFields.isEmpty()) {
                    buffer.append(",");
                }
            }
            if (!dateFields.isEmpty()) {
                buffer.append("\n  dateFields={");
                buffer.append(getStringRepresentation(result,dateFields));
                buffer.append("}");
            }
            annotationCode.append(""
+""+buffer.toString()+"\n"
+""
            );
        }
        annotationCode.append(""
+")"
        );
        addAnnotation(result, result, annotationCode.toString());
    }

    private void generateStaticColumnNames(ObjectModelInterface result,
                                           ObjectModelClass clazz) {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!(attr.isNavigable() ||
                    TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType(
                            reverse, model)
                    || attr.hasAssociationClass())) {
                continue;
            }
            String attrName;
            if (!attr.hasAssociationClass()) {
                attrName = attr.getName();
            } else {
                String assocAttrName = GeneratorUtil.getAssocAttrName(attr);
                attrName = GeneratorUtil.toLowerCaseFirstLetter(assocAttrName);
            }
            String attrColName = getConstantName(attrName);
//            String attrColName = TopiaGeneratorUtil.convertVariableNameToConstantName(attrName);
            addAttribute(result,
                    attrColName,
                    String.class,
                    "\"" + attrName + "\"",
                    ObjectModelModifier.PACKAGE);
        }

        //Déclaration des noms des champs des attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass) clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr != null) {
                    String attrName = attr.getName();
                    String attrColName = getConstantName(attrName);
//                    String attrColName = TopiaGeneratorUtil.convertVariableNameToConstantName(attrName);
                    addAttribute(result,
                            attrColName,
                            String.class,
                            "\"" + attrName + "\"",
                            ObjectModelModifier.PACKAGE);
                }
            }
        }
    }
}
