/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topiatest.Company;
import org.nuiton.topiatest.CompanyDAO;
import org.nuiton.topiatest.Department;
import org.nuiton.topiatest.DepartmentDAO;

public class TopiaTestCase {
    private static final Log log = LogFactory.getLog(TopiaTestCase.class);
    protected static Properties config;
    protected static TopiaContext context;

    @BeforeClass
    public static void init() {
        config = new Properties();
        config.setProperty("topia.persistence.classes", TopiaTestDAOHelper.getImplementationClassesAsString());
        config.setProperty("hibernate.connection.username", "sa");
        config.setProperty("hibernate.connection.password", "");
        config.setProperty("hibernate.current_session_context_class", "thread");
        config.setProperty("hibernate.dialect", "org.hibernate.dialect.H2Dialect");
        config.setProperty("hibernate.connection.driver_class", "org.h2.Driver");
        config.setProperty("hibernate.connection.url", "jdbc:h2:file:target/" + TopiaTestCase.class.getSimpleName() + "/db/data_" + System.currentTimeMillis());
    }

    @AfterClass
    public static void after() throws TopiaException {
        context.clear(true);
    }

    @Before
    public void setUp() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Junit beforeTest");
        }
        try {
            context = TopiaContextFactory.getContext((Properties)config);
            try {
                context.createSchema();
            }
            catch (TopiaException e) {
                log.error((Object)"Erreur \u00e0 la creation du schema", (Throwable)e);
            }
        }
        catch (TopiaNotFoundException e) {
            log.error((Object)"Erreur \u00e0 la creation du topia context", (Throwable)e);
        }
    }

    @Test
    public void testCompositeAssociations() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Junit Test testCompositeAssociations");
        }
        try {
            TopiaContext newContext = context.beginTransaction();
            CompanyDAO companyDAO = TopiaTestDAOHelper.getCompanyDAO(newContext);
            DepartmentDAO departmentDAO = TopiaTestDAOHelper.getDepartmentDAO(newContext);
            Company company = (Company)companyDAO.create(new Object[0]);
            company.setName("Ma soci\u00e9t\u00e9");
            Department dep1 = (Department)departmentDAO.create(new Object[0]);
            dep1.setName("Departement 1");
            Department dep2 = (Department)departmentDAO.create(new Object[0]);
            dep2.setName("Departement 2");
            Department dep3 = (Department)departmentDAO.create(new Object[0]);
            dep3.setName("Departement 3");
            Department dep4 = (Department)departmentDAO.create(new Object[0]);
            dep4.setName("Departement 7");
            departmentDAO.update(dep1);
            departmentDAO.update(dep2);
            departmentDAO.update(dep3);
            departmentDAO.update(dep4);
            company.addDepartment(dep1);
            company.addDepartment(dep2);
            company.addDepartment(dep3);
            company.addDepartment(dep4);
            companyDAO.update(company);
            newContext.commitTransaction();
            newContext = context.beginTransaction();
            companyDAO = TopiaTestDAOHelper.getCompanyDAO(newContext);
            company = (Company)companyDAO.findByTopiaId(company.getTopiaId());
            Assert.assertEquals((Object)company.getName(), (Object)"Ma soci\u00e9t\u00e9");
            Assert.assertEquals((long)company.getDepartment().size(), (long)4L);
            newContext.commitTransaction();
            newContext.closeContext();
        }
        catch (TopiaException e) {
            log.error((Object)"Erreur pendant le test testCompositeAssociations", (Throwable)e);
        }
    }
}

