/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topiatest.deletetest;

import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topiatest.Personne;
import org.nuiton.topiatest.PersonneDAO;
import org.nuiton.topiatest.deletetest.Contact2;
import org.nuiton.topiatest.deletetest.Contact2DAO;
import org.nuiton.topiatest.deletetest.Party2;
import org.nuiton.topiatest.deletetest.Party2DAO;
import org.nuiton.util.Resource;

public class DeleteEntityTest {
    private static TopiaContext rootContext;
    private static final Log log;

    @BeforeClass
    public static void setUpClass() throws Exception {
        try {
            Properties conf = new Properties();
            URL url = Resource.getURL((String)"TopiaContextImpl.properties");
            if (log.isDebugEnabled()) {
                log.debug((Object)url);
            }
            conf.load(url.openStream());
            conf.setProperty("topia.persistence.classes", TopiaTestDAOHelper.getImplementationClassesAsString());
            rootContext = TopiaContextFactory.getContext((Properties)conf);
            if (log.isInfoEnabled()) {
                log.info((Object)"Context Ready !");
            }
        }
        catch (Exception ex) {
            log.error((Object)"Initialize error !!", (Throwable)ex);
        }
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        rootContext.closeContext();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testDeleteEntityWithInheritance() {
        log.debug((Object)"START TEST : testDeleteEntityWithInheritance");
        try {
            TopiaContext transaction = rootContext.beginTransaction();
            log.debug((Object)"DAO : PersonneDAO");
            PersonneDAO dao = TopiaTestDAOHelper.getPersonneDAO(transaction);
            log.debug((Object)"CREATE PERSONNE : Bob Marley");
            Personne personne = (Personne)dao.create(new Object[]{"name", "Bob Marley"});
            transaction.commitTransaction();
            String idPersonne = personne.getTopiaId();
            Assert.assertNotNull((Object)idPersonne);
            log.debug((Object)"ENTITY PERSONNE SAVED !");
            log.debug((Object)"DELETE PERSONNE");
            dao.delete(personne);
            transaction.commitTransaction();
            Personne res = (Personne)dao.findByTopiaId(idPersonne);
            Assert.assertNull((Object)res);
            log.debug((Object)"ENTITY PERSONNE DELETED !");
            log.debug((Object)"CREATE PERSONNE : Ziggy Marley");
            Personne personne2 = (Personne)dao.create(new Object[]{"name", "Ziggy Marley"});
            transaction.commitTransaction();
            String idPersonne2 = personne2.getTopiaId();
            Assert.assertNotNull((Object)idPersonne2);
            log.debug((Object)"ENTITY PERSONNE SAVED !");
            log.debug((Object)"DAO parent (abstract) : PartyDAO");
            Party2DAO dao2 = TopiaTestDAOHelper.getParty2DAO(transaction);
            log.debug((Object)"DELETE PERSONNE with PartyDAO");
            dao2.delete(personne2);
            transaction.commitTransaction();
            Party2 res2 = (Party2)dao2.findByTopiaId(idPersonne2);
            Assert.assertNull((Object)res2);
            log.debug((Object)"ENTITY PERSONNE DELETED !");
            transaction.closeContext();
        }
        catch (TopiaException ex) {
            log.error((Object)"TopiaException", (Throwable)ex);
        }
        log.debug((Object)"END TEST");
    }

    @Test
    public void testDeleteEntityWithManyToManyRelation() {
        log.debug((Object)"START TEST : testDeleteEntityWithManyToManyRelation");
        try {
            TopiaContext transaction = rootContext.beginTransaction();
            PersonneDAO dao = TopiaTestDAOHelper.getPersonneDAO(transaction);
            log.debug((Object)"CREATE PERSONNE : Bob Marley");
            Personne personne = (Personne)dao.create(new Object[]{"name", "Bob Marley"});
            transaction.commitTransaction();
            String idPersonne = personne.getTopiaId();
            Assert.assertNotNull((Object)idPersonne);
            log.debug((Object)"ENTITY PERSONNE SAVED !");
            Contact2DAO contactDAO = TopiaTestDAOHelper.getContact2DAO(transaction);
            log.debug((Object)"CREATE CONTACT : jaja@codelutin.com");
            Contact2 contact = (Contact2)contactDAO.create(new Object[]{"contactValue", "jaja@codelutin.com"});
            transaction.commitTransaction();
            String idContact = contact.getTopiaId();
            Assert.assertNotNull((Object)idContact);
            log.debug((Object)"ENTITY CONTACT SAVED !");
            log.debug((Object)"ADD CONTACT TO PERSONNE");
            personne.addContacts(contact);
            transaction.commitTransaction();
            Assert.assertEquals((long)1L, (long)personne.getContacts().size());
            log.debug((Object)"CONTACT ADDED !");
            log.debug((Object)"DELETE PERSONNE");
            dao.delete(personne);
            transaction.commitTransaction();
            Personne res = (Personne)dao.findByTopiaId(idPersonne);
            Assert.assertNull((Object)res);
            log.debug((Object)"ENTITY PERSONNE DELETED !");
            Assert.assertEquals((long)0L, (long)contact.getParty2().size());
            log.debug((Object)"DELETE CONTACT");
            contactDAO.delete(contact);
            transaction.commitTransaction();
            Contact2 res2 = (Contact2)contactDAO.findByTopiaId(idContact);
            Assert.assertNull((Object)res2);
            log.debug((Object)"ENTITY PERSONNE DELETED !");
            transaction.closeContext();
        }
        catch (TopiaException ex) {
            log.error((Object)"TopiaException", (Throwable)ex);
        }
        log.debug((Object)"END TEST");
    }

    static {
        log = LogFactory.getLog(DeleteEntityTest.class);
    }
}

