package org.nuiton.topia.test.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public  abstract class PetDAOAbstract<E extends Pet> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Pet.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Pet.PROPERTY_NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Pet.PROPERTY_NAME, v);
        return result;
    }

    /**
     * findByType :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut type le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByType(String v) throws TopiaException {
        E result = findByProperty(Pet.PROPERTY_TYPE, v);
        return result;
    }

    /**
     * findAllByType :
     * Retourne les éléments ayant comme valeur pour l'attribut type le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByType(String v) throws TopiaException {
        List<E> result = findAllByProperty(Pet.PROPERTY_TYPE, v);
        return result;
    }

    /**
     * findByPerson :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut person le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPerson(Person v) throws TopiaException {
        E result = findByProperty(Pet.PROPERTY_PERSON, v);
        return result;
    }

    /**
     * findAllByPerson :
     * Retourne les éléments ayant comme valeur pour l'attribut person le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPerson(Person v) throws TopiaException {
        List<E> result = findAllByProperty(Pet.PROPERTY_PERSON, v);
        return result;
    }

    /**
     * findByRace :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut race le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByRace(Race v) throws TopiaException {
        E result = findByProperty(Pet.PROPERTY_RACE, v);
        return result;
    }

    /**
     * findAllByRace :
     * Retourne les éléments ayant comme valeur pour l'attribut race le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByRace(Race v) throws TopiaException {
        List<E> result = findAllByProperty(Pet.PROPERTY_RACE, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Person.class) {
            PersonDAO dao = (PersonDAO)
                getContext().getDAO(Person.class);
            tmp = dao.findAllByProperties(Person.PROPERTY_PET, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);
        
        List<? extends TopiaEntity> list;

        list = findUsages(Person.class, entity);
        if (!list.isEmpty()) {
            result.put(Person.class, list);
        }

        return result;
    }


} //PetDAOAbstract<E extends Pet>
