package org.nuiton.topiatest;

import java.util.Collection;
import org.nuiton.topia.persistence.TopiaEntity;


public interface Department extends TopiaEntity {     String NAME = "name";
     String LEADER = "leader";
     String COMPANY = "company";
     String PRODUCT = "product";
    /**
     * setName :
     * @param name La valeur de l'attribut name à positionner.
     */

     void setName(String name);

    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * setLeader :
     * @param leader La valeur de l'attribut leader à positionner.
     */

     void setLeader(Employe leader);

    /**
     * getLeader :
     * @return Employe 
     */

     Employe getLeader();

    /**
     * setCompany :
     * @param company La valeur de l'attribut company à positionner.
     */

     void setCompany(Company company);

    /**
     * getCompany :
     * @return Company 
     */

     Company getCompany();

    /**
     * addProduct :
     * @param product L'instance de product à ajouter
     */

     void addProduct(Product product);

    /**
     * addAllProduct :
     * @param product Les instances de product à ajouter
     */

     void addAllProduct(Collection<Product> product);

    /**
     * setProduct :
     * @param product La Collection de product à ajouter
     */

     void setProduct(Collection<Product> product);

    /**
     * removeProduct :
     * @param product Vide la Collection de product
     */

     void removeProduct(Product product);

    /**
     * clearProduct :
     */

     void clearProduct();

    /**
     * getProduct :
     * @return Collection<Product> 
     */

     Collection<Product> getProduct();

    /**
     * getProductByTopiaId :
     * Recupère l'attribut product à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return Product 
     */

     Product getProductByTopiaId(String topiaId);

    /**
     * sizeProduct :
     * Retourne le nombre d'éléments de la collection product
     * @return int 
     */

     int sizeProduct();

    /**
     * isProductEmpty :
     * Retourne {@code true} si la collection product est vide.
     * @return boolean 
     */

     boolean isProductEmpty();


} //Department
