package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class AddressAbstract extends TopiaEntityAbstract implements Address {

    protected String city;
    protected String adress;
    /**
     * getCity :
     * @return String 
     */

    public String getCity() {
        fireOnPreRead(CITY, city);
        java.lang.String result = this.city;
        fireOnPostRead(CITY, city);
        return result;
}

    /**
     * getAdress :
     * @return String 
     */

    public String getAdress() {
        fireOnPreRead(ADRESS, adress);
        java.lang.String result = this.adress;
        fireOnPostRead(ADRESS, adress);
        return result;
}

    /**
     * update :
     * @deprecated since 2.3.4, use the DAO api instead.
     * @throws TopiaException
     */

    @Deprecated
    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Address.class).update(this);
}

    /**
     * delete :
     * @deprecated since 2.3.4, use the DAO api instead.
     * @throws TopiaException
     */

    @Deprecated
    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Address.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, CITY, String.class, city);
        visitor.visit(this, ADRESS, String.class, adress);
        visitor.end(this);
}

    /**
     * getAggregate :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
    }

    /**
     * setCity :
     * @param value 
     */

    public void setCity(String value) {
        String _oldValue = this.city;
        fireOnPreWrite(CITY, _oldValue, value);
        this.city = value;
        fireOnPostWrite(CITY, _oldValue, value);
}

    /**
     * setAdress :
     * @param value 
     */

    public void setAdress(String value) {
        String _oldValue = this.adress;
        fireOnPreWrite(ADRESS, _oldValue, value);
        this.adress = value;
        fireOnPostWrite(ADRESS, _oldValue, value);
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(CITY, this.city).
            append(ADRESS, this.adress).
         toString();
        return result;
}

static {
    
    org.nuiton.i18n.I18n.n_("topia.test.common.address");
    org.nuiton.i18n.I18n.n_("topia.test.common.city");
    org.nuiton.i18n.I18n.n_("topia.test.common.adress");
    }

} //AddressAbstract
