/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: EntityDTOGenerator.java 1894 2010-04-15 15:44:51Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.3/topia-persistence/src/main/java/org/nuiton/topia/generator/EntityDTOGenerator.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */




/* *
* EntityAbstractGenerator.java
*
* Created: 12 déc. 2005
*
* @author Arnaud Thimel <thimel@codelutin.com>
* @version $Revision: 1894 $
*
* Mise a jour: $Date: 2010-04-15 17:44:51 +0200 (jeu., 15 avril 2010) $
* par : $Author: tchemit $
*/

package org.nuiton.topia.generator;

import org.nuiton.eugene.models.object.*;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.TAG_ANNOTATION;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.GeneratorUtil;

// do not remove me
import org.apache.commons.lang.StringUtils;
/**
 * Generateur d'entites abstraites. Il s'agit de l'implatation par defaut d'une
 * entite. Les classes generees sont surchargees par un XXXImpl lorsque l'entite
 * n'est pas abstraite. La surcharge peut etre ecrite par l'utilisateur.
 *
 * @deprecated since 2.3.0, prefer use the corresponding {@link org.nuiton.eugene.Transformer} :
 * {@link EntityDTOTransformer}.
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.EntityDTOGenerator" 
 */
@Deprecated
public class EntityDTOGenerator extends ObjectModelGenerator {

    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(EntityDTOGenerator.class);

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + "DTO.java";
    }

    public boolean isEntity(String type) {
        ObjectModelClassifier clazz = model.getClassifier(type);
        return clazz != null && clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY);
    }

    @Override
    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
            return;
        }
        String copyright = TopiaGeneratorUtil.getCopyright(model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
output.write(""+copyright+"\n");
output.write("");
        }
        String clazzName = clazz.getName();
output.write("package "+clazz.getPackageName()+";\n");
output.write("\n");
output.write("import org.apache.commons.lang.builder.ToStringBuilder;\n");
output.write("import java.beans.PropertyChangeListener;\n");
output.write("\n");
output.write("/**\n");
output.write(" * Implantation DTO pour l'entité "+StringUtils.capitalize(clazzName)+".\n");
output.write(" */\n");
output.write("");
        String extendClass = "";
        for (Iterator<ObjectModelClass> i=clazz.getSuperclasses().iterator(); i.hasNext();) {
            ObjectModelClass parent = i.next();
            extendClass += parent.getQualifiedName() + "DTO";
            if (i.hasNext()) {
                extendClass += ", ";
            }
        }
        if (extendClass.length() > 0) {
        	extendClass = "extends " + extendClass + " ";
        }

output.write("public class "+clazzName+"DTO "+extendClass+"implements java.io.Serializable {\n");
output.write("\n");
output.write("");

        String svUID = TopiaGeneratorUtil.findTagValue("dto-serialVersionUID", clazz, model);
        if (svUID != null) {
output.write("    public static final long serialVersionUID = "+svUID+";\n");
output.write("\n");
output.write("");
        }
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            
            // pour les asso quoi qu'il arrive il faut les lier des 2 cotes
            // pour pouvoir supprimer en cascade l'asso lors de la suppression
            // d'un des cotes
            if (!(attr.isNavigable()
                    || hasUnidirectionalRelationOnAbstractType(reverse, model)
                    || attr.hasAssociationClass())) {
                continue;
            }
            if (TopiaGeneratorUtil.hasDocumentation(attr)) {
output.write("    /**\n");
output.write("     * "+attr.getDocumentation()+"\n");
output.write("     */\n");
output.write("");
            }
            if (attr.hasTagValue(TAG_ANNOTATION)) {
            	String annotation = attr.getTagValue(TAG_ANNOTATION);
output.write("    "+annotation+"\n");
output.write("");
            }

            String attrVisibility = attr.getVisibility();
            if (!attr.hasAssociationClass()) {
            	String attrType = attr.getType();
            	String attrName = attr.getName();
            	if (isEntity(attrType)) {
            		attrType += "DTO";
            	}
                if (!GeneratorUtil.isNMultiplicity(attr)) {
output.write("    "+attrVisibility+" "+attrType+" "+attrName+";\n");
output.write("\n");
output.write("");
                } else {
output.write("    "+attrVisibility+" "+attrType+"[] "+attrName+";\n");
output.write("\n");
output.write("");
                }
            } else {
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
            	String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                if (!GeneratorUtil.isNMultiplicity(attr)) {
output.write("    "+attrVisibility+" "+assocClassFQN+"DTO "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("\n");
output.write("");
                } else {
output.write("    "+attrVisibility+" "+assocClassFQN+"DTO[] "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("\n");
output.write("");
                }
            }
        }

        //Déclaration des attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr != null) {
                    String attrVisibility = attr.getVisibility();
                    String attrType = attr.getType();
                    String attrName = attr.getName();
                	if (isEntity(attrType)) {
                		attrType += "DTO";
                	}
output.write("    "+attrVisibility+" "+attrType+" "+GeneratorUtil.toLowerCaseFirstLetter(attrName)+";\n");
output.write("\n");
output.write("");
                }
            }
        }

output.write("\n");
output.write("     protected java.beans.PropertyChangeSupport p;\n");
output.write("\n");
output.write("");
        
output.write("    /**\n");
output.write("     * Constructeur de "+clazzName+"DTO par défaut.\n");
output.write("     */\n");
output.write("    public "+clazzName+"DTO() { p = new java.beans.PropertyChangeSupport(this); }\n");
output.write("\n");
output.write("    public void addPropertyChangeListener(PropertyChangeListener listener) {\n");
output.write("        p.addPropertyChangeListener(listener);\n");
output.write("    }\n");
output.write("\n");
output.write("    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {\n");
output.write("        p.addPropertyChangeListener(propertyName, listener);\n");
output.write("    }\n");
output.write("\n");
output.write("    public void removePropertyChangeListener(PropertyChangeListener listener) {\n");
output.write("        p.removePropertyChangeListener(listener);\n");
output.write("    }\n");
output.write("\n");
output.write("    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {\n");
output.write("        p.removePropertyChangeListener(propertyName, listener);\n");
output.write("    }\n");
output.write("\n");
output.write("");

        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();

            if (!(attr.isNavigable()
                    || hasUnidirectionalRelationOnAbstractType(reverse, model))) {
                continue;
            }
            String attrName = attr.getName();

            if (!attr.hasAssociationClass()) {
                String attrType = attr.getType();
                if (isEntity(attrType)) {
                	attrType += "DTO";
                }
            	if (!GeneratorUtil.isNMultiplicity(attr)) {
output.write("    public void set"+StringUtils.capitalize(attrName)+"("+attrType+" value) {\n");
output.write("        "+attrType+" oldValue = this."+attrName+";\n");
output.write("        this."+attrName+" = value;\n");
output.write("        p.firePropertyChange(\""+attrName+"\", oldValue, value);\n");
output.write("    }\n");
output.write("\n");
output.write("    public "+attrType+" get"+StringUtils.capitalize(attrName)+"() {\n");
output.write("        return "+attrName+";\n");
output.write("    }\n");
output.write("\n");
output.write("");
            	} else {
output.write("    public void set"+StringUtils.capitalize(attrName)+"("+attrType+"[] values) {\n");
output.write("       "+attrType+"[] oldValues = this."+attrName+";\n");
output.write("        this."+attrName+" = values;\n");
output.write("        p.firePropertyChange(\""+attrName+"\", oldValues, values);\n");
output.write("    }\n");
output.write("\n");
output.write("    public "+attrType+"[] get"+StringUtils.capitalize(attrName)+"() {\n");
output.write("        return this."+attrName+";\n");
output.write("    }\n");
output.write("\n");
output.write("");
            	}
            } else {
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                String assocClassFQN = attr.getAssociationClass().getQualifiedName();
            	if (!GeneratorUtil.isNMultiplicity(attr)) {
output.write("    public void set"+StringUtils.capitalize(assocAttrName)+"("+assocClassFQN+"DTO association) {\n");
output.write("        "+assocClassFQN+"DTO oldAssocation= this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("        this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" = association;\n");
output.write("        p.firePropertyChange(\""+attrName+"\", oldAssocation, assocation);\n");
output.write("    }\n");
output.write("\n");
output.write("    public "+assocClassFQN+"DTO get"+StringUtils.capitalize(assocAttrName)+"() {\n");
output.write("        return "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("    }\n");
output.write("\n");
output.write("");
            	} else {
output.write("    public void set"+StringUtils.capitalize(assocAttrName)+"("+assocClassFQN+"DTO[] values) {\n");
output.write("        "+assocClassFQN+"DTO[] oldValues = this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("        this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" = values;\n");
output.write("        p.firePropertyChange(\""+attrName+"\", oldValues, values);\n");
output.write("    }\n");
output.write("\n");
output.write("    public "+assocClassFQN+"DTO[] get"+StringUtils.capitalize(assocAttrName)+"() {\n");
output.write("        return this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("    }\n");
output.write("\n");
output.write("");
            	}
            }

        }

output.write("    \n");
output.write("    @Override\n");
output.write("    public String toString() {\n");
output.write("        String result = new ToStringBuilder(this).\n");
output.write("");
        for (Object o : clazz.getAttributes()) {
            ObjectModelAttribute attr = (ObjectModelAttribute) o;
            //FIXME possibilité de boucles (non directes)
            ObjectModelClass attrEntity = null;
            if (model.hasClass(attr.getType())) {
                attrEntity = model.getClass(attr.getType());
            }
            boolean isEntity = (attrEntity != null && attrEntity.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY));
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if ((isEntity && (reverse == null || !reverse.isNavigable()) && !attr.hasAssociationClass()) || (!isEntity)) {
            	String attrName = attr.getName();
output.write("            append(\""+attrName+"\", this."+attrName+").\n");
output.write("");
            }
        }
output.write("         toString();   \n");
output.write("        return result;\n");
output.write("    }\n");
output.write("\n");
output.write("} //"+clazzName+"DTO\n");
output.write("");
    }

    //TODO Check wether this method could be used to generate getter and setters
    protected void generateNormalGetterAndSetterWithPropertyChangeSupport(Writer output, String attrType, String attrName) throws IOException {
output.write("    public void set"+StringUtils.capitalize(attrName)+"("+attrType+" value) {\n");
output.write("        "+attrType+" _oldValue = this."+attrName+";\n");
output.write("        this."+attrName+" = value;\n");
output.write("        p.firePropertyChange(\""+attrName+"\", _oldValue, value);\n");
output.write("    }\n");
output.write("\n");
output.write("    public "+attrType+" get"+StringUtils.capitalize(attrName)+"() {\n");
output.write("        return this."+attrName+";\n");
output.write("    }\n");
output.write("\n");
output.write("");
    }

} //EntityDTOGenerator
