/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.RecursiveProperties;
import org.nuiton.util.Resource;

public class TopiaUtil {
    private static Log log = LogFactory.getLog(TopiaUtil.class);

    public static Properties getProperties(String pathOrUrl) throws TopiaNotFoundException {
        return TopiaUtil.getProperties(null, pathOrUrl);
    }

    public static Properties getProperties(Properties parent, String pathOrUrl) throws TopiaNotFoundException {
        RecursiveProperties result = new RecursiveProperties(parent);
        if (pathOrUrl != null && !pathOrUrl.equals("")) {
            try {
                URL propURL = Resource.getURL((String)pathOrUrl);
                log.info((Object)("Properties file used for " + pathOrUrl + " is: " + propURL));
                result.load(propURL.openStream());
            }
            catch (Exception eee) {
                throw new TopiaNotFoundException("Properties file can't be found: " + pathOrUrl, eee);
            }
        }
        return result;
    }

    public static Pattern getTopiaPattern(String format, Class<? extends TopiaEntity> ... classes) {
        String[] entityPatterns = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            Class<? extends TopiaEntity> aClass = classes[i];
            entityPatterns[i] = "(" + TopiaUtil.getTopiaIdPattern(aClass) + ")";
        }
        String s = String.format(format, entityPatterns);
        if (log.isDebugEnabled()) {
            log.debug((Object)s);
        }
        return Pattern.compile(s);
    }

    public static String getTopiaIdPattern(Class<? extends TopiaEntity> klass) {
        StringBuilder buffer = new StringBuilder();
        StringTokenizer stk = new StringTokenizer(klass.getName(), ".");
        while (stk.hasMoreTokens()) {
            buffer.append("\\.").append(stk.nextToken());
        }
        buffer.append("#(?:\\d+?)#(?:\\d+)\\.(?:\\d+)");
        return buffer.substring(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSchemaExist(Configuration configuration, String entityName) {
        boolean exist = false;
        try {
            PersistentClass classMapping = configuration.getClassMapping(entityName);
            if (classMapping == null) {
                Iterator itr = configuration.getClassMappings();
                while (itr.hasNext()) {
                    log.info((Object)("available mapping " + itr.next()));
                }
                throw new IllegalArgumentException("could not find entity with name " + entityName);
            }
            Table testTable = classMapping.getTable();
            if (testTable == null) {
                throw new IllegalArgumentException("could not find entity with name " + entityName);
            }
            ConnectionProvider connectionProvider = ConnectionProviderFactory.newConnectionProvider((Properties)configuration.getProperties());
            Dialect dialect = Dialect.getDialect((Properties)configuration.getProperties());
            Connection connection = null;
            try {
                connection = connectionProvider.getConnection();
                DatabaseMetadata meta = new DatabaseMetadata(connection, dialect);
                TableMetadata tmd = meta.getTableMetadata(testTable.getName(), testTable.getSchema(), testTable.getCatalog(), testTable.isQuoted());
                if (tmd != null) {
                    exist = true;
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"Cant connect to database", (Throwable)e);
        }
        return exist;
    }
}

