/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.nuiton.eugene.Generator;
import org.nuiton.eugene.ObjectModelGenerator;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.topia.generator.TopiaGeneratorUtil;

public class DAOImplGenerator
extends ObjectModelGenerator {
    public DAOImplGenerator() {
    }

    public DAOImplGenerator(Generator parent) {
        super(parent);
    }

    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + "DAOImpl.java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!clazz.hasStereotype("entity") || DAOImplGenerator.hasDAOOperations(clazz)) {
            return;
        }
        String copyright = TopiaGeneratorUtil.getCopyright((Model)this.model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
            output.write("" + copyright + "\n");
            output.write("");
        }
        String clazzName = clazz.getName();
        String clazzFQN = clazz.getQualifiedName();
        output.write("package " + clazz.getPackageName() + ";\n");
        output.write(" \n");
        output.write("/**\n");
        output.write(" * Implantation du DAO pour l'entit\u00e9 " + clazzName + ".\n");
        output.write(" * L'utilisateur peut remplacer cette classe par la sienne en la mettant \n");
        output.write(" * simplement dans ces sources. Cette classe g\u00e9n\u00e9r\u00e9e sera alors simplement\n");
        output.write(" * \u00e9cras\u00e9e.\n");
        output.write(" */\n");
        output.write("public class " + clazzName + "DAOImpl<E extends " + clazzName + "> extends " + clazzFQN + "DAOAbstract<E>  {\n");
        output.write("\n");
        output.write("} //" + clazzName + "DAO\n");
        output.write("");
    }

    public static boolean hasDAOOperations(ObjectModelClass clazz) {
        for (ObjectModelOperation op : clazz.getOperations()) {
            if (!op.hasStereotype("dao")) continue;
            return true;
        }
        return false;
    }
}

